#ifndef H_CDW_MKUDFFS_OPTIONS
#define H_CDW_MKUDFFS_OPTIONS

#include "main.h"
#include "cdw_form.h"
#include "cdw_udf.h"

/* Does not include extra field for guard. */
#define CDW_MKUDFFS_UDF_MAIN_OPTIONS_N_FIELDS   26
#define CDW_MKUDFFS_UDF_META_OPTIONS_N_FIELDS    6



#define CDW_MKUDFFS_BLOCKSIZE_MAX     4
enum {
	CDW_MKUDFFS_BLOCKSIZE_UNSPECIFIED = 0,
	CDW_MKUDFFS_BLOCKSIZE_1024,
	CDW_MKUDFFS_BLOCKSIZE_2048,
	CDW_MKUDFFS_BLOCKSIZE_4096
};

#define CDW_MKUDFFS_UDFREV_MAX       5
enum {
	CDW_MKUDFFS_UDFREV_UNSPECIFIED = 0,
	CDW_MKUDFFS_UDFREV_0x0201,
	CDW_MKUDFFS_UDFREV_0x0200,
	CDW_MKUDFFS_UDFREV_0x0150,
	CDW_MKUDFFS_UDFREV_0x0102
};

#define CDW_MKUDFFS_STRATEGY_MAX     3
enum {
	CDW_MKUDFFS_STRATEGY_UNSPECIFIED = 0,
	CDW_MKUDFFS_STRATEGY_4,
	CDW_MKUDFFS_STRATEGY_4096
};

#define CDW_MKUDFFS_SPARTABLE_MAX     5
enum {
	CDW_MKUDFFS_SPARTABLE_UNSPECIFIED = 0,
	CDW_MKUDFFS_SPARTABLE_1,
	CDW_MKUDFFS_SPARTABLE_2,
	CDW_MKUDFFS_SPARTABLE_3,
	CDW_MKUDFFS_SPARTABLE_4
};

#define CDW_MKUDFFS_MEDIA_TYPE_MAX     7
enum {
	CDW_MKUDFFS_MEDIA_TYPE_UNSPECIFIED = 0,
	CDW_MKUDFFS_MEDIA_TYPE_HD,
	CDW_MKUDFFS_MEDIA_TYPE_DVD,
	CDW_MKUDFFS_MEDIA_TYPE_DVDRAM,
	CDW_MKUDFFS_MEDIA_TYPE_WORM,
	CDW_MKUDFFS_MEDIA_TYPE_MO,
	CDW_MKUDFFS_MEDIA_TYPE_CDRW
};

#define CDW_MKUDFFS_SPACE_MAX     5
enum {
	CDW_MKUDFFS_SPACE_UNSPECIFIED = 0,
	CDW_MKUDFFS_SPACE_FREEDBITMAP,
	CDW_MKUDFFS_SPACE_FREEDTABLE,
	CDW_MKUDFFS_SPACE_UNALLOCBITMAP,
	CDW_MKUDFFS_SPACE_UNALLOCTABLE
};
#define CDW_MKUDFFS_AD_MAX     4
enum {
	CDW_MKUDFFS_AD_UNSPECIFIED = 0,
	CDW_MKUDFFS_AD_INICB,
	CDW_MKUDFFS_AD_SHORT,
	CDW_MKUDFFS_AD_LONG
};

#define CDW_MKUDFFS_ENCODING_MAX     4
enum {
	CDW_MKUDFFS_ENCODING_UNSPECIFIED = 0,
	CDW_MKUDFFS_ENCODING_U8,
	CDW_MKUDFFS_ENCODING_U16,
	CDW_MKUDFFS_ENCODING_UTF8
};


cdw_rv_t cdw_mkudffs_options_form_p1(cdw_form_t *cdw_form, void *cdw_udf, int first_col, int second_col, int width_wide, int width_narrow);
cdw_rv_t cdw_mkudffs_options_validate_p1(cdw_udf_t *udf, int *fi);
cdw_rv_t cdw_mkudffs_options_save_p1(cdw_udf_t *udf, cdw_form_t *cdw_form);

cdw_rv_t cdw_mkudffs_options_form_p2(cdw_form_t *cdw_form, void *cdw_udf, int first_col, int second_col, int width_wide, int width_narrow);
cdw_rv_t cdw_mkudffs_options_validate_p2(cdw_udf_t *udf, int *fi);
cdw_rv_t cdw_mkudffs_options_save_p2(cdw_udf_t *udf, cdw_form_t *cdw_form);



#endif /* H_CDW_MKUDFFS_OPTIONS */
