(define-library (pingala test-map)
  (export test-map test-exit)
  (import (scheme base) (scheme write) (scheme process-context))
  (begin
    (define failed? #f)
    (define (fail expected res)
      (set! failed? #t)
      (display "FAIL: expected ")
      (write expected)
      (display " but got ")
      (write res)
      (newline))
    (define (test-exit) (exit (if failed? 1 0)))
    (define-syntax test-map
      (syntax-rules ()
        ((test-map expected proc values)
         (let ((res (map proc 'values)))
           (if (not (equal? res 'expected))
               (fail 'expected res))))))))
