/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends ChildNode {
    static final long serialVersionUID = 7931170150428474230L;
    protected String data;
    private static transient NodeList singletonNodeList = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }
    };

    protected CharacterDataImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl);
        this.data = string;
    }

    public void appendData(String string) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.setNodeValue(String.valueOf(this.data) + string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (n2 < 0) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = Math.max(this.data.length() - n2 - n, 0);
        try {
            String string = String.valueOf(this.data.substring(0, n)) + (n3 > 0 ? this.data.substring(n + n2, n + n2 + n3) : "");
            this.setNodeValueInternal(string);
            this.ownerDocument().deletedText(this, n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
    }

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getData() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public int getLength() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data.length();
    }

    public String getNodeValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public void insertData(int n, String string) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            String string2 = new StringBuffer(this.data).insert(n, string).toString();
            this.setNodeValueInternal(string2);
            this.ownerDocument().insertedText(this, n, string.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.deleteData(n, n2);
        this.insertData(n, string);
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public void setNodeValue(String string) {
        this.setNodeValueInternal(string);
        this.ownerDocument().replacedText(this);
    }

    protected void setNodeValueInternal(String string) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = this.data;
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        coreDocumentImpl.modifyingCharacterData(this);
        this.data = string;
        coreDocumentImpl.modifiedCharacterData(this, string2, string);
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = this.data.length();
        if (n2 < 0 || n < 0 || n > n3 - 1) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
        int n4 = Math.min(n + n2, n3);
        return this.data.substring(n, n4);
    }
}

