/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.util.Comparison;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SequenceRenderer {
    AlignViewport av;
    FontMetrics fm;
    boolean renderGaps = true;
    SequenceGroup currentSequenceGroup = null;
    SequenceGroup[] allGroups = null;
    Color resBoxColour;
    Graphics graphics;
    boolean forOverview = false;

    public SequenceRenderer(AlignViewport av) {
        this.av = av;
    }

    public void prepare(Graphics g, boolean renderGaps) {
        this.graphics = g;
        this.fm = g.getFontMetrics();
        this.renderGaps = renderGaps;
    }

    public Color getResidueBoxColour(SequenceI seq, int i) {
        this.allGroups = this.av.alignment.findAllGroups(seq);
        if (this.inCurrentSequenceGroup(i)) {
            if (this.currentSequenceGroup.getDisplayBoxes()) {
                this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
            }
        } else if (this.av.getShowBoxes()) {
            this.getBoxColour(this.av.globalColourScheme, seq, i);
        }
        return this.resBoxColour;
    }

    void getBoxColour(ColourSchemeI cs, SequenceI seq, int i) {
        this.resBoxColour = cs != null ? cs.findColour(seq.getCharAt(i), i) : (this.forOverview && !Comparison.isGap(seq.getCharAt(i)) ? Color.lightGray : Color.white);
    }

    public Color findSequenceColour(SequenceI seq, int i) {
        this.allGroups = this.av.alignment.findAllGroups(seq);
        this.drawBoxes(seq, i, i, 0);
        return this.resBoxColour;
    }

    public void drawSequence(SequenceI seq, SequenceGroup[] sg, int start, int end, int y1) {
        if (seq == null) {
            return;
        }
        this.allGroups = sg;
        this.drawBoxes(seq, start, end, y1);
        if (this.av.validCharWidth) {
            this.drawText(seq, start, end, y1);
        }
    }

    public void drawBoxes(SequenceI seq, int start, int end, int y1) {
        int length = seq.getLength();
        int curStart = -1;
        int curWidth = this.av.charWidth;
        Color tempColour = null;
        for (int i = start; i <= end; ++i) {
            this.resBoxColour = Color.white;
            if (i < length) {
                if (this.inCurrentSequenceGroup(i)) {
                    if (this.currentSequenceGroup.getDisplayBoxes()) {
                        this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
                    }
                } else if (this.av.getShowBoxes()) {
                    this.getBoxColour(this.av.getGlobalColourScheme(), seq, i);
                }
            }
            if (this.resBoxColour != tempColour) {
                if (tempColour != null) {
                    this.graphics.fillRect(this.av.charWidth * (curStart - start), y1, curWidth, this.av.charHeight);
                }
                this.graphics.setColor(this.resBoxColour);
                curStart = i;
                curWidth = this.av.charWidth;
                tempColour = this.resBoxColour;
                continue;
            }
            curWidth += this.av.charWidth;
        }
        this.graphics.fillRect(this.av.charWidth * (curStart - start), y1, curWidth, this.av.charHeight);
    }

    public void drawText(SequenceI seq, int start, int end, int y1) {
        Font boldFont = null;
        boolean bold = false;
        if (this.av.upperCasebold) {
            boldFont = new Font(this.av.getFont().getName(), 1, this.av.charHeight);
            this.graphics.setFont(this.av.getFont());
        }
        y1 += this.av.charHeight - this.av.charHeight / 5;
        int charOffset = 0;
        if (end + 1 >= seq.getLength()) {
            end = seq.getLength() - 1;
        }
        char s = ' ';
        for (int i = start; i <= end; ++i) {
            this.graphics.setColor(Color.black);
            s = seq.getCharAt(i);
            if (!this.renderGaps && Comparison.isGap(s)) continue;
            if (this.inCurrentSequenceGroup(i)) {
                if (!this.currentSequenceGroup.getDisplayText()) continue;
                if (this.currentSequenceGroup.getColourText()) {
                    this.getBoxColour(this.currentSequenceGroup.cs, seq, i);
                    this.graphics.setColor(this.resBoxColour.darker());
                }
            } else {
                if (!this.av.getShowText()) continue;
                if (this.av.getColourText()) {
                    this.getBoxColour(this.av.getGlobalColourScheme(), seq, i);
                    if (this.av.getShowBoxes()) {
                        this.graphics.setColor(this.resBoxColour.darker());
                    } else {
                        this.graphics.setColor(this.resBoxColour);
                    }
                }
            }
            if (this.av.upperCasebold) {
                this.fm = this.graphics.getFontMetrics();
                if ('A' <= s && s <= 'Z') {
                    if (!bold) {
                        this.graphics.setFont(boldFont);
                    }
                    bold = true;
                } else if (bold) {
                    this.graphics.setFont(this.av.font);
                    bold = false;
                }
            }
            charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
            this.graphics.drawString(String.valueOf(s), charOffset + this.av.charWidth * (i - start), y1);
        }
    }

    boolean inCurrentSequenceGroup(int res) {
        if (this.allGroups == null) {
            return false;
        }
        for (int i = 0; i < this.allGroups.length; ++i) {
            if (this.allGroups[i].getStartRes() > res || this.allGroups[i].getEndRes() < res) continue;
            this.currentSequenceGroup = this.allGroups[i];
            return true;
        }
        return false;
    }

    public void drawHighlightedText(SequenceI seq, int start, int end, int x1, int y1) {
        int pady = this.av.charHeight / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(x1, y1, this.av.charWidth * (end - start + 1), this.av.charHeight);
        this.graphics.setColor(Color.white);
        char s = '~';
        if (this.av.validCharWidth) {
            for (int i = start; i <= end; ++i) {
                if (i < seq.getLength()) {
                    s = seq.getCharAt(i);
                }
                charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + x1 + this.av.charWidth * (i - start), y1 + this.av.charHeight - pady);
            }
        }
    }

    public void drawCursor(SequenceI seq, int res, int x1, int y1) {
        int pady = this.av.charHeight / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(x1, y1, this.av.charWidth, this.av.charHeight);
        this.graphics.setColor(Color.white);
        this.graphics.setColor(Color.white);
        char s = seq.getCharAt(res);
        if (this.av.validCharWidth) {
            charOffset = (this.av.charWidth - this.fm.charWidth(s)) / 2;
            this.graphics.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.charHeight - pady);
        }
    }
}

