/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file xml.h
 * \brief XML node header
 */

#ifndef XML_H
#define XML_H

typedef enum _XMLNodeType {
	XMLNODE_TYPE_TAG,
	XMLNODE_TYPE_ATTRIB,
	XMLNODE_TYPE_DATA
} XMLNodeType;

typedef struct sXmlNode {
	char *pnName;
	char *pnXmlNs;
	XMLNodeType nType;
	char *pnData;
	size_t nDataSize;
	struct sXmlNode *psParent;
	struct sXmlNode *psChild;
	struct sXmlNode *psLastChild;
	struct sXmlNode *psNext;
	char *pnPrefix;
	GHashTable *psNameSpaceMap;
} xmlnode;

xmlnode *xmlnode_new( const char *pnName );
xmlnode *xmlnode_new_child( xmlnode *psParent, const char *pnName );
xmlnode *readXmlFromFile( const char *pnFileName, const char *pnDescription );
xmlnode *xmlnode_get_child(const xmlnode *parent, const char *name);
xmlnode *xmlnode_get_next_twin(xmlnode *node);
char *xmlnode_get_data(xmlnode *node);
const char *xmlnode_get_attrib( xmlnode *psNode, const char *pnAttr );
void xmlnode_insert_data( xmlnode *psNode, const char *pnData, gssize nSize );

#endif
