
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkDiskCache.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QNetworkDiskCache>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QNetworkCacheMetaData>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkDiskCache

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkDiskCache::staticMetaObject);
}


// QString QNetworkDiskCache::cacheDirectory()


static void _init_f_cacheDirectory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_cacheDirectory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QNetworkDiskCache *)cls)->cacheDirectory ());
}


// qint64 QNetworkDiskCache::cacheSize()


static void _init_f_cacheSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QNetworkDiskCache *)cls)->cacheSize ());
}


// void QNetworkDiskCache::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache *)cls)->clear ();
}


// QIODevice *QNetworkDiskCache::data(const QUrl &url)


static void _init_f_data_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_f_data_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QIODevice * > ((QIODevice *)((QNetworkDiskCache *)cls)->data (arg1));
}


// QNetworkCacheMetaData QNetworkDiskCache::fileMetaData(const QString &fileName)


static void _init_f_fileMetaData_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QNetworkCacheMetaData > ();
}

static void _call_f_fileMetaData_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QNetworkCacheMetaData > ((QNetworkCacheMetaData)((QNetworkDiskCache *)cls)->fileMetaData (arg1));
}


// void QNetworkDiskCache::insert(QIODevice *device)


static void _init_f_insert_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insert_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache *)cls)->insert (arg1);
}


// qint64 QNetworkDiskCache::maximumCacheSize()


static void _init_f_maximumCacheSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_maximumCacheSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QNetworkDiskCache *)cls)->maximumCacheSize ());
}


// QNetworkCacheMetaData QNetworkDiskCache::metaData(const QUrl &url)


static void _init_f_metaData_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QNetworkCacheMetaData > ();
}

static void _call_f_metaData_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QNetworkCacheMetaData > ((QNetworkCacheMetaData)((QNetworkDiskCache *)cls)->metaData (arg1));
}


// QIODevice *QNetworkDiskCache::prepare(const QNetworkCacheMetaData &metaData)


static void _init_f_prepare_3377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_f_prepare_3377 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = gsi::arg_reader<const QNetworkCacheMetaData & >() (args, heap);
  ret.write<QIODevice * > ((QIODevice *)((QNetworkDiskCache *)cls)->prepare (arg1));
}


// bool QNetworkDiskCache::remove(const QUrl &url)


static void _init_f_remove_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QNetworkDiskCache *)cls)->remove (arg1));
}


// void QNetworkDiskCache::setCacheDirectory(const QString &cacheDir)


static void _init_f_setCacheDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cacheDir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheDirectory_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache *)cls)->setCacheDirectory (arg1);
}


// void QNetworkDiskCache::setMaximumCacheSize(qint64 size)


static void _init_f_setMaximumCacheSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumCacheSize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache *)cls)->setMaximumCacheSize (arg1);
}


// void QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData &metaData)


static void _init_f_updateMetaData_3377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateMetaData_3377 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = gsi::arg_reader<const QNetworkCacheMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache *)cls)->updateMetaData (arg1);
}


// static QString QNetworkDiskCache::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkDiskCache::tr (arg1, arg2, arg3));
}


// static QString QNetworkDiskCache::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkDiskCache::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QNetworkDiskCache () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":cacheDirectory", "@brief Method QString QNetworkDiskCache::cacheDirectory()\n", true, &_init_f_cacheDirectory_c0, &_call_f_cacheDirectory_c0);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@brief Method qint64 QNetworkDiskCache::cacheSize()\nThis is a reimplementation of QAbstractNetworkCache::cacheSize", true, &_init_f_cacheSize_c0, &_call_f_cacheSize_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QNetworkDiskCache::clear()\nThis is a reimplementation of QAbstractNetworkCache::clear", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QIODevice *QNetworkDiskCache::data(const QUrl &url)\nThis is a reimplementation of QAbstractNetworkCache::data", false, &_init_f_data_1701, &_call_f_data_1701);
  methods += new qt_gsi::GenericMethod ("fileMetaData", "@brief Method QNetworkCacheMetaData QNetworkDiskCache::fileMetaData(const QString &fileName)\n", true, &_init_f_fileMetaData_c2025, &_call_f_fileMetaData_c2025);
  methods += new qt_gsi::GenericMethod ("insert", "@brief Method void QNetworkDiskCache::insert(QIODevice *device)\nThis is a reimplementation of QAbstractNetworkCache::insert", false, &_init_f_insert_1447, &_call_f_insert_1447);
  methods += new qt_gsi::GenericMethod (":maximumCacheSize", "@brief Method qint64 QNetworkDiskCache::maximumCacheSize()\n", true, &_init_f_maximumCacheSize_c0, &_call_f_maximumCacheSize_c0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QNetworkCacheMetaData QNetworkDiskCache::metaData(const QUrl &url)\nThis is a reimplementation of QAbstractNetworkCache::metaData", false, &_init_f_metaData_1701, &_call_f_metaData_1701);
  methods += new qt_gsi::GenericMethod ("prepare", "@brief Method QIODevice *QNetworkDiskCache::prepare(const QNetworkCacheMetaData &metaData)\nThis is a reimplementation of QAbstractNetworkCache::prepare", false, &_init_f_prepare_3377, &_call_f_prepare_3377);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Method bool QNetworkDiskCache::remove(const QUrl &url)\nThis is a reimplementation of QAbstractNetworkCache::remove", false, &_init_f_remove_1701, &_call_f_remove_1701);
  methods += new qt_gsi::GenericMethod ("setCacheDirectory|cacheDirectory=", "@brief Method void QNetworkDiskCache::setCacheDirectory(const QString &cacheDir)\n", false, &_init_f_setCacheDirectory_2025, &_call_f_setCacheDirectory_2025);
  methods += new qt_gsi::GenericMethod ("setMaximumCacheSize|maximumCacheSize=", "@brief Method void QNetworkDiskCache::setMaximumCacheSize(qint64 size)\n", false, &_init_f_setMaximumCacheSize_986, &_call_f_setMaximumCacheSize_986);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@brief Method void QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData &metaData)\nThis is a reimplementation of QAbstractNetworkCache::updateMetaData", false, &_init_f_updateMetaData_3377, &_call_f_updateMetaData_3377);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QNetworkDiskCache::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QNetworkDiskCache::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkDiskCache::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkDiskCache::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractNetworkCache> &qtdecl_QAbstractNetworkCache ();

qt_gsi::QtNativeClass<QNetworkDiskCache> decl_QNetworkDiskCache (qtdecl_QAbstractNetworkCache (), "QtNetwork", "QNetworkDiskCache_Native",
  methods_QNetworkDiskCache (),
  "@hide\n@alias QNetworkDiskCache");

GSI_QTNETWORK_PUBLIC gsi::Class<QNetworkDiskCache> &qtdecl_QNetworkDiskCache () { return decl_QNetworkDiskCache; }

}


class QNetworkDiskCache_Adaptor : public QNetworkDiskCache, public qt_gsi::QtObjectBase
{
public:

  virtual ~QNetworkDiskCache_Adaptor();

  //  [adaptor ctor] QNetworkDiskCache::QNetworkDiskCache(QObject *parent)
  QNetworkDiskCache_Adaptor() : QNetworkDiskCache()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QNetworkDiskCache::QNetworkDiskCache(QObject *parent)
  QNetworkDiskCache_Adaptor(QObject *parent) : QNetworkDiskCache(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QNetworkDiskCache::isSignalConnected(const QMetaMethod &signal)
  bool fp_QNetworkDiskCache_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QNetworkDiskCache::isSignalConnected(signal);
  }

  //  [expose] int QNetworkDiskCache::receivers(const char *signal)
  int fp_QNetworkDiskCache_receivers_c1731 (const char *signal) const {
    return QNetworkDiskCache::receivers(signal);
  }

  //  [expose] QObject *QNetworkDiskCache::sender()
  QObject * fp_QNetworkDiskCache_sender_c0 () const {
    return QNetworkDiskCache::sender();
  }

  //  [expose] int QNetworkDiskCache::senderSignalIndex()
  int fp_QNetworkDiskCache_senderSignalIndex_c0 () const {
    return QNetworkDiskCache::senderSignalIndex();
  }

  //  [adaptor impl] qint64 QNetworkDiskCache::cacheSize()
  qint64 cbs_cacheSize_c0_0() const
  {
    return QNetworkDiskCache::cacheSize();
  }

  virtual qint64 cacheSize() const
  {
    if (cb_cacheSize_c0_0.can_issue()) {
      return cb_cacheSize_c0_0.issue<QNetworkDiskCache_Adaptor, qint64>(&QNetworkDiskCache_Adaptor::cbs_cacheSize_c0_0);
    } else {
      return QNetworkDiskCache::cacheSize();
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::clear()
  void cbs_clear_0_0()
  {
    QNetworkDiskCache::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QNetworkDiskCache_Adaptor>(&QNetworkDiskCache_Adaptor::cbs_clear_0_0);
    } else {
      QNetworkDiskCache::clear();
    }
  }

  //  [adaptor impl] QIODevice *QNetworkDiskCache::data(const QUrl &url)
  QIODevice * cbs_data_1701_0(const QUrl &url)
  {
    return QNetworkDiskCache::data(url);
  }

  virtual QIODevice * data(const QUrl &url)
  {
    if (cb_data_1701_0.can_issue()) {
      return cb_data_1701_0.issue<QNetworkDiskCache_Adaptor, QIODevice *, const QUrl &>(&QNetworkDiskCache_Adaptor::cbs_data_1701_0, url);
    } else {
      return QNetworkDiskCache::data(url);
    }
  }

  //  [emitter impl] void QNetworkDiskCache::destroyed(QObject *)
  void emitter_QNetworkDiskCache_destroyed_1302(QObject *arg1)
  {
    emit QNetworkDiskCache::destroyed(arg1);
  }

  //  [adaptor impl] bool QNetworkDiskCache::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QNetworkDiskCache::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QNetworkDiskCache_Adaptor, bool, QEvent *>(&QNetworkDiskCache_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QNetworkDiskCache::event(arg1);
    }
  }

  //  [adaptor impl] bool QNetworkDiskCache::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QNetworkDiskCache::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QNetworkDiskCache_Adaptor, bool, QObject *, QEvent *>(&QNetworkDiskCache_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QNetworkDiskCache::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::insert(QIODevice *device)
  void cbs_insert_1447_0(QIODevice *device)
  {
    QNetworkDiskCache::insert(device);
  }

  virtual void insert(QIODevice *device)
  {
    if (cb_insert_1447_0.can_issue()) {
      cb_insert_1447_0.issue<QNetworkDiskCache_Adaptor, QIODevice *>(&QNetworkDiskCache_Adaptor::cbs_insert_1447_0, device);
    } else {
      QNetworkDiskCache::insert(device);
    }
  }

  //  [adaptor impl] QNetworkCacheMetaData QNetworkDiskCache::metaData(const QUrl &url)
  QNetworkCacheMetaData cbs_metaData_1701_0(const QUrl &url)
  {
    return QNetworkDiskCache::metaData(url);
  }

  virtual QNetworkCacheMetaData metaData(const QUrl &url)
  {
    if (cb_metaData_1701_0.can_issue()) {
      return cb_metaData_1701_0.issue<QNetworkDiskCache_Adaptor, QNetworkCacheMetaData, const QUrl &>(&QNetworkDiskCache_Adaptor::cbs_metaData_1701_0, url);
    } else {
      return QNetworkDiskCache::metaData(url);
    }
  }

  //  [emitter impl] void QNetworkDiskCache::objectNameChanged(const QString &objectName)
  void emitter_QNetworkDiskCache_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QNetworkDiskCache::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QIODevice *QNetworkDiskCache::prepare(const QNetworkCacheMetaData &metaData)
  QIODevice * cbs_prepare_3377_0(const QNetworkCacheMetaData &metaData)
  {
    return QNetworkDiskCache::prepare(metaData);
  }

  virtual QIODevice * prepare(const QNetworkCacheMetaData &metaData)
  {
    if (cb_prepare_3377_0.can_issue()) {
      return cb_prepare_3377_0.issue<QNetworkDiskCache_Adaptor, QIODevice *, const QNetworkCacheMetaData &>(&QNetworkDiskCache_Adaptor::cbs_prepare_3377_0, metaData);
    } else {
      return QNetworkDiskCache::prepare(metaData);
    }
  }

  //  [adaptor impl] bool QNetworkDiskCache::remove(const QUrl &url)
  bool cbs_remove_1701_0(const QUrl &url)
  {
    return QNetworkDiskCache::remove(url);
  }

  virtual bool remove(const QUrl &url)
  {
    if (cb_remove_1701_0.can_issue()) {
      return cb_remove_1701_0.issue<QNetworkDiskCache_Adaptor, bool, const QUrl &>(&QNetworkDiskCache_Adaptor::cbs_remove_1701_0, url);
    } else {
      return QNetworkDiskCache::remove(url);
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData &metaData)
  void cbs_updateMetaData_3377_0(const QNetworkCacheMetaData &metaData)
  {
    QNetworkDiskCache::updateMetaData(metaData);
  }

  virtual void updateMetaData(const QNetworkCacheMetaData &metaData)
  {
    if (cb_updateMetaData_3377_0.can_issue()) {
      cb_updateMetaData_3377_0.issue<QNetworkDiskCache_Adaptor, const QNetworkCacheMetaData &>(&QNetworkDiskCache_Adaptor::cbs_updateMetaData_3377_0, metaData);
    } else {
      QNetworkDiskCache::updateMetaData(metaData);
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QNetworkDiskCache::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QNetworkDiskCache_Adaptor, QChildEvent *>(&QNetworkDiskCache_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QNetworkDiskCache::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QNetworkDiskCache::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QNetworkDiskCache_Adaptor, QEvent *>(&QNetworkDiskCache_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QNetworkDiskCache::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QNetworkDiskCache::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QNetworkDiskCache_Adaptor, const QMetaMethod &>(&QNetworkDiskCache_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QNetworkDiskCache::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] qint64 QNetworkDiskCache::expire()
  qint64 cbs_expire_0_0()
  {
    return QNetworkDiskCache::expire();
  }

  virtual qint64 expire()
  {
    if (cb_expire_0_0.can_issue()) {
      return cb_expire_0_0.issue<QNetworkDiskCache_Adaptor, qint64>(&QNetworkDiskCache_Adaptor::cbs_expire_0_0);
    } else {
      return QNetworkDiskCache::expire();
    }
  }

  //  [adaptor impl] void QNetworkDiskCache::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QNetworkDiskCache::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QNetworkDiskCache_Adaptor, QTimerEvent *>(&QNetworkDiskCache_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QNetworkDiskCache::timerEvent(arg1);
    }
  }

  gsi::Callback cb_cacheSize_c0_0;
  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_data_1701_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_insert_1447_0;
  gsi::Callback cb_metaData_1701_0;
  gsi::Callback cb_prepare_3377_0;
  gsi::Callback cb_remove_1701_0;
  gsi::Callback cb_updateMetaData_3377_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_expire_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QNetworkDiskCache_Adaptor::~QNetworkDiskCache_Adaptor() { }

//  Constructor QNetworkDiskCache::QNetworkDiskCache(QObject *parent) (adaptor class)

static void _init_ctor_QNetworkDiskCache_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QNetworkDiskCache_Adaptor> ();
}

static void _call_ctor_QNetworkDiskCache_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QNetworkDiskCache_Adaptor *> (new QNetworkDiskCache_Adaptor (arg1));
}


// qint64 QNetworkDiskCache::cacheSize()

static void _init_cbs_cacheSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_cacheSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QNetworkDiskCache_Adaptor *)cls)->cbs_cacheSize_c0_0 ());
}

static void _set_callback_cbs_cacheSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_cacheSize_c0_0 = cb;
}


// void QNetworkDiskCache::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QNetworkDiskCache::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// void QNetworkDiskCache::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QIODevice *QNetworkDiskCache::data(const QUrl &url)

static void _init_cbs_data_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_data_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QIODevice * > ((QIODevice *)((QNetworkDiskCache_Adaptor *)cls)->cbs_data_1701_0 (arg1));
}

static void _set_callback_cbs_data_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_data_1701_0 = cb;
}


// emitter void QNetworkDiskCache::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QNetworkDiskCache_Adaptor *)cls)->emitter_QNetworkDiskCache_destroyed_1302 (arg1);
}


// void QNetworkDiskCache::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QNetworkDiskCache::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkDiskCache_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QNetworkDiskCache::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkDiskCache_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// qint64 QNetworkDiskCache::expire()

static void _init_cbs_expire_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_expire_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QNetworkDiskCache_Adaptor *)cls)->cbs_expire_0_0 ());
}

static void _set_callback_cbs_expire_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_expire_0_0 = cb;
}


// void QNetworkDiskCache::insert(QIODevice *device)

static void _init_cbs_insert_1447_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_insert_1447_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_insert_1447_0 (arg1);
}

static void _set_callback_cbs_insert_1447_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_insert_1447_0 = cb;
}


// exposed bool QNetworkDiskCache::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QNetworkDiskCache_Adaptor *)cls)->fp_QNetworkDiskCache_isSignalConnected_c2394 (arg1));
}


// QNetworkCacheMetaData QNetworkDiskCache::metaData(const QUrl &url)

static void _init_cbs_metaData_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QNetworkCacheMetaData > ();
}

static void _call_cbs_metaData_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QNetworkCacheMetaData > ((QNetworkCacheMetaData)((QNetworkDiskCache_Adaptor *)cls)->cbs_metaData_1701_0 (arg1));
}

static void _set_callback_cbs_metaData_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_metaData_1701_0 = cb;
}


// emitter void QNetworkDiskCache::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QNetworkDiskCache_Adaptor *)cls)->emitter_QNetworkDiskCache_objectNameChanged_4567 (arg1);
}


// QIODevice *QNetworkDiskCache::prepare(const QNetworkCacheMetaData &metaData)

static void _init_cbs_prepare_3377_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_prepare_3377_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = args.read<const QNetworkCacheMetaData & > (heap);
  ret.write<QIODevice * > ((QIODevice *)((QNetworkDiskCache_Adaptor *)cls)->cbs_prepare_3377_0 (arg1));
}

static void _set_callback_cbs_prepare_3377_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_prepare_3377_0 = cb;
}


// exposed int QNetworkDiskCache::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QNetworkDiskCache_Adaptor *)cls)->fp_QNetworkDiskCache_receivers_c1731 (arg1));
}


// bool QNetworkDiskCache::remove(const QUrl &url)

static void _init_cbs_remove_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_remove_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QNetworkDiskCache_Adaptor *)cls)->cbs_remove_1701_0 (arg1));
}

static void _set_callback_cbs_remove_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_remove_1701_0 = cb;
}


// exposed QObject *QNetworkDiskCache::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QNetworkDiskCache_Adaptor *)cls)->fp_QNetworkDiskCache_sender_c0 ());
}


// exposed int QNetworkDiskCache::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QNetworkDiskCache_Adaptor *)cls)->fp_QNetworkDiskCache_senderSignalIndex_c0 ());
}


// void QNetworkDiskCache::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData &metaData)

static void _init_cbs_updateMetaData_3377_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateMetaData_3377_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = args.read<const QNetworkCacheMetaData & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkDiskCache_Adaptor *)cls)->cbs_updateMetaData_3377_0 (arg1);
}

static void _set_callback_cbs_updateMetaData_3377_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkDiskCache_Adaptor *)cls)->cb_updateMetaData_3377_0 = cb;
}


namespace gsi
{

gsi::Class<QNetworkDiskCache> &qtdecl_QNetworkDiskCache ();

static gsi::Methods methods_QNetworkDiskCache_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkDiskCache::QNetworkDiskCache(QObject *parent)\nThis method creates an object of class QNetworkDiskCache.", &_init_ctor_QNetworkDiskCache_Adaptor_1302, &_call_ctor_QNetworkDiskCache_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@brief Virtual method qint64 QNetworkDiskCache::cacheSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cacheSize_c0_0, &_call_cbs_cacheSize_c0_0);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@hide", true, &_init_cbs_cacheSize_c0_0, &_call_cbs_cacheSize_c0_0, &_set_callback_cbs_cacheSize_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QNetworkDiskCache::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QNetworkDiskCache::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QNetworkDiskCache::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QIODevice *QNetworkDiskCache::data(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_data_1701_0, &_call_cbs_data_1701_0);
  methods += new qt_gsi::GenericMethod ("data", "@hide", false, &_init_cbs_data_1701_0, &_call_cbs_data_1701_0, &_set_callback_cbs_data_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QNetworkDiskCache::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QNetworkDiskCache::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QNetworkDiskCache::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QNetworkDiskCache::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*expire", "@brief Virtual method qint64 QNetworkDiskCache::expire()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_expire_0_0, &_call_cbs_expire_0_0);
  methods += new qt_gsi::GenericMethod ("*expire", "@hide", false, &_init_cbs_expire_0_0, &_call_cbs_expire_0_0, &_set_callback_cbs_expire_0_0);
  methods += new qt_gsi::GenericMethod ("insert", "@brief Virtual method void QNetworkDiskCache::insert(QIODevice *device)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insert_1447_0, &_call_cbs_insert_1447_0);
  methods += new qt_gsi::GenericMethod ("insert", "@hide", false, &_init_cbs_insert_1447_0, &_call_cbs_insert_1447_0, &_set_callback_cbs_insert_1447_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QNetworkDiskCache::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Virtual method QNetworkCacheMetaData QNetworkDiskCache::metaData(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_metaData_1701_0, &_call_cbs_metaData_1701_0);
  methods += new qt_gsi::GenericMethod ("metaData", "@hide", false, &_init_cbs_metaData_1701_0, &_call_cbs_metaData_1701_0, &_set_callback_cbs_metaData_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QNetworkDiskCache::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("prepare", "@brief Virtual method QIODevice *QNetworkDiskCache::prepare(const QNetworkCacheMetaData &metaData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_prepare_3377_0, &_call_cbs_prepare_3377_0);
  methods += new qt_gsi::GenericMethod ("prepare", "@hide", false, &_init_cbs_prepare_3377_0, &_call_cbs_prepare_3377_0, &_set_callback_cbs_prepare_3377_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QNetworkDiskCache::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Virtual method bool QNetworkDiskCache::remove(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_remove_1701_0, &_call_cbs_remove_1701_0);
  methods += new qt_gsi::GenericMethod ("remove", "@hide", false, &_init_cbs_remove_1701_0, &_call_cbs_remove_1701_0, &_set_callback_cbs_remove_1701_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QNetworkDiskCache::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QNetworkDiskCache::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QNetworkDiskCache::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@brief Virtual method void QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData &metaData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateMetaData_3377_0, &_call_cbs_updateMetaData_3377_0);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@hide", false, &_init_cbs_updateMetaData_3377_0, &_call_cbs_updateMetaData_3377_0, &_set_callback_cbs_updateMetaData_3377_0);
  return methods;
}

gsi::Class<QNetworkDiskCache_Adaptor> decl_QNetworkDiskCache_Adaptor (qtdecl_QNetworkDiskCache (), "QtNetwork", "QNetworkDiskCache",
  methods_QNetworkDiskCache_Adaptor (),
  "@qt\n@brief Binding of QNetworkDiskCache");

}

