/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import java.lang.reflect.Method;

public class SignatureUtil {
    public static String[] toSignature(String[] simpleNames) {
        String[] signatures = new String[simpleNames.length];
        for (int i = 0; i < signatures.length; ++i) {
            signatures[i] = SignatureUtil.toSignature(simpleNames[i]);
        }
        return signatures;
    }

    public static String getSignature(Method m) {
        Class<?>[] parameterClasses = m.getParameterTypes();
        Class<?> returnTypeClass = m.getReturnType();
        String[] parameterNames = new String[parameterClasses.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterNames[i] = parameterClasses[i].getName();
        }
        try {
            return null;
        }
        catch (ClassFormatError cfe) {
            return null;
        }
    }

    public static boolean isPrimitive(String simpleName) {
        if (simpleName.indexOf(46) != -1) {
            return false;
        }
        if (simpleName.startsWith("int")) {
            return true;
        }
        if (simpleName.startsWith("long")) {
            return true;
        }
        if (simpleName.startsWith("char")) {
            return true;
        }
        if (simpleName.startsWith("boolean")) {
            return true;
        }
        if (simpleName.startsWith("byte")) {
            return true;
        }
        if (simpleName.startsWith("float")) {
            return true;
        }
        return simpleName.startsWith("double");
    }

    public static String toSignature(String simpleName) {
        StringBuffer signature = new StringBuffer();
        boolean isArray = false;
        for (int i = 0; i < simpleName.length(); ++i) {
            if (simpleName.charAt(i) != '[') continue;
            signature.append("[");
            isArray = true;
        }
        if (simpleName.startsWith("int")) {
            signature.append("I");
        } else if (simpleName.startsWith("long")) {
            signature.append("J");
        } else if (simpleName.startsWith("char")) {
            signature.append("C");
        } else if (simpleName.startsWith("boolean")) {
            signature.append("Z");
        } else if (simpleName.startsWith("byte")) {
            signature.append("B");
        } else if (simpleName.startsWith("float")) {
            signature.append("F");
        } else if (simpleName.startsWith("double")) {
            signature.append("D");
        } else if (simpleName.startsWith("void")) {
            signature.append("V");
        } else {
            signature.append('L');
            if (isArray) {
                simpleName = simpleName.substring(0, simpleName.indexOf(91)).trim();
            }
            signature.append(simpleName.replace('.', '/'));
            signature.append(';');
        }
        return signature.toString();
    }

    public static String[] toSimpleName(String[] signatures) {
        String[] simpleNames = new String[signatures.length];
        for (int i = 0; i < simpleNames.length; ++i) {
            simpleNames[i] = SignatureUtil.toSimpleName(signatures[i]);
        }
        return simpleNames;
    }

    public static String toSimpleName(String signature) {
        int index = signature.lastIndexOf(91);
        String typeName = null;
        typeName = index != -1 ? (signature.lastIndexOf(59) != -1 ? signature.substring(index + 1, signature.length() - 1) : signature.substring(index + 1, signature.length())) : (signature.lastIndexOf(59) != -1 ? signature.substring(0, signature.length() - 1) : signature);
        char ch = typeName.charAt(0);
        switch (ch) {
            case 'L': {
                typeName = typeName.substring(1);
                typeName = typeName.replace('/', '.');
                break;
            }
            case 'I': {
                typeName = "int";
                break;
            }
            case 'J': {
                typeName = "long";
                break;
            }
            case 'C': {
                typeName = "char";
                break;
            }
            case 'Z': {
                typeName = "boolean";
                break;
            }
            case 'B': {
                typeName = "byte";
                break;
            }
            case 'F': {
                typeName = "float";
                break;
            }
            case 'D': {
                typeName = "double";
                break;
            }
            case 'V': {
                typeName = "void";
                break;
            }
            default: {
                System.out.println("error: " + typeName);
            }
        }
        if (index != -1) {
            StringBuffer sb = new StringBuffer(typeName);
            for (int i = 0; i <= index; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
        return typeName;
    }

    public static String toMethodSignature(String returnType, String[] paramTypes) {
        String signatureReturnType = SignatureUtil.toSignature(returnType);
        String[] signatureParamTypes = SignatureUtil.toSignature(paramTypes);
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < signatureParamTypes.length; ++i) {
            signature.append(signatureParamTypes[i]);
        }
        signature.append(")");
        signature.append(signatureReturnType);
        return signature.toString();
    }
}

