#if !defined (__BOUNDSEXCEPTION_HPP)
#define __BOUNDSEXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__STORAGEEXCEPTION_HPP)
#include <StorageException.hpp>
#endif

namespace corelinux
{

   DECLARE_CLASS( BoundsException );

   /**
   BoundsException is a type of StorageException, characterized when
   access to a storage object is invalid.
   */

   class BoundsException : public StorageException
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param why describes why the exception was thrown
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        BoundsException
                        (
                           CharCptr why,
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );

                        /**
                        Default Constructor
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        BoundsException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
   
                        /**
                        Copy constructor
                        @param BoundsException const reference
                        */
                     
                        BoundsException( BoundsExceptionCref );
   
                        /// Virtual Destructor
   
      virtual           ~BoundsException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  BoundsException const reference
               @return BoundsException reference to self
               */
            
               BoundsExceptionRef   operator=( BoundsExceptionCref );
            
               /**
               Equality operator overload
               @param BoundsException const reference
               @return true if equal, false otherwise
               */

               bool           operator==( BoundsExceptionCref ) const;
            
         //
         // Accessor methods
         //
   
            
         //
         // Mutator methods
         //
   
   
   protected:

                        /**
                        BoundsException must have at least
                        a location..
                        Default constructor is not allowed.
                        */   
                     
                        BoundsException( void );
   };

}


#endif  // !defined __BOUNDSEXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


