#if !defined (__INVALIDCOMPOSITEEXCEPTION_HPP)
#define __INVALIDCOMPOSITEEXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COMPOSITEEXCEPTION_HPP)
#include <CompositeException.hpp>
#endif

namespace corelinux
{


   DECLARE_CLASS( InvalidCompositeException );

   /**
   InvalidCompositeException is an exception that is usually
   thrown when a composite operation is attempted on a 
   leaf component.
   */

   class InvalidCompositeException : public CompositeException
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param file The source module throwing the 
                        exception
                        @param line The line of source throwing the 
                        exception
                        @param severity The Exception::Severity of the 
                        Exception
                        @param outOfMemory An out of memory indicator
                        */

                        InvalidCompositeException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
   
                        /**
                        Copy constructor
                        @param InvalidCompositeException const reference
                        */
                     
                        InvalidCompositeException
                           ( 
                              InvalidCompositeExceptionCref 
                           );
   
                        /// Virtual Destructor
   
      virtual           ~InvalidCompositeException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  InvalidCompositeException const reference
               @return InvalidCompositeException reference to self
               */
            
               InvalidCompositeExceptionRef   operator=
                  ( 
                     InvalidCompositeExceptionCref 
                  );
            
               /**
               Equality operator overload
               @param InvalidCompositeException const reference
               @return true if equal, false otherwise
               */

               bool           operator==
                  ( 
                     InvalidCompositeExceptionCref 
                  ) const;
            
         //
         // Accessor methods
         //
   
            
         //
         // Mutator methods
         //
   
   
   protected:

                           /**
                           InvalidCompositeException must have at least
                           a location..
                           Default constructor is not allowed.
                           */   
                     
                           InvalidCompositeException( void );
   
   
   private:
   
   private:
   
   };

}


#endif  // !defined __INVALIDCOMPOSITEEXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/



