/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.lib.profiler.heap;


/**
 * This represents one Thread Object GC root. It has kind ({@link GCRoot#THREAD_OBJECT}) and also corresponding
 * {@link Instance}, which is actual GC root.
 * @author Tomas Hurka
 */
public interface ThreadObjectGCRoot extends GCRoot {

    //~ Methods ------------------------------------------------------------------------------------------------------------------

    /**
     * Returns an array of stack trace elements,
     * each representing one stack frame.  The zeroth element of the array
     * (assuming the array's length is non-zero) represents the top of the
     * stack, which is the last method invocation in the sequence.  Typically,
     * this is the point at which this throwable was created and thrown.
     * The last element of the array (assuming the array's length is non-zero)
     * represents the bottom of the stack, which is the first method invocation
     * in the sequence.
     * <br>
     * Speed:normal
     * @return an array of stack trace elements representing the stack trace
     *         pertaining to this throwable.
     */
    StackTraceElement[] getStackTrace();
}
