/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef INSTANCE_H_
#define INSTANCE_H_

#include "Objectpath.h"

using namespace std;

#define _GET_PROPERTY CMPIStatus rc;\
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);\
	if (rc.rc != CMPI_RC_OK) return FAILED;\
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)\
		return FAILED;\
	return CT_ToC(data, value);

// C++ class to represent a CIM instance
class Instance {
private:
	CMPIInstance* hdl;
	CMPIBroker* broker;

public:
	Instance();
	Instance(const CMPIBroker* _broker, CMPIInstance* inst);
	Instance(const CMPIBroker* _broker, Objectpath& op);
	~Instance();
	CMPIInstance* getHdl();
	Objectpath getObjectpath();
	string getClassname() const;
	string getNamespace() const;
	int getPropertyCount() const;
	string toString() const;
	
	//uint8
	void setProperty(const string& name, const unsigned char& value);
	int getProperty(const string& name, unsigned char& value) const;
	
	//uint16
	void setProperty(const string& name, const unsigned short int& value);
	int getProperty(const string& name, unsigned short int& value) const;

	//uint32
	void setProperty(const string& name, const unsigned int& value);
	int getProperty(const string& name, unsigned int& value) const;

	//uint32 deprecated
	void setProperty(const string& name, const unsigned long& value);
	int getProperty(const string& name, unsigned long& value) const;

	//uint64
	void setProperty(const string& name, const unsigned long long& value);
	int getProperty(const string& name, unsigned long long& value) const;

	//sint8
	void setProperty(const string& name, const signed char& value);
	int getProperty(const string& name, signed char& value) const;
	
	//sint16
	void setProperty(const string& name, const short int& value);
	int getProperty(const string& name, short int& value) const;

	//sint32
	void setProperty(const string& name, const int& value);
	int getProperty(const string& name, int& value) const;

	//sint32 deprecated
	void setProperty(const string& name, const long& value);
	int getProperty(const string& name, long& value) const;

	//sint64
	void setProperty(const string& name, const long long& value);
	int getProperty(const string& name, long long& value) const;

	//real32
	void setProperty(const string& name, const float& value);
	int getProperty(const string& name, float& value) const;

	//real64
	void setProperty(const string& name, const double& value);
	int getProperty(const string& name, double& value) const;

	//char16
	void setPropertyChar16(const string& name, const unsigned short int& value);
	int getPropertyChar16(const string& name, unsigned short int& value) const;

	//boolean
	void setProperty(const string& name, const bool& value);
	int getProperty(const string& name, bool& value) const;

	//string
	void setProperty(const string& name, const string& value);
	int getProperty(const string& name, string& value) const;

	//datetime
	void setPropertyDatetime(const string& name, const string& value);
	int getPropertyDatetime(const string& name, string& value) const;

	//REF
	void setProperty(const string& name, const Objectpath& value);
	int getProperty(const string& name, Objectpath& value) const;

	//uint8[]
	void setProperty(const string& name, const vector<unsigned char>& value);
	int getProperty(const string& name, vector<unsigned char>& value) const;

	//uint16[]
	void setProperty(const string& name, const vector<unsigned short int>& value);
	int getProperty(const string& name, vector<unsigned short int>& value) const;

	//uint32[]
	void setProperty(const string& name, const vector<unsigned int>& value);
	int getProperty(const string& name, vector<unsigned int>& value) const;
	
	//uint32[] deprecated
	void setProperty(const string& name, const vector<unsigned long>& value);
	int getProperty(const string& name, vector<unsigned long>& value) const;
	
	//uint64[]
	void setProperty(const string& name, const vector<unsigned long long>& value);
	int getProperty(const string& name, vector<unsigned long long>& value) const;

	//sint8[]
	void setProperty(const string& name, const vector<signed char>& value);
	int getProperty(const string& name, vector<signed char>& value) const;

	//sint16[]
	void setProperty(const string& name, const vector<short int>& value);
	int getProperty(const string& name, vector<short int>& value) const;

	//sint32[]
	void setProperty(const string& name, const vector<int>& value);
	int getProperty(const string& name, vector<int>& value) const;
	
	//sint32[] deprecated
	void setProperty(const string& name, const vector<long>& value);
	int getProperty(const string& name, vector<long>& value) const;
	
	//sint64[]
	void setProperty(const string& name, const vector<long long>& value);
	int getProperty(const string& name, vector<long long>& value) const;
	
	//real32[]
	void setProperty(const string& name, const vector<float>& value);
	int getProperty(const string& name, vector<float>& value) const;
	
	//real64[]
	void setProperty(const string& name, const vector<double>& value);
	int getProperty(const string& name, vector<double>& value) const;
	
	//char16[]
	void setPropertyChar16(const string& name, const vector<unsigned short int>& value);
	int getPropertyChar16(const string& name, vector<unsigned short int>& value) const;
	
	//boolean[]
	void setProperty(const string& name, const vector<bool>& value);
	int getProperty(const string& name, vector<bool>& value) const;
	
	//string[]
	void setProperty(const string& name, const vector<string>& value);
	int getProperty(const string& name, vector<string>& value) const;
	
	//datetime[]
	void setPropertyDatetime(const string& name, const vector<string>& value);
	int getPropertyDatetime(const string& name, vector<string>& value) const;
	
	// REF[]
	void setProperty(const string& name, const vector<Objectpath>& value);
	int getProperty(const string& name, vector<Objectpath>& value) const;

};

#endif /*INSTANCE_H_*/
