///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __SCRIPT_UTILITY_H
#define __SCRIPT_UTILITY_H

#include "../ScriptingGUI.h"
#include <core/plugins/utility/UtilityPlugin.h>

namespace Scripting {

/******************************************************************************
* This utility plugin lets the user execute a script.
******************************************************************************/
class SCRIPTING_GUI_DLLEXPORT ScriptUtility : public UtilityPlugin
{
public:
	/// Default constructor.
	ScriptUtility();

	/// Shows the UI of the utility in the given RolloutContainer.
	virtual void openUtility(RolloutContainer* container, const RolloutInsertionParameters& rolloutParams = RolloutInsertionParameters());

	/// Removes the UI of the utility from the rollout container.
	virtual void closeUtility(RolloutContainer* container);

protected Q_SLOTS:

	/// Handles the "Open New Editor" command event.
	void onNewEditor();

	/// Handles the "Open Script File" command event.
	void onOpenScriptFile();

	/// Handles the "Run Script File" command event.
	void onRunScriptFile();

private:

	/// The applet panel.
	QWidget* panel;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(ScriptUtility)
};

};

#endif // __SCRIPT_UTILITY_H
