///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

// Include the Boost.Python library.
#include <boost/python.hpp>
#include <boost/python/to_python_converter.hpp>
#include <boost/python/object.hpp>
#include <boost/python/handle.hpp>

using namespace boost::python;

class HelloWorldClass {
public:
	void print() {
		std::cout << "Hello World!" << std::endl;
	}
};

BOOST_PYTHON_MODULE(HelloWorld)
{	
	class_<HelloWorldClass>("HelloWorldClass")
		.def("SayHello", &HelloWorldClass::print)
	;	
}
