/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFloat32Array.h"

#include "ExceptionCode.h"
#include "Float32Array.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFloat32Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayTable = { 5, 3, JSFloat32ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayConstructorTable = { 2, 1, JSFloat32ArrayConstructorTableValues, 0 };
const ClassInfo JSFloat32ArrayConstructor::s_info = { "Float32ArrayConstructor", &DOMConstructorObject::s_info, &JSFloat32ArrayConstructorTable, 0 };

JSFloat32ArrayConstructor::JSFloat32ArrayConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFloat32ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFloat32ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFloat32ArrayConstructor, JSDOMWrapper>(exec, &JSFloat32ArrayConstructorTable, this, propertyName, slot);
}

bool JSFloat32ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFloat32ArrayConstructor, JSDOMWrapper>(exec, &JSFloat32ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSFloat32ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSFloat32Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayPrototypeTableValues[4] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "subarray", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFloat32ArrayPrototypeFunctionSubarray), (intptr_t)2 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFloat32ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayPrototypeTable = { 8, 7, JSFloat32ArrayPrototypeTableValues, 0 };
static const HashTable* getJSFloat32ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFloat32ArrayPrototypeTable);
}

const ClassInfo JSFloat32ArrayPrototype::s_info = { "Float32ArrayPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSFloat32ArrayPrototypeTable };

JSObject* JSFloat32ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFloat32Array>(exec, globalObject);
}

bool JSFloat32ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSFloat32ArrayPrototype, JSObject>(exec, getJSFloat32ArrayPrototypeTable(exec), this, propertyName, slot);
}

bool JSFloat32ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSFloat32ArrayPrototype, JSObject>(exec, getJSFloat32ArrayPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSFloat32ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFloat32ArrayTable);
}

const ClassInfo JSFloat32Array::s_info = { "Float32Array", &JSArrayBufferView::s_info, 0, getJSFloat32ArrayTable };

JSFloat32Array::JSFloat32Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Float32Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSFloat32Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSFloat32ArrayPrototype(exec->globalData(), globalObject, JSFloat32ArrayPrototype::createStructure(exec->globalData(), JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSFloat32Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Float32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSFloat32Array, Base>(exec, getJSFloat32ArrayTable(exec), this, propertyName, slot);
}

bool JSFloat32Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Float32Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSFloat32Array, Base>(exec, getJSFloat32ArrayTable(exec), this, propertyName, descriptor);
}

bool JSFloat32Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Float32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsFloat32ArrayLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFloat32Array* castedThis = static_cast<JSFloat32Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Float32Array* imp = static_cast<Float32Array*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsFloat32ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFloat32Array* domObject = static_cast<JSFloat32Array*>(asObject(slotBase));
    return JSFloat32Array::getConstructor(exec, domObject->globalObject());
}

void JSFloat32Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSFloat32Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSFloat32Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Float32Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSFloat32Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFloat32ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFloat32ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFloat32Array::s_info))
        return throwVMTypeError(exec);
    JSFloat32Array* castedThis = static_cast<JSFloat32Array*>(asObject(thisValue));
    Float32Array* imp = static_cast<Float32Array*>(castedThis->impl());
    int start(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    int argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start)));
        return JSValue::encode(result);
    }

    int end(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFloat32ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFloat32Array::s_info))
        return throwVMTypeError(exec);
    JSFloat32Array* castedThis = static_cast<JSFloat32Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsFloat32ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


JSValue JSFloat32Array::getByIndex(ExecState*, unsigned index)
{
    return jsNumber(static_cast<Float32Array*>(impl())->item(index));
}

Float32Array* toFloat32Array(JSC::JSValue value)
{
    return value.inherits(&JSFloat32Array::s_info) ? static_cast<JSFloat32Array*>(asObject(value))->impl() : 0;
}

}
