# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

# Follows PEP8

from core import models
from lib.reverse_translation import _t
from lib.imtools import fill_background_color, generate_layer, \
    remove_alpha, has_transparency, get_alpha, paste

#---Pil


def init():
    global Image, HTMLColorToRGBA
    import Image
    from lib.colors import HTMLColorToRGBA


FILL_CHOICES = (_t('Color'), _t('Image'))


def background(image, fill, mark, color,
        horizontal_offset=None, vertical_offset=None,
        horizontal_justification=None, vertical_justification=None,
        orientation=None, method=None, opacity=100):
    if not has_transparency(image):
        return image
    if image.mode == 'P':
        image = image.convert('RGBA')
    if fill == FILL_CHOICES[0]:
        opacity = (255 * opacity) / 100
        return fill_background_color(image, HTMLColorToRGBA(color,
            opacity))
    elif fill == FILL_CHOICES[1]:
        layer = generate_layer(image.size, mark, method,
                               horizontal_offset, vertical_offset,
                               horizontal_justification,
                               vertical_justification,
                               orientation, opacity)
        paste(layer, image, mask=image)
        return layer

#---Phatch


class Action(models.StampMixin, models.Action):
    label = _t('Background')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    init = staticmethod(init)
    pil = staticmethod(background)
    version = '0.1'
    tags = [_t('color'), _t('filter')]
    __doc__ = _t('Put color under transparent image')

    def interface(self, fields):
        fields[_t('Fill')] = self.ChoiceField(FILL_CHOICES[0],
            choices=FILL_CHOICES)
        fields[_t('Color')] = self.ColorField('#FFFFFF')

        super(Action, self).interface(fields)

    def get_relevant_field_labels(self):
        """If this method is present, Phatch will only show relevant
        fields.

        :returns: list of the field labels which are relevant
        :rtype: list of strings

        .. note::

            It is very important that the list of labels has EXACTLY
            the same order as defined in the interface method.
        """
        relevant = ['Fill', ]

        if self.get_field_string('Fill') == FILL_CHOICES[0]:
            relevant.extend(['Color', 'Opacity', ])
        elif self.get_field_string('Fill') == FILL_CHOICES[1]:
            #specify explicitly from models.StampMixin
            relevant.extend(
                models.StampMixin.get_relevant_field_labels(self))

        return relevant

    icon = \
'x\xda\x01a\r\x9e\xf2\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\r\x18IDATh\x81\xed\x99}l\x14\xe7\x9d\xc7?\xcf\xbc\xac\
w\xbd^{\xfd\xc2\x9bM1\x01b \x89\xe3\x12SP\x14]\xe2^\xeez\xd7H\xa5\xc9\xb5\
\xa1\xe4\xd4k{\xa0K\xaa\xea\x92*:)\xa1\xbc\x94\xda\t\xe8$\x14\x90R \x07\x17\
\x94K\xd3PA\x93\xea\xca\x85\x94\xe48\xae\xf4Th\x80\xe6\xc8%\x01\x8c\r6\x18\
\xdb\xd8\xde\xe0]\xafwwvfg\x9e\xfbc\x9e\xb1\x97@\x08\xa49\x91J7\xd2\xa3\xdd}\
f\xf6\x99\xef\xf7\xf7\xfd\xbd=3BJ\xc9\x1f\xf3\xa1\xddh\x00\x7f\xe8\xf1\xff\
\x04n\xf4a\xdch\x00W;\x9ez\xea\xa9\x85\x9e\xe7}\x17\xe8\x05\x9e_\xb3fM\xf7\
\x87\xaf\x11\x9f\xc5 \xde\xb6m\x9b\xd9\xdf\xdf\xbf\x1ex\x0c\x10j\xbaO\xd7\
\xf5?]\xb5jU{\xf1\xb5\x9f9\x02\xeb\xd6\xad\x9b\xe28\xce\xcf\x81\xbb\x8a\xe7\
\xa5\x94x\x9e7`\x9a\xe6\xbd\xabW\xaf~?\x98\xffL\xc5@kk\xeb\xdd\x8e\xe3\xbc\
\xcd\x87\xc0\xbb\xae\x8bm\xdb\xe4\xf3\xf9I\xb9\\n{\xf1\xb9\xcf\x0c\x81\xb6\
\xb6\xb6\xc7\x81\xff\x00&\x07sRJ\x1c\xc7\xc1\xb6m\x1c\xc7\xa1P(`\xdb\xf6\x82\
\xb5k\xd7\xd6\x05\xd7\xdc\xf0 nmm-\x03\xb6\x03\x8b\x8b\xe7=\xcf\x1b\x03\xed\
\xba.\xae\xeb\xe2y\x1e\x80\xc8\xe5r_\x03\x9e\x85\x1bL\xe0\xe9\xa7\x9f\x9e\r\
\xfc\x02\xb8\xa5x\xbeP(\\6<\xcfCJ\x89\xa6i\xd8\xb6}\xe3\x15hmm\xfd+\xe0_\x80\
X\xf1|`\xf5\xe03P \x00\x0f\x10\x0e\x87\xff5\xb8\xfe\x86\x10X\xb4h\xd1\xa3\
\xba\xae\xaf\x89\xc5b\xbd\xf5\xf5\xf5\x15\x86aL\t\xc0\x07\xa3\x98D\x00^\x08\
\x91\xd5u\xfd{mmm\x87\x82\xb5>6\x8d\n\x84\t\xdc\x0c\xf4Hd\xfa\x0f\x05\xbfx\
\xf1\xe2\n\xcb\xb2\x12(\xe3\xe9\xba\xce\xdc\xb9s\x11B\x8c\x81.&\xe1\xba.\xba\
\xaec\x18F\xb7\xae\xeb\x0fl\xde\xbc\xf9X\xf1zW\xccB\x02\x11\xd2\x11\xab+1\
\x8fL#<\x1aF{\x1fH\tD\xa7@\xfc\xa3@\x84?)\x01\xcb\xb2\x1a\x85\x10\xe9\xc6\
\xc6\xc6\xde\xf9\xf3\xe7\xd3\xd0\xd0\xc0\xf1\xe3\xc7\xc9\xe7\xf3\x97\x80\x0f\
\xb2\x8f\xa6i\x18\x86\xf1F$\x12\x99\xf7a\xf0p\x05\x17\x12)1?fh?\x99\x102\xe7\
\x96\x19\x06aa\xf09J\xe9#/\xce\x92\x9d\xe9!\x9f\x04\xbe*\x10\xdf\x96\xc8\xc3\
\xd7K\xa0\xa5\xa5\xe5.\xc7qJ5M\xab\xbc\xf3\xce;\xe9\xef\xef\'\x95J\xd1\xdd\
\xddM]]\xdd%Ak\x9a\xa6\x17\n\x85\xd6>\xf7\xdcs?\xfc\xa8\xf5.! \xfa\xc5\x1d\
\x11!~[\x15\xd2C!O\xa0\x9b\x02\xdd\xd4\x08\xe9:\rT0\x9d\n\xde\xe3"CXs\x80\
\x83\x02\xb1\x0eh\x95H\xf7\xe3\x80\xbf\xfc\xf2\xcb\xe5\x96e\xbd\x18\x0e\x87\
\xef\x9f9s&---\xec\xd9\xb3\x87S\xa7N\x01\x04\xb9\xbe\xe0y\x9e!\x84\xc04\xcd\
\x8b\x86a|k\xcb\x96-{\xae\xb6\xeeX\x0c\x08\x84\xa6\x9d\xe6\xddjC\xbb%b\xea\
\x94\x86t"\xa6I\xa9i\x106C\x84\x8d\x10!aRB\x88\x1eF\xf9=\x17\xb0(\x00\xfc\
\x06\xf8k\x89\xec\xfd\xa8\x9b\xec\xdc\xb9\xf36\xdb\xb6w\xe7\xf3\xf9\x9b\x9a\
\x9a\x9a\xa8\xaa\xaab\xf7\xee\xdd$\x93I\x06\x06\x06H$\x12\xd2q\x1cYSSs\xdc4\
\xcd\xdb\x84\x10\xef\x84\xc3\xe1\xfb7n\xdc\xd8\xfdq\x86\x19\x8f\x81N~\xe8e\
\xb8%\x95\x95\xb8\x96DZ@^\x82\x05"/\x10\xb6@wu\x0ct\xe60\x91\x87\xf8<\xd3\
\xa8\x04\xb8\x1b8&\x10_\xbe\xd2\r^}\xf5\xd5yR\xcaC\xc0M\xb7\xdez+\x89D\x82\
\xd7_\x7f\x9d\x8b\x17/\xd2\xd7\xd7\xc7\xd0\xd0P\xb6\xaf\xafo@J\xa9I)]\xc30^4\
Ms\xe1\xb5\x80\x87b\x17\x1a\xe5>\x1c\xb0\x0b\x92\x81\x82\x8b\xeej\x84\xa5\
\xc4\xf3\xfc\x92.$h\x9e@3u\x0c\xdd\xa0D\x84y\x90f\xde\xe2,\xbf\xa5\xb3F"\xf7\
\x08\xc4z`\xa5D\x16\x82eu]\xbf\xdbu\xdd\xb2x<\xce\xc9\x93\'q\x1c\x07\x80T*E:\
\x9d~7\x93\xc9\xe4\xa4\x94\x0b\x84\x10\xa3R\xca\xcd\x9b6m\xfa\xe7k\x01~\xb9\
\x029\x1a\xb0\x81<\x14r\x92\xf3i\x9b\x0f2\x0e^\xdeSC"m\x89\xc8\x83p4tO\xc7\
\xa4\x84{\xb9\x9do\xd3B\x94\xb0\x00\x9e\x00\x0e\x08\xc4\xb4`YKXG\x84\x10\xa4\
\xd3i4M\x0b\xb2\n\xb3f\xcd\x92---;\xf6\xee\xdd\xbb\xb0\xbc\xbc|\xd2\xe4\xc9\
\x93\xab^x\xe1\x85\xeb\x02\x0f*\x06\xc4\xef\xc5\x14F\xe8\xf3g\x14-\x1d0aB\
\xc4dvY9e\xa10Q3B4\x14!bF)5J\x89\x18eD\xf4RJ\x88\x90\xc1\xe5\'\xbcI\x17\x17\
\x00.\x02\x7f+\x91\xbb\x01\xb6\xbc\xb1\xe5\xa8\xcc\xcb\xe6\xf2T\xf9e\x15\xd6\
0\x8c\x97\x8e\x1d;\xb6l\xdb\xb6mc\xaa\xc9\xeb\xe8\xf1}\x05^c\x00A\x8e\x02\
\x04*`\x019\x18J;\xbc3\x9cb4g\xe3\xd8\x05\ny\x177_\xc0s<p<DA\xa0K\x93\tT\xf3\
\x04\xdf\xe1\x1e\x9a\x01\xaa\x80_\n)6\x08\x849K\xcc\xba\'\x1dI\xef?Y{\x12L\
\xbfx\xa9\xe2D<\x1e\xff\x9b\xa6\xa6\xa6_?\xf3\xcc3\xd5\xca|B\x08!\xae\x0c\
\xf7#\x14\x00\x10\x07\xc51Fh\xc2\x03\xa4\xa2\xa6\xe1G\x89\tf\x89\xc6\xbc\x8a\
j\xa6E\xe3\x94\x99\xa5DCe\x94\x991J\x8dr\xa2F\x05\xa5z\x05\x11\xad\x9c\x10Q\
\xf6p\x80\x9f\xf1oH$\xc0a`\t\x82\xeeu\xff\xbe\xee\xc7\x9d\xb1\xce\xef\xcd\
\xed\x99+*S\x95c=\x8e\xc2\xd0\x9dJ\xa5\xee_\xbe|\xf9q\x85\xc0Sb\\U\x8d\xf1\
\x18(\xe10\x9a\xfa\xab{\xb9\x12N\xd6\xe3\xc8\x07C\xbc\x97\x1c"\x9f\xcfc\xdb\
\xfep\x9c<N!\x8f[p\xf0<\x0f\x1d\x93o\xf05\x9e\xe0QLL\x80\x05\xc0\xdbd\xf8\
\xfa\x8a?_\xf1\xfd\xd9\x83\xb3\x1f>\xd8p\xd093\xe5\x0c\x86a\x14\x8f\xe9555\
\x076m\xda\xf4\x97\\\xc7>e\\\x81\xb7\xc5,\xd2\xfc79\xca\xb0\x81\x82\xb2\x81`\
,\x1e(\xf1?\'\x97\x95rO\xf5t\xaaJ*\x88\x86b\xc4\xcc\n\xa2F\x9c\xa8QIL\xaf!\
\xaaW\x13e"\'8\xc5j~\xc4\x08\xaa\x85\xca\xb1\x95\x87X\xf3\xf8\xfc\xc7\xe7e\
\xbe\x98\xd9\x11\xb3b\x95\x8d\xe7\x1b\x19\xc3 \x04B\x08\xc7u\xdd\'\x97.]\xfa\
c\xc0\x93Rz\xd7\xa6@3\xa7\x89\xf2]\x0c$\xba:#\x01G)\x91\x03\xb2\xfe\xe7\x85\
\x91,\xaf\xf5wp6\x93 gg\xc8\xda\x19rN\x9a\\a\x84\xac\x9b$\xeb&\x19\x95\t\xd2\
^\x8a\xcf\rN\x85#\xc0\x01\xa0\x87G\xd8\xce\x7fn,\xdbhu\xb5v\xdd\x17\xc9E\xda\
OM=\x85n\xeacJTWW\x9b\xf1x|\xc3\xce\x9d;7=\xfc\xf0\xc3\xfa5)\xa0\x82F\x00!\
\xde\xe29R|\x87\xbc\x02\xee(5P*\x84\x94\x12!\x10aAS\xe5$\xee\x8a\xcf"\x16\
\xaa j\xc6\x88\x9aq\x8e\xd1\xc3/\xdf\xfb\r\xf5\xc7n\xe2\x81\xe9\x0f0\xafj\
\x1eS\xf4)$\xb2\t:s\x9d\xbc)\xdf\xf4\xf6\x8c\xecY\x1f\xff\xbb\xf8\xaf\x96o\\\
\xfe\x03m\x92\xf6\x177\xe7o\xa6\xbe\xbe\x9e\\.G__\x1f\xae\xeb\x92\xc9d\xbe\
\xb5l\xd9\xb2\x9f^-\x0e\x02\x02\xbar\x94(\x10\xe1W\xacD\xe7\x11\xf2\xe8X\xf8\
\xf1`\xab\x7f\x84\xd4\x08+"%0\xa1,\xca\x97k\xe62%2\x91\x13\xf6 {\xf7\xff\x0f\
\x8fU>\xc67\xeb\xbf\xc9\xd0\xc0\x10\xc5\xf7\x97R\x82\x94\\\x94\x17Y\xd1\xbfr\
\xd7\xb4\x17\xa7\xbd\xb2z\xf5\xea\xed3g\xce\x8c\r\x0f\x0f\xd3\xd5\xd5E&\x93\
\xa1\xb7\xb7\x97\\.\xf7l[[\xdb?p\x95\x80.&`\x00\xe5@\x04\x88\xf2$_\xe2^~D\
\x9e8\x96R#\xaf\xdc\xaa\xe4\xf2aF4\x1a\xca\'r\xfc\xd8\x05\x9e\x9f\xbe\x9d\
\x06\xb7\x81l6\x8b\xe7y\x0c\x0e\x0e280\x80\xe7yT\xd7\xd40y\xf2d\x90\x12\x0f\
\x8f\xc9S\xa6\xd8\xb3f\xcc\n\x9d?\x7f\x9e3g\xce044Doo/}}}\xb6\x10\xe2\x81\
\xad[\xb7\xeeS\x04\xae\x18\x0f\x01\x81 a\xc6\xc6\x08\xc0$\x1a\xa8e=k\xd0\x99\
3F \xaf\x96\x0b]\x81H\x0e\xbe\x92\xf8\n\xabf\xaf"\x91H0\x9aN\xf3\xeb\x03\x07\
\x88D"L\x9a8\x91h4J2\x95"\x95J1\xbf\xb9\x99;\x9a\x9b\xa9\xab\xab\xa3\xb3\xb3\
\x93\xee\xeenzzz\xe8\xed\xed\xa5\xbf\xbf\xdf\xca\xe7\xf3+v\xec\xd8\xf1S \x83\
\x9f\x17\xdd+)QL@\x03J\x15\x81\x080A\x11\x99\xc0&\x960\x83\xaf\x92G\x1f\x8b\
\x0b\xa9\x9c.4N\xc6<kr\xf0O\x0er\xa1\xb3\x1f\xdb\xb6\xd9\xbbw/\xf3\xbf\xf0\
\x05\xaa*+9q\xf2$\xe9\x91\x11\xe6\xcc\x99Cm]\x1d\x8d\x8d\x8d\x94\x95\x95\xd1\
\xd5\xd5EWW\x17===\x9c;w\x8eD"1\xdc\xd3\xd3\xf3\xfd\xfd\xfb\xf7\x1fU\xe6\x1a\
Uw\x0c\xd2\x89\x04\xdc\x80D\xd0\xcc\x05\x85\xc3a<3\x8d\xaa\xf9(\x7f\xcf.\x1e\
\xe44Ky\x04\x9dr\xec"\x12.~\x90k0\xdb\x9bMv(\x8b\xe38\x1c9z\x94;\x9a\x9bAJZ\
\xdb\xda(//\xc7u]\xea\xa6N\xe5\xf6\xdboG\x08AGG\x07g\xce\x9c\x19\x03\x9fL&\
\xbb\x0e\x1d:\xf4hGGGB\x99\x05u\xa7 \xc9\x8c)!\x84@J)\r\x15X\x12\x90B\x88\
\xbc\x82c\xa9?\x86\xd5\xef\x18?\x07\xfe\x8b\xe5l\xe21"\xccAWK\x05\xd4\xb3\
\xd0\x18od4\x9d\xa6P(\xa0\tAUe%\xeb\xd7\xafg\xe5\xca\x95\xd4\xd6\xd6b\x18\
\x06uuu\xe4r9\x06\x07\x07\xe9\xee\xee\xa6\xbb\xbb\x9b\xb3g\xcf\xe2\xba\xee\
\xd1]\xbbv=nY\x96\xa7\x8cXRd`\x07?\x8dh\xea\xbb\x058B\x88\xcb*^\xb1M-\x1f\
\x16i`\x04\x18\xe1\x02\t\xbe\xce&\x8e\xb1\x9b(\x05\xc2\xf8\xa9U\xb5\x1bScS\
\xc9d2\x8c\x8e\x8e\x12)-%\x97\xcb\x91\xb7mjkk\x01\x88\xc7\xe3c\xdb\xc7\x13\'\
N\xd0\xde\xde\xce\xe9\xd3\xa7\xa9\xaf\xaf\'\x12\x89\xbcnY\x96S\xe4\xebA[i2\
\x9e\xc0\xcdK\xef\x88\xb8\x84\x80\xf4\x0fOJ\x19\x10\x08|0\r\xa4\x14\x91QV\
\xf2\x06\x1bx\x16\x93\x14\xe1\xf1\xa5\xdb\x93\xed~\x7f\x03\x94F"\xb8\xaeK2\
\x99\x04\xfc*\x9bJ\xa58w\xee\x1c\xed\xed\xed\xb4\xb7\xb7\xd3\xd3\xd3\xc3\xe7\
\x9b\x9a\xa8\xae\xaa"\x9dN\xebJ\xf1\xc0\x88\xc165\xe8\x03\x8a\x87\xa1\xe6\
\xb5\xab\xf5\x1cR\x11H\x01C@\x0fpV\x8ds\xec\xe5(\x8bYK\x92\xe3AMx\xd7z\x97p8\
\x8c\x00,\xcbBJ\xc9\x84\t\x13\xd8\xb9s\'RJz{{\xc7\xc0\x0f\x0f\x0f\xb3p\xc1\
\x02B\xa1\x10\x85B\x81C\x87\x0eu)\x02\x01\xa6\x80Dq#\x13$\x99\xc0l\xfaG>\xd8\
\x92RJ\xd5\xd5\x16\x14\x99 \x9d\x85\x08\xeas\x8a(Kx\x9e\'\xf93\xee\xe3K\xdd\
\xd1n#o\xd8\x14\n\x05\xa2\xd1(\x85B\x81\x87\x96,\xe1\x9f\xb6n\xe5\xe8\xd1\
\xa3\xb4\xb4\xb4\x90L&\xb1,\x0b\xd34\xb1\xf2y\x00\x9c|~\xa4\xbd\xbd\xddR\xe0\
\xb2\xf8.\x14\xdcWc\xdc\x9d\x82\x9dJ\xf0[\\\xd3\xfb\x01\x95f\x8b\xab\xf5D\
\xfc\x9a1\r\xbf\xf8\xd5r\'Sy\x8ao,\xbc\xb00\xbe,\xb3\x14\xc7q\xfcV\x19\x90A1\
\x1b\x1c\xc4\xb6m\xfa\xfa\xfa\xa8\x9b:\x95\xcax\x9c\xba\xba:\x0e\xfd\xeew\
\xbfx\xe5\x95W\xf6)#\r0\xdey\x05\x01\x1d(\x12\xb8u\x16?\xa83\xd7\xfc\x82C\
\x91\x10\x8cuB\x84\xf1\x1f\x85\x97\x8f\x11\t3\x95\xcd<\xb8\xa2t\xc5\xacI\x03\
\x13\xc7z}\xa1i\xe8\x9a\x86\xe7y$\x12\t\xd2\xa3\xa3$\x87\x87)\x8b\xc5\x08\
\x85B=\x1b6l\xd8\x82\x1fk\x01\x01K}\x0fv\'\x81;\x05\xc0\xd3\xa8\xbap=\xef\
\x07\x8akE`\x85$\xfe\xf6\xf1\x03\xe0\x03,.\xb2\x8c\x9f\xad;\xb8\xee\xb5\xf7+\
\xdf\xf7<\xcf\x0b\x9e\xe9\xfb\xa9U\xd7)\xaf\xa8 \x14\nQQQA.\x9b\xed\x7f\xe9\
\xa5\x97\xde\xc0\x0fJ\x83\xf1-T\xd0\x0fk\nx\x90F\x8b[L\xbf\x1e\\\xef+\xa6\
\xa2\xce\xb5X\x8dj|\x97\xba\x03\xa8\x00b\x98L\xbe\xed\x07\xb7}qQ\xf5\xa2\x9b\
\xcbre:\xaer\')\xc9\xe6\xb2\xd9\xc3o\x1d~o\xdf\xbe}\xef\xe0\xbb\xcb\x90\xb2j\
\x1a\x18\xc4W \xa9@\x07\x95\xd8V\xd7\x06U\xd9\x03\xe4\'~G\xa6\x88\x04\x96+\
\xc3\xcf\x10\xb5\xf8.U\x01\xd4\xe1\xc7Ki(\x142f\xcc\x981!\x16\x8bE:::\x86Tj\
\x15\xf8\xd6\x14\xf8n\x93V`\x07\xf0\xd5\x1dV\xe7\xd3\xf8\x01\x1d(\x1f\xb8\
\x93\x94R~r\x02\x8aD s\x90\xd6\x02%b\x8a\x8c\xdf\x9e\xfbGP\x9cLu\xdeP\xa0\
\xb2\xc0\x85"\x02\t|K\xa7\x18w\x9b #\x0511\xf6\xe4\xe2SyKY\x94\xa5\x8a\x03\
\xbc\x92\xb1M(\x1e0\x89\xf1\x9c^\xc9x:\xce)\x02\xa3\xea{`\xf9Q\xc6\xfd\xdfS\
\xa0\xaf\xdcN\x7f\n\x04\x82\x98\x08\xf6\x15&\xbe\xf5M5\xe7)0A\x90\x96+\x02\
\xae\x02\x9bd<8\x037A\xfd\xef\xaaO\'>\x9574E\xcd \x8c\xa7\xbd\xa0\xe1\x16\
\x8c\xcb\x1f\x90\xb4\xd5\xbd\x83\x82\x95a\xdc\xd2\xc1\xe3\x84\x8f}\xa4\x02\
\xffG/\xba?\x94\xa9@\xf9mp\x9aqb\xe0\xabd3N2p\x97k\x02\xf6\xbfa<\xa3\xf6Eq~\
\xab\x00\x00\x00\x00IEND\xaeB`\x82\x14\xe2is'
