/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2009-2010 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef LIGHTANCHORCONFIG_H
#define LIGHTANCHORCONFIG_H

namespace SmoothTasks {
class LightAnchorConfig
{
public:
	LightAnchorConfig();
	
	void setAnchoredHorizontally(const bool isAnchoredHorizontally) { m_isAnchoredHorizontally = isAnchoredHorizontally; }
	void setAnchoredVertically  (const bool isAnchoredVertically  ) { m_isAnchoredVertically   = isAnchoredVertically  ; }
	void setAnchorHorizontal    (const int  anchorHorizontal      ) { m_anchorHorizontal       = anchorHorizontal      ; }
	void setAnchorVertical      (const int  anchorVertical        ) { m_anchorVertical         = anchorVertical        ; }
	
	bool isAnchoredHorizontally() const { return m_isAnchoredHorizontally; }
	bool isAnchoredVertically  () const { return m_isAnchoredVertically  ; }
	int  anchorHorizontal      () const { return m_anchorHorizontal      ; }
	int  anchorVertical        () const { return m_anchorVertical        ; }
	
private:
	bool m_isAnchoredHorizontally;
	bool m_isAnchoredVertically;
	int  m_anchorHorizontal;
	int  m_anchorVertical;
};
}  // namespace SmoothTasks

#endif // LIGHTANCHORCONFIG_H
