"""
Base Class for all Widgets displaying/editing a contact (vCard)
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: AbstractContactView.py 82 2004-07-11 13:01:44Z henning $
#
#  $Id: AbstractContactView.py 82 2004-07-11 13:01:44Z henning $

import vcard
import broadcaster


class AbstractContactView:
    def __init__(self, **kws):
        self._cardhandle = None
        self._contact = vcard.vCard() #Empty Contact
        self.registerAtBroadcaster()
        
    def registerAtBroadcaster(self):
        "Register our Widget's Callback Handlers"
        broadcaster.Register(self.onContactsClose,
            source='Contacts', title='Closed')

    def onContactsClose(self):
        self.bind_contact(None)

    def bind_contact(self, contact):
        if contact is None:
            self._cardhandle = None
            self._contact = vcard.vCard()
        else:
            self._cardhandle = contact.handle()
            self._contact = contact
    def cardhandle(self):
        return self._cardhandle
    def boundto(self):
        return self._contact
                
