"""
This file defines the menu contents and key bindings. 
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: Bindings.py 90 2004-09-11 19:08:25Z henning $


import sys
import string
from keydefs import *

menudefs = [
 # underscore prefixes character to underscore
 ('file', [
   ('C_onnect...', '<<connect-to-server>>'),
   ('_Disconnect', '<<disconnect-from-server>>'),
   None,
   ('_Import...', '<<import-file>>'),
   ('_Export...', '<<export-file>>'),
   None,
   ('Page _View', '<<page-view>>'),
   None,
   ('_Close', '<<close-application>>'),
  ]),
 ('contact', [
   ('Create _New Contact', '<<new-contact>>'),
   ('_Delete Contact', '<<del-contact>>'),
   ('_Save Contact', '<<save-contact>>'),
   None,
   ('D_uplicate Contact', '<<dup-contact>>'),
   ('_Export Contact', '<<export-contact>>'),
  ]),
 ('query', [
   ('_Find Contact...', '<<query-find-contact>>'),
   ('Find _Next', '<<query-find-next>>'),
   None,
   ('_Birthdays', '<<query-birthdays>>')
 ]),
 ('view', [
   ('_Journal', '<<view-journal>>'),
   ('_Calendar', '<<view-calendar>>'),
   ('_Letter Composer', '<<view-lettercomposer>>')
 ]),
 ('settings', [
   ('_Edit Preferences', '<<edit-preferences>>')
 ]),
 ('help', [
   ('_Help...', '<<help>>'),
   None,
   ('_About PyCoCuMa...', '<<about-pycocuma>>'),
  ]),
]

if sys.platform == 'win32':
    default_keydefs = windows_keydefs
else:
    default_keydefs = unix_keydefs

del sys
