# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhci.aio import AzureStackHCIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.clusters.list_by_subscription(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create(self, resource_group):
        response = await self.client.clusters.create(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster={
                "location": "str",
                "aadApplicationObjectId": "str",
                "aadClientId": "str",
                "aadServicePrincipalObjectId": "str",
                "aadTenantId": "str",
                "billingModel": "str",
                "cloudId": "str",
                "cloudManagementEndpoint": "str",
                "connectivityStatus": "str",
                "desiredProperties": {"diagnosticLevel": "str", "windowsServerSubscription": "str"},
                "id": "str",
                "isolatedVmAttestationConfiguration": {
                    "attestationResourceId": "str",
                    "attestationServiceEndpoint": "str",
                    "relyingPartyServiceEndpoint": "str",
                },
                "lastBillingTimestamp": "2020-02-20 00:00:00",
                "lastSyncTimestamp": "2020-02-20 00:00:00",
                "logCollectionProperties": {
                    "fromDate": "2020-02-20 00:00:00",
                    "lastLogGenerated": "2020-02-20 00:00:00",
                    "logCollectionSessionDetails": [
                        {
                            "correlationId": "str",
                            "endTimeCollected": "2020-02-20 00:00:00",
                            "logCollectionError": {"errorCode": "str", "errorMessage": "str"},
                            "logCollectionJobType": "str",
                            "logCollectionStatus": "str",
                            "logEndTime": "2020-02-20 00:00:00",
                            "logSize": 0,
                            "logStartTime": "2020-02-20 00:00:00",
                            "timeCollected": "2020-02-20 00:00:00",
                        }
                    ],
                    "toDate": "2020-02-20 00:00:00",
                },
                "name": "str",
                "principalId": "str",
                "provisioningState": "str",
                "registrationTimestamp": "2020-02-20 00:00:00",
                "remoteSupportProperties": {
                    "accessLevel": "str",
                    "expirationTimeStamp": "2020-02-20 00:00:00",
                    "remoteSupportNodeSettings": [
                        {
                            "arcResourceId": "str",
                            "connectionErrorMessage": "str",
                            "connectionStatus": "str",
                            "createdAt": "2020-02-20 00:00:00",
                            "state": "str",
                            "transcriptLocation": "str",
                            "updatedAt": "2020-02-20 00:00:00",
                        }
                    ],
                    "remoteSupportSessionDetails": [
                        {
                            "accessLevel": "str",
                            "duration": 0,
                            "nodeName": "str",
                            "sessionEndTime": "2020-02-20 00:00:00",
                            "sessionStartTime": "2020-02-20 00:00:00",
                        }
                    ],
                    "remoteSupportType": "str",
                },
                "reportedProperties": {
                    "clusterId": "str",
                    "clusterName": "str",
                    "clusterType": "str",
                    "clusterVersion": "str",
                    "diagnosticLevel": "str",
                    "imdsAttestation": "str",
                    "lastUpdated": "2020-02-20 00:00:00",
                    "manufacturer": "str",
                    "nodes": [
                        {
                            "coreCount": 0.0,
                            "ehcResourceId": "str",
                            "id": 0.0,
                            "lastLicensingTimestamp": "2020-02-20 00:00:00",
                            "manufacturer": "str",
                            "memoryInGiB": 0.0,
                            "model": "str",
                            "name": "str",
                            "nodeType": "str",
                            "oemActivation": "str",
                            "osDisplayVersion": "str",
                            "osName": "str",
                            "osVersion": "str",
                            "serialNumber": "str",
                            "windowsServerSubscription": "str",
                        }
                    ],
                    "oemActivation": "str",
                    "supportedCapabilities": ["str"],
                },
                "resourceProviderObjectId": "str",
                "serviceEndpoint": "str",
                "softwareAssuranceProperties": {
                    "lastUpdated": "2020-02-20 00:00:00",
                    "softwareAssuranceIntent": "str",
                    "softwareAssuranceStatus": "str",
                },
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "tenantId": "str",
                "trialDaysRemaining": 0.0,
                "type": "str",
                "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.clusters.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster={
                "aadClientId": "str",
                "aadTenantId": "str",
                "cloudManagementEndpoint": "str",
                "desiredProperties": {"diagnosticLevel": "str", "windowsServerSubscription": "str"},
                "principalId": "str",
                "tags": {"str": "str"},
                "tenantId": "str",
                "type": "str",
                "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.clusters.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_upload_certificate(self, resource_group):
        response = await (
            await self.client.clusters.begin_upload_certificate(
                resource_group_name=resource_group.name,
                cluster_name="str",
                upload_certificate_request={"properties": {"certificates": ["str"]}},
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_identity(self, resource_group):
        response = await (
            await self.client.clusters.begin_create_identity(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_extend_software_assurance_benefit(self, resource_group):
        response = await (
            await self.client.clusters.begin_extend_software_assurance_benefit(
                resource_group_name=resource_group.name,
                cluster_name="str",
                software_assurance_change_request={"properties": {"softwareAssuranceIntent": "str"}},
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_trigger_log_collection(self, resource_group):
        response = await (
            await self.client.clusters.begin_trigger_log_collection(
                resource_group_name=resource_group.name,
                cluster_name="str",
                log_collection_request={
                    "properties": {"fromDate": "2020-02-20 00:00:00", "toDate": "2020-02-20 00:00:00"}
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_configure_remote_support(self, resource_group):
        response = await (
            await self.client.clusters.begin_configure_remote_support(
                resource_group_name=resource_group.name,
                cluster_name="str",
                remote_support_request={
                    "properties": {
                        "accessLevel": "str",
                        "expirationTimeStamp": "2020-02-20 00:00:00",
                        "remoteSupportType": "str",
                    }
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
