# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class FluxComplianceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compliance state of the cluster object."""

    COMPLIANT = "Compliant"
    NON_COMPLIANT = "Non-Compliant"
    PENDING = "Pending"
    SUSPENDED = "Suspended"
    UNKNOWN = "Unknown"


class KustomizationValidationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify whether to validate the Kubernetes objects referenced in the Kustomization before
    applying them to the cluster.
    """

    NONE = "none"
    CLIENT = "client"
    SERVER = "server"


class OperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation to be performed on the selected layer. The default value is 'extract', but it can
    be set to 'copy'.
    """

    EXTRACT = "extract"
    COPY = "copy"


class ProviderType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the provider used for authentication."""

    AZURE = "Azure"
    """Azure provider can be used to authenticate to Azure DevOps repositories using Managed Identity."""
    GIT_HUB = "GitHub"
    """GitHub provider can be used to authenticate"""
    GENERIC = "Generic"
    """Generic is the default provider that indicates secret-based authentication mechanism."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class ScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope at which the configuration will be installed."""

    CLUSTER = "cluster"
    NAMESPACE = "namespace"


class SourceKindType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source Kind to pull the configuration data from."""

    GIT_REPOSITORY = "GitRepository"
    BUCKET = "Bucket"
    AZURE_BLOB = "AzureBlob"
    OCI_REPOSITORY = "OCIRepository"
