# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-deviceregistry
# USAGE
    python create_or_replace_namespace_device_edge_username_pass.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DeviceRegistryMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.namespace_devices.begin_create_or_replace(
        resource_group_name="myResourceGroup",
        namespace_name="adr-namespace-gbk0925-n01",
        device_name="namespace-device-on-edge",
        resource={
            "extendedLocation": {
                "name": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
                "type": "CustomLocation",
            },
            "location": "West Europe",
            "properties": {
                "attributes": {"deviceCategory": 16, "deviceOwner": "IT", "deviceType": "sensor"},
                "enabled": True,
                "endpoints": {
                    "inbound": {
                        "theOnlyOPCUABroker": {
                            "address": "opc.tcp://192.168.86.23:51211/UA/SampleServer",
                            "authentication": {
                                "method": "UsernamePassword",
                                "usernamePasswordCredentials": {
                                    "passwordSecretName": "pwd-ref",
                                    "usernameSecretName": "user-ref",
                                },
                            },
                            "endpointType": "microsoft.opcua",
                            "version": "2",
                        }
                    }
                },
                "externalDeviceId": "unique-edge-device-identifier",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-10-01/CreateOrReplace_NamespaceDevice_Edge_UsernamePass.json
if __name__ == "__main__":
    main()
