\name{scan.gwaa-class}
\docType{class}
\alias{scan.gwaa-class}
\alias{plot,scan.gwaa-method}
\alias{dim,scan.gwaa-method}
\alias{dimnames,scan.gwaa-method}
\alias{show,scan.gwaa-method}
\alias{[,scan.gwaa,ANY,ANY,ANY-method}
\alias{results,scan.gwaa-method}
\alias{results}
\alias{getfamily,scan.gwaa-method}
\alias{getfamily}
\alias{getcall,scan.gwaa-method}
\alias{getcall}
\alias{lambda,scan.gwaa-method}
\alias{lambda}
\alias{annotation,scan.gwaa-method}
\alias{idnames,scan.gwaa-method}
\alias{snpnames,scan.gwaa-method}
\alias{nids,scan.gwaa-method}
\alias{nsnps,scan.gwaa-method}
\alias{map,scan.gwaa-method}
\alias{chromosome,scan.gwaa-method}
\alias{strand,scan.gwaa-method}
\alias{coding,scan.gwaa-method}
\alias{refallele,scan.gwaa-method}
\alias{effallele,scan.gwaa-method}
\alias{male,scan.gwaa-method}

\title{Class "scan.gwaa"}
\description{This class contains results of GWA analysis. This is 
an list object, generated by \code{\link{scan.glm}}, \code{\link{scan.haplo}}, \code{\link{ccfast}}, 
\code{\link{qtscore}}, \code{\link{emp.ccfast}}, or \code{\link{emp.qtscore}}.
}
\section{Names}{
\describe{
  \item{snpnames}{list of names of SNPs tested}
  \item{P1df}{corresponding list of P-values of 1-d.f. (additive or allelic) 
		test for association bestween SNP and trait}
  \item{P2df}{corresponding list of P-values of 2-d.f. (genotypic) test for 
		association bestween SNP and trait}
  \item{Pc1df}{P-values from the 1-d.f. test for association bestween SNP 
		and trait; the statistics is corrected for possible 
		inflation}
  \item{effB}{Effect of the B allele in allelic test (OR for \code{\link{ccfast}}, difference from the mean for \code{\link{qtscore}} and beta from the \code{\link{scan.glm}})}
  \item{effAB}{Effect of the AB genotype in genotypic test}
  \item{effBB}{Effect of the BB genotype in genotypic test}
  \item{map}{list of map positions of the SNPs}
  \item{chromosome}{list of chromosomes the SNPs belong to}
  \item{idnames}{list of people used in analysis}
  \item{lambda}{list with elements "estimate" (inflation factor estimate, as 
		computed using lower 90 percents of the distribution) and 
		"se" (standard error of the estimate)}
  \item{formula}{which formula/function call was used to comput P-values}
  \item{family}{family of the link function / nature of the test}
}
}
%\section{Extends}{}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(object = "scan.gwaa")}: 
	Plots summary of GWAA}
  \item{[}{\code{signature(object = "scan.gwaa", i = "ANY", j = "ANY", drop = "ANY")}: 
  subsetting operation}
  \item{annotation}{\code{signature(object = "scan.gwaa")}: extracts annotation}
  \item{idnames}{\code{signature(object = "scan.gwaa")}: extracts id names}
  \item{snpnames}{\code{signature(object = "scan.gwaa")}: extracts snp names}
  \item{nids}{\code{signature(object = "scan.gwaa")}: extracts number of ids}
  \item{nsnps}{\code{signature(object = "scan.gwaa")}: extracts number of snps}
  \item{map}{\code{signature(object = "scan.gwaa")}: extracts map}
  \item{chromosome}{\code{signature(object = "scan.gwaa")}: extracts chromosome}
  \item{strand}{\code{signature(object = "scan.gwaa")}: extracts strand}
  \item{coding}{\code{signature(object = "scan.gwaa")}: extracts coding}
  \item{refallele}{\code{signature(object = "scan.gwaa")}: extracts reference allele}
  \item{effallele}{\code{signature(object = "scan.gwaa")}: extracts effective allele}
  \item{male}{\code{signature(object = "scan.gwaa")}: extracts male indicator}
	
  }
}
%\references{}
\author{Yurii Aulchenko}
%\note{}
\seealso{
\code{\link{ccfast}}, 
\code{\link{qtscore}}, 
\code{\link{scan.glm}},
\code{\link{scan.haplo}},
\code{\link{emp.ccfast}}, 
\code{\link{emp.qtscore}},
\code{\link{estlambda}},
\code{\link{plot.scan.gwaa}}
}
\examples{
require(GenABEL.data)
data(srdta)
sc <- qtscore(qt3,data=srdta,snps=c(1:10))
class(sc)
sc[,"P1df"]
sc[,"P2df"]
sc
plot(sc)
}
\keyword{classes}

