% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-.R, R/coord-cartesian-.R,
%   R/coord-fixed.R, R/coord-flip.R, R/coord-map.R, R/coord-polar.R,
%   R/coord-quickmap.R, R/coord-radial.R, R/coord-transform.R
\docType{data}
\name{Coord}
\alias{Coord}
\alias{CoordCartesian}
\alias{CoordFixed}
\alias{CoordFlip}
\alias{CoordMap}
\alias{CoordPolar}
\alias{CoordQuickmap}
\alias{CoordRadial}
\alias{CoordTransform}
\alias{CoordTrans}
\title{Coords}
\description{
All \verb{coord_*()} functions (like \code{coord_transform()}) return a \verb{Coord*} object
(like \code{CoordTransform}). These objects contain methods that support the
coordinate systems in ggplot2.
}
\details{
Each of the \verb{Coord*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended from the
top-level \code{Coord}, and each implements various methods and fields.
The object and its parameters are chaperoned by the \link{Layout} class.

To create a new type of Coord object, it is recommended
to extend not the base \code{Coord} class, but one of its children like
\code{CoordCartesian}.

When overriding the \code{transform()} method, it may be necessary to adapt the
implementation of \code{render_bg()} and possibly axis placement too.

An important data structure that coordinate systems create is the
\code{panel_params} structure. When overriding that structure, many methods may
need to be adapted as well.
}
\section{Fields}{

\describe{
\item{\code{default}}{Scaler boolean indicating whether this is the default
coordinate system. Non-default coordinate systems raise a message when
a new system replaces it.}

\item{\code{clip}}{A scalar string grid setting controlling whether layers should
be clipped to the extent of the plot panel extent. Can be \code{"on"} to
perform clipping, \code{"off"} to not clip, or \code{"inherit"} to take on the
setting of the parent viewport.}

\item{\code{reverse}}{A scalar string giving which directions to reverse. For
Cartesian systems, can be \verb{"none}, \code{"x"}, \code{"y"} or \code{"xy"} for both.
Non-Cartesian may define their own settings.}

\item{\code{setup_params}}{\strong{Description}

A function method for modifying or checking the parameters based on the
data. The default method parses the \code{expand} parameter.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$setup_params(data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames. The first item is the global data,
which is followed by layer data in subsequent items.}
}

\strong{Value}

A list of parameters}

\item{\code{setup_data}}{\strong{Description}

A function method for modifying or checking the data prior to adding
defaults. The default method returns data unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$setup_data(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames. The first item is the global data,
which is followed by layer data in subsequent items.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A list of data frames of the same length as the \code{data} argument}

\item{\code{setup_layout}}{\strong{Description}

A function method that acts as a hook for the coordinate system to have
input on the layout computed by facets.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$setup_layout(layout, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{layout}}{A data frame computed by \code{Facet$compute_layout()}.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A data frame from the modified \code{layout} argument. The default creates a
new \code{COORD} column to identify unique combinations of x and y scales for
efficiency purposes. It should never remove columns.}

\item{\code{modify_scales}}{\strong{Description}

A function method for modifying scales in place. This is optional and
currently used by CoordFlip and CoordPolar to ensure axis positions are
conforming to the coordinate system.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$modify_scales(scales_x, scales_y)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{scales_x},\code{scales_y}}{A list of trained scales for the \code{x} and \code{y}
aesthetics respectively.}
}

\strong{Value}

Nothing, this is called for the side effect of modifying scales.}

\item{\code{setup_panel_params}}{\strong{Description}

This function method is used to setup panel parameters per panel.
For efficiency reasons, this method is called once per combination of
\code{x} and \code{y} scales. It is used to instantiate ViewScale class objects and
ranges for position aesthetics and optionally append additional
parameters needed for the \code{transform()} method and rendering axes.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$setup_panel_params(scale_x, scale_y, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{scale_x},\code{scale_y}}{A list of trained scales for the \code{x} and \code{y}
aesthetics respectively.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A named list of view scales, ranges and other optional parameters.}

\item{\code{setup_panel_guides}}{\strong{Description}

This function method is used to initiate position guides for each panel.
For efficiency reasons, this method is called once per combination of \code{x}
and \code{y} scales. For the primary and secondary positions, it should resolve
guides coming from the \code{plot$guides} field and \code{Scale$guide} fields and
set appropriate \code{Guide$params$position} parameters.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$setup_panel_guides(panel_params, guides, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
\item{\code{guides}}{A \verb{<Guides>} ggproto class.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

The \code{panel_params} object but with a Guides class object appended with
the name 'guides'.}

\item{\code{setup_panel_guides}}{\strong{Description}

This function method is used to train and transform position guides for each
panel. For efficiency reasons, this method is called once per combination
of \code{x} and \code{y} scales.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$train_panel_guides(panel_params, layers, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects, a Guides class
object and additional parameters from the \code{setup_panel_params()} method.}
\item{\code{layers}}{A list of layers from \code{plot$layers}.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

The \code{panel_params} object, but with trained and transformed \code{guides}
parameter.}

\item{\code{transform}}{\strong{Description}

This function method is used to apply transformations and rescale position
aesthetics. This method is used in several places:
\itemize{
\item The Geom drawing code, used through \code{coord_munch()} in many Geoms.
\item The Guide transform method
\item Panel grid transformation in \code{render_bg()}
}

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$transform(data, panel_params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with columns for numeric position aesthetics.}
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
}

\strong{Value}

The \code{data} argument with rescaled and transformed position aesthetics.}

\item{\code{distance}}{\strong{Description}

This function method is used to calculate distances between subsequent
data points. \code{coord_munch()} uses this method determine how many points
should be used to interpolate.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$distance(x, y, panel_params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{x},\code{y}}{x and y coordinates of a set of points in data space.}
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
}

\strong{Value}

The \code{data} argument with rescaled and transformed position aesthetics.}

\item{\code{backtransform_range}}{\strong{Description}

This function method is used to convert ranges from transformed coordinates
back into data coordinates. The data coordinates may possibly be scale-
transformed. It is used in \code{coord_munch()} to ensure limits are in data
coordinates.

The back-transformation may be needed for coords such as \code{coord_transform()},
where the range in the transformed coordinates differs from the range in
the untransformed coordinates.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$backtransform_range(panel_params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
}

\strong{Value}

A list containing numeric ranges for \code{x} and \code{y} in data coordinates.}

\item{\code{range}}{\strong{Description}

This function method is a small helper method to extract ranges from the
\code{panel_params} object. It exists because \code{panel_params} can be opaque at
times.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$range(panel_params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
}

\strong{Value}

A list containing numeric ranges for \code{x} and \code{y}.}

\item{\code{draw_panel}}{\strong{Description}

This function method is used to orchestrate decorating panel drawings with
foreground and background drawings. It is called once per panel, invokes
the \code{render_fg()} and \code{render_bg()} methods and enforces the \code{clip} field.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$draw_panel(panel, params, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel}}{A grob containing drawn layers and facet foreground and
background.}
\item{\code{params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}}
}

\strong{Value}

A grob with panel content.}

\item{\code{render_fg}}{\strong{Description}

This function method is used to draw the panel foreground. For all
intents and purposes is just the \code{panel.border} theme element, but you can
repurpose this method.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$render_fg(panel_params, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}}
}

\strong{Value}

A grob with panel foreground.}

\item{\code{render_bg}}{\strong{Description}

This function method is used to draw the panel background. Typically
this is a combination of the \code{panel.background} and \code{panel.grid} theme
elements.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$render_bg(panel_params, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}}
}

\strong{Value}

A grob with panel background.}

\item{\code{labels}}{\strong{Description}

This function method is used to format axis titles. It is used in some
coordinate systems to (conditionally) swap x and y labels.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$labels(labels, panel_params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{labels}}{A named list containing an \code{x} list and a \code{y} list. The
\code{x} and \code{y} lists have \code{primary} and \code{secondary} labels.}
\item{\code{panel_params}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method.}
}

\strong{Value}

A list with the same structure and names as the \code{labels} argument.}

\item{\code{aspect}}{\strong{Description}

This function method that gives the aspect ratio for panels. It allows for
\code{CoordFixed} to compute an aspect ratio based on data ranges.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$render_bg(panel_params, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{ranges}}{A list of ViewScale class objects and additional
parameters from the \code{setup_panel_params()} method. If there are
multiple panels, the parameters for the first panel is used.}
}

\strong{Value}

A scalar numeric}

\item{\code{render_axis_h,render_axis_v}}{\strong{Description}

These function methods are used to render axes to place at the outside edge
of panels. Interior axes should not be rendered here. The \code{render_axis_h()}
methods produces the horizontal axes for the top and bottom position.
The \code{render_axis_v()} method renders the vertical axes for the left and
right position.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$render_axis_h(panel_params, theme
Coord$render_axis_v(panel_params, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A list of ViewScale class objects, a Guides class
object and additional parameters from the \code{setup_panel_params()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}}
}

\strong{Value}

For \code{render_axis_h()} a named list where \code{"top"} and \code{"bottom"} are grobs
with an axis. For \code{render_axis_v()} a named list where \code{"left"} and
\code{"right"} are grobs with an axis. These grobs should be \code{\link[=zeroGrob]{zeroGrob()}}
when no axes should be rendered.}

\item{\code{is_linear}}{\strong{Description}

This function method is used to signal whether a coordinate system is
linear. In \code{coord_munch()} and several Geom drawing methods, it is used to
determine whether points should be interpolated.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$is_linear()
}\if{html}{\out{</div>}}

\strong{Value}

A scalar boolean.}

\item{\code{is_free}}{\strong{Description}

This function method is used to signal whether a coordinate system supports
free scaling of axes in faceted plots. This should generally return \code{FALSE}
for coordinate systems that enforce a fixed aspect ratio.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Coord$is_free()
}\if{html}{\out{</div>}}

\strong{Value}

A scalar boolean.}
}}

\section{Conventions}{


The object name that a new class is assigned to is typically the same as the
class name. Coord class names are in UpperCamelCase and start with the
\verb{Coord*} prefix, like \code{CoordNew}.

A constructor function is usually paired with a Coord class. The constructor
copies the coord class and populates parameters. The constructor function name
should take the Coord class name and be formatted with snake_case,
so that \code{CoordNew} becomes \code{coord_new()}.
}

\examples{
# Extending the class
CoordJitter <- ggproto(
  "CoordJitter", CoordCartesian,
  # Fields
  amount = 0,
  # Methods
  is_linear = function() FALSE,
  transform = function(self, data, panel_params) {
    data   <- ggproto_parent(CoordCartesian, self)$transform(data, panel_params)
    data$x <- jitter(data$x, amount = self$amount)
    data$y <- jitter(data$y, amount = self$amount)
    data
  }
)

# Building a constructor
coord_jitter <- function(amount = 0.005, xlim = NULL, ylim = NULL, expand = TRUE,
                         clip = "on", reverse = "none") {
  ggproto(
    NULL, CoordJitter,
    amount = amount,
    limits = list(x = xlim, y = ylim),
    reverse = reverse, expand = expand, clip = clip
  )
}

# Use new coord in plot
set.seed(42)
ggplot(mpg, aes(drv, displ)) +
  geom_boxplot() +
  coord_jitter()
}
\seealso{
The \href{https://ggplot2-book.org/extensions#sec-new-coords}{new coords section} of the online ggplot2 book.

Other Layout components: 
\code{\link{Facet}},
\code{\link{Layout}}
}
\concept{Layout components}
\keyword{datasets}
\keyword{internal}
