% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateIndTree.R
\name{simulateIndTree}
\alias{simulateIndTree}
\title{Simulate randomised "individuals" tree}
\usage{
simulateIndTree(
  catTree,
  itips = 5,
  permuteCat = FALSE,
  permuteTips = TRUE,
  tipPercent = 100
)
}
\arguments{
\item{catTree}{object of class phylo, the category-level tree}

\item{itips}{number of individual tips to assign per category}

\item{permuteCat}{logical specifying whether to permute the category labels on the category tree before grafting on individual tips. Defaults to FALSE.}

\item{permuteTips}{logical specifying whether to permute the individual tip labels after building the individual level tree based on the category tree. Defaults to TRUE.}

\item{tipPercent}{number specifying the percentage of tips to be permuted. Defaults to 100, ignored if permuteTips=FALSE.}
}
\description{
This function takes in a "category" tree and outputs a simulated corresponding "individuals" tree, for testing the concordance measure.
}
\examples{
tree <- simulateIndTree(rtree(3))
plot(tree)

}
\seealso{
\code{\link{treeConcordance}} \code{\link{makeCollapsedTree}}
}
