% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{vec_chop}
\alias{vec_chop}
\title{Repeatedly slice a vector}
\usage{
vec_chop(x, indices = NULL)
}
\arguments{
\item{x}{A vector}

\item{indices}{A list of index values to slice \code{x} with, or \code{NULL}. Each
element of the list must be an integer, character or logical vector that
would be valid as an index in \code{\link[=vec_slice]{vec_slice()}}. If \code{NULL}, \code{x} is split into
its individual elements, equivalent to using an \code{indices} of
\code{as.list(vec_seq_along(x))}.}
}
\value{
A list of size \code{vec_size(indices)} or, if \code{indices == NULL},
\code{vec_size(x)}.
}
\description{
\code{vec_chop()} provides an efficient method to repeatedly slice a vector. It
captures the pattern of \code{map(indices, vec_slice, x = x)}.
}
\examples{
vec_chop(1:5)
vec_chop(1:5, list(1, 1:2))
vec_chop(mtcars, list(1:3, 4:6))
}
