# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 9, 92, 
	10, 10, 9, 92, 58, 58, 
	98, 98, 101, 101, 103, 
	103, 105, 105, 110, 110, 
	0, 122, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 10, 10, 
	0, 127, 0, 127, 61, 126, 
	93, 93, 0, 127, 0, 
	127, 10, 10, 34, 34, 
	10, 10, 39, 39, 0, 127, 
	10, 96, 96, 96, 0, 
	45, 0, 77, 0, 77, 
	0, 92, 0, 26, 0, 26, 
	0, 45, 0, 99, 0, 
	26, 67, 99, 45, 45, 
	0, 92, 0, 77, 0, 102, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 58, 58, 58, 
	0, 127, 43, 57, 48, 
	57, 48, 57, 48, 57, 
	48, 57, 115, 115, 99, 99, 
	117, 117, 101, 101, 99, 
	99, 117, 117, 101, 101, 
	0, 127, 58, 58, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	60, 60, 10, 10, 9, 46, 
	9, 32, 10, 10, 10, 
	10, 10, 10, 10, 10, 
	46, 46, 0, 95, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 98, 98, 9, 32, 
	10, 10, 95, 95, 0, 92, 
	9, 32, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 120, 0, 0, 0, 0, 
	48, 55, 48, 55, 0, 
	0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 45, 45, 0, 
	0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 123, 
	48, 102, 48, 102, 48, 
	102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 0, 
	0, 92, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 120, 0, 0, 0, 0, 
	48, 55, 48, 55, 0, 
	0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 45, 45, 0, 
	0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 123, 
	48, 102, 48, 102, 48, 
	102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 0, 
	0, 92, 9, 32, 0, 
	26, 0, 92, 0, 26, 
	0, 35, 36, 123, 0, 127, 
	48, 57, 0, 127, 0, 
	26, 0, 35, 9, 32, 
	36, 123, 0, 127, 48, 57, 
	0, 127, 0, 32, 9, 
	32, 65, 122, 65, 122, 
	36, 64, 0, 127, 48, 57, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 
	127, 48, 57, 115, 115, 
	38, 38, 42, 42, 64, 64, 
	58, 58, 60, 61, 62, 
	62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 124, 
	124, 0, 127, 0, 127, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 38, 38, 42, 42, 
	64, 64, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 93, 93, 
	10, 10, 124, 124, 0, 126, 
	0, 127, 0, 61, 9, 
	61, 9, 61, 0, 0, 
	9, 61, 9, 62, 46, 46, 
	46, 46, 58, 58, 9, 
	32, 0, 0, 0, 127, 
	0, 0, 9, 124, 0, 0, 
	10, 10, 10, 10, 0, 
	0, 9, 61, 58, 58, 
	60, 60, 62, 62, 9, 32, 
	10, 10, 0, 127, 102, 
	102, 101, 101, 110, 110, 
	104, 104, 0, 127, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 10, 10, 0, 123, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 111, 
	111, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 61, 0, 0, 
	61, 126, 61, 61, 0, 
	0, 0, 0, 0, 0, 
	9, 32, 61, 61, 9, 32, 
	61, 126, 10, 10, 10, 
	10, 65, 122, 0, 122, 
	38, 61, 0, 0, 42, 61, 
	61, 61, 9, 92, 9, 
	92, 9, 92, 46, 46, 
	46, 46, 0, 26, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 61, 126, 61, 62, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 61, 126, 0, 
	127, 48, 57, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 61, 61, 
	62, 0, 127, 48, 57, 
	0, 127, 124, 124, 64, 64, 
	60, 61, 0, 0, 10, 
	34, 10, 39, 96, 96, 
	62, 62, 61, 126, 61, 62, 
	0, 122, 0, 0, 0, 
	127, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 55, 
	48, 55, 0, 0, 0, 
	0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	45, 45, 0, 0, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 0, 92, 0, 92, 
	0, 0, 0, 0, 0, 
	92, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 
	0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 
	102, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 0, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 61, 126, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 
	124, 0, 92, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 0, 127, 0, 127, 
	48, 57, 61, 61, 38, 61, 
	0, 0, 0, 0, 42, 
	61, 61, 62, 46, 57, 
	46, 46, 10, 10, 48, 101, 
	48, 95, 46, 120, 48, 
	114, 43, 57, 48, 105, 
	102, 102, 0, 0, 101, 105, 
	0, 0, 0, 0, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 105, 114, 102, 102, 
	0, 0, 101, 105, 115, 
	115, 0, 0, 0, 0, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	46, 114, 48, 114, 46, 114, 
	48, 114, 58, 58, 60, 
	61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 
	0, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 9, 92, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 61, 124, 
	0, 0, 9, 92, 9, 46, 
	9, 92, 10, 10, 46, 
	46, 10, 10, 10, 61, 
	10, 10, 10, 101, 10, 110, 
	10, 100, 10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 84, 
	1, 84, 1, 1, 1, 1, 1, 1, 
	123, 1, 84, 84, 84, 84, 84, 1, 
	128, 128, 66, 1, 128, 128, 1, 1, 
	1, 1, 128, 87, 1, 46, 78, 78, 
	93, 27, 27, 46, 100, 27, 33, 1, 
	93, 78, 103, 128, 128, 128, 128, 128, 
	128, 1, 1, 128, 15, 10, 10, 10, 
	10, 1, 1, 1, 1, 1, 1, 1, 
	128, 1, 84, 84, 84, 84, 84, 84, 
	1, 1, 38, 24, 1, 1, 1, 1, 
	1, 96, 24, 0, 1, 1, 1, 24, 
	1, 1, 93, 24, 88, 128, 10, 128, 
	121, 0, 0, 8, 8, 0, 0, 93, 
	0, 0, 0, 93, 1, 0, 0, 0, 
	93, 46, 93, 93, 0, 0, 93, 46, 
	1, 93, 76, 55, 55, 55, 0, 126, 
	126, 0, 126, 0, 126, 126, 126, 126, 
	0, 126, 126, 126, 126, 126, 126, 0, 
	0, 55, 0, 93, 88, 128, 10, 128, 
	121, 0, 0, 8, 8, 0, 0, 93, 
	0, 0, 0, 93, 1, 0, 0, 0, 
	93, 46, 93, 93, 0, 0, 93, 46, 
	1, 93, 76, 55, 55, 55, 0, 126, 
	126, 0, 126, 0, 126, 126, 126, 126, 
	0, 126, 126, 126, 126, 126, 126, 0, 
	0, 55, 0, 93, 24, 27, 93, 27, 
	36, 88, 128, 10, 128, 27, 36, 24, 
	88, 128, 10, 128, 33, 24, 58, 58, 
	29, 128, 10, 128, 128, 128, 128, 24, 
	0, 66, 1, 1, 128, 128, 10, 1, 
	1, 1, 1, 1, 2, 1, 66, 1, 
	2, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 1, 128, 128, 
	24, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 1, 1, 
	1, 2, 1, 66, 1, 2, 128, 1, 
	1, 1, 127, 128, 62, 53, 53, 0, 
	53, 54, 1, 1, 1, 24, 0, 128, 
	0, 116, 0, 1, 1, 0, 53, 1, 
	1, 1, 24, 1, 128, 1, 1, 1, 
	1, 128, 128, 128, 0, 128, 1, 124, 
	24, 1, 1, 1, 0, 1, 0, 128, 
	128, 24, 0, 1, 1, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 4, 0, 66, 1, 0, 0, 0, 
	24, 1, 24, 66, 1, 1, 58, 123, 
	24, 0, 20, 1, 84, 84, 84, 1, 
	1, 27, 128, 128, 1, 0, 66, 2, 
	0, 0, 0, 0, 66, 128, 10, 1, 
	1, 1, 2, 1, 1, 2, 128, 10, 
	128, 1, 1, 2, 0, 25, 30, 1, 
	1, 66, 2, 123, 0, 128, 128, 121, 
	0, 0, 8, 8, 0, 0, 93, 0, 
	0, 0, 93, 1, 0, 0, 0, 93, 
	46, 93, 93, 0, 0, 93, 46, 1, 
	93, 76, 55, 55, 55, 0, 126, 126, 
	0, 126, 0, 126, 126, 126, 126, 0, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 0, 0, 55, 0, 128, 
	128, 128, 0, 1, 0, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 66, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 0, 64, 93, 24, 
	0, 1, 1, 1, 0, 128, 128, 24, 
	0, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 128, 128, 
	10, 1, 24, 0, 0, 20, 2, 12, 
	1, 1, 54, 48, 75, 67, 15, 58, 
	1, 0, 5, 0, 0, 67, 67, 67, 
	67, 10, 1, 0, 5, 1, 0, 0, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	69, 67, 69, 67, 1, 2, 1, 66, 
	1, 2, 128, 128, 0, 128, 128, 128, 
	128, 128, 128, 0, 1, 0, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 84, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 0, 64, 
	0, 84, 38, 84, 1, 1, 1, 52, 
	1, 92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7442, 7444, 7529, 7531, 7533, 7535, 7537, 7539, 
	7541, 7665, 7667, 7752, 7837, 7922, 8007, 8092, 
	8094, 8223, 8352, 8419, 8421, 8550, 8679, 8681, 
	8683, 8685, 8687, 8816, 8904, 8906, 8953, 9032, 
	9111, 9205, 9233, 9261, 9308, 9409, 9437, 9471, 
	9473, 9567, 9646, 9750, 9879, 10008, 10137, 10266, 
	10395, 10524, 10526, 10528, 10657, 10673, 10684, 10695, 
	10706, 10717, 10719, 10721, 10723, 10725, 10727, 10729, 
	10731, 10860, 10862, 10947, 11032, 11117, 11202, 11287, 
	11372, 11374, 11376, 11415, 11440, 11442, 11444, 11446, 
	11448, 11450, 11547, 11572, 11573, 11575, 11577, 11579, 
	11604, 11606, 11608, 11702, 11727, 11816, 11945, 11956, 
	12085, 12207, 12208, 12209, 12218, 12227, 12228, 12229, 
	12323, 12324, 12325, 12326, 12420, 12422, 12423, 12424, 
	12425, 12519, 12566, 12660, 12754, 12755, 12756, 12850, 
	12897, 12899, 12993, 13070, 13126, 13182, 13238, 13239, 
	13366, 13493, 13494, 13621, 13622, 13749, 13876, 14003, 
	14130, 14131, 14258, 14385, 14512, 14639, 14766, 14893, 
	14894, 14895, 14951, 14952, 15046, 15135, 15264, 15275, 
	15404, 15526, 15527, 15528, 15537, 15546, 15547, 15548, 
	15642, 15643, 15644, 15645, 15739, 15741, 15742, 15743, 
	15744, 15838, 15885, 15979, 16073, 16074, 16075, 16169, 
	16216, 16218, 16312, 16389, 16445, 16501, 16557, 16558, 
	16685, 16812, 16813, 16940, 16941, 17068, 17195, 17322, 
	17449, 17450, 17577, 17704, 17831, 17958, 18085, 18212, 
	18213, 18214, 18270, 18271, 18365, 18390, 18418, 18512, 
	18540, 18577, 18666, 18795, 18806, 18935, 18963, 19000, 
	19025, 19114, 19243, 19254, 19383, 19417, 19442, 19501, 
	19560, 19590, 19719, 19730, 19859, 19988, 20117, 20246, 
	20271, 20272, 20339, 20341, 20343, 20472, 20601, 20612, 
	20614, 20616, 20618, 20620, 20622, 20625, 20627, 20694, 
	20696, 20699, 20828, 20957, 21086, 21215, 21344, 21473, 
	21602, 21604, 21606, 21735, 21864, 21993, 22122, 22251, 
	22380, 22509, 22638, 22767, 22896, 23025, 23154, 23283, 
	23412, 23541, 23670, 23799, 23928, 24057, 24186, 24315, 
	24444, 24573, 24702, 24831, 24960, 25089, 25218, 25347, 
	25476, 25605, 25734, 25863, 25992, 26121, 26250, 26379, 
	26508, 26637, 26766, 26895, 27024, 27153, 27282, 27411, 
	27540, 27669, 27798, 27927, 28056, 28185, 28314, 28443, 
	28572, 28701, 28830, 28959, 29088, 29217, 29346, 29475, 
	29604, 29733, 29862, 29991, 30120, 30249, 30378, 30507, 
	30636, 30765, 30894, 31023, 31152, 31281, 31410, 31539, 
	31668, 31797, 31926, 32055, 32184, 32313, 32315, 32444, 
	32573, 32598, 32600, 32602, 32604, 32605, 32734, 32863, 
	32865, 32866, 32891, 32892, 32959, 32961, 32963, 32965, 
	32967, 32969, 32972, 32974, 33041, 33043, 33046, 33175, 
	33177, 33179, 33181, 33309, 33438, 33501, 33555, 33609, 
	33610, 33664, 33719, 33721, 33723, 33725, 33750, 33751, 
	33880, 33881, 33998, 33999, 34001, 34003, 34004, 34058, 
	34060, 34062, 34064, 34089, 34091, 34220, 34222, 34224, 
	34226, 34228, 34357, 34486, 34615, 34616, 34745, 34747, 
	34872, 34897, 34899, 34901, 34903, 34904, 34906, 34907, 
	35036, 35165, 35190, 35191, 35193, 35195, 35197, 35198, 
	35327, 35456, 35585, 35714, 35843, 35972, 36101, 36230, 
	36359, 36488, 36617, 36746, 36875, 37004, 37133, 37262, 
	37391, 37520, 37525, 37526, 37593, 37595, 37596, 37597, 
	37598, 37623, 37625, 37650, 37717, 37719, 37721, 37780, 
	37904, 37929, 37930, 37951, 37953, 38038, 38123, 38208, 
	38210, 38212, 38240, 38369, 38498, 38500, 38501, 38568, 
	38571, 38572, 38573, 38574, 38575, 38642, 38771, 38782, 
	38784, 38786, 38788, 38791, 38793, 38795, 38798, 38927, 
	38938, 39067, 39069, 39071, 39074, 39075, 39101, 39132, 
	39134, 39136, 39203, 39206, 39330, 39331, 39460, 39589, 
	39711, 39712, 39713, 39722, 39731, 39732, 39733, 39827, 
	39828, 39829, 39830, 39924, 39926, 39927, 39928, 39929, 
	40023, 40070, 40164, 40258, 40259, 40260, 40354, 40401, 
	40403, 40497, 40574, 40630, 40686, 40742, 40743, 40870, 
	40997, 40998, 41125, 41126, 41253, 41380, 41507, 41634, 
	41635, 41762, 41889, 42016, 42143, 42270, 42397, 42524, 
	42651, 42778, 42905, 43032, 43159, 43286, 43413, 43540, 
	43667, 43794, 43921, 44048, 44049, 44050, 44106, 44107, 
	44236, 44365, 44494, 44495, 44497, 44498, 44627, 44756, 
	44885, 45014, 45143, 45272, 45401, 45530, 45659, 45788, 
	45917, 46046, 46175, 46304, 46433, 46562, 46691, 46820, 
	46949, 47078, 47207, 47336, 47465, 47594, 47723, 47852, 
	47981, 48110, 48239, 48368, 48497, 48626, 48755, 48884, 
	49013, 49142, 49271, 49400, 49529, 49658, 49787, 49916, 
	50045, 50174, 50303, 50432, 50561, 50690, 50819, 50948, 
	51077, 51206, 51335, 51464, 51593, 51722, 51851, 51980, 
	52109, 52238, 52367, 52434, 52563, 52692, 52821, 52950, 
	53079, 53208, 53337, 53466, 53595, 53724, 53853, 53982, 
	54111, 54240, 54369, 54498, 54627, 54756, 54885, 55014, 
	55143, 55272, 55401, 55530, 55659, 55660, 55725, 55819, 
	55844, 55845, 55847, 55849, 55851, 55852, 55981, 56110, 
	56135, 56136, 56138, 56140, 56142, 56143, 56272, 56401, 
	56403, 56404, 56429, 56430, 56497, 56499, 56501, 56630, 
	56759, 56770, 56772, 56797, 56798, 56799, 56820, 56823, 
	56836, 56838, 56840, 56895, 56944, 57020, 57088, 57104, 
	57163, 57165, 57166, 57172, 57173, 57174, 57242, 57310, 
	57378, 57446, 57457, 57459, 57460, 57466, 57468, 57469, 
	57470, 57538, 57606, 57674, 57742, 57810, 57878, 57946, 
	58014, 58084, 58152, 58222, 58290, 58292, 58295, 58297, 
	58364, 58366, 58369, 58498, 58627, 58628, 58757, 58886, 
	59015, 59144, 59273, 59402, 59403, 59405, 59406, 59407, 
	59536, 59665, 59794, 59923, 60052, 60181, 60310, 60439, 
	60568, 60697, 60826, 60955, 61084, 61213, 61342, 61471, 
	61600, 61729, 61858, 61987, 62116, 62245, 62374, 62503, 
	62632, 62761, 62890, 63019, 63148, 63277, 63406, 63535, 
	63664, 63793, 63922, 64051, 64180, 64265, 64394, 64523, 
	64652, 64781, 64910, 65039, 65168, 65297, 65426, 65555, 
	65684, 65813, 65942, 66071, 66200, 66329, 66458, 66587, 
	66716, 66845, 66974, 67103, 67232, 67361, 67490, 67619, 
	67748, 67877, 68006, 68135, 68264, 68393, 68522, 68651, 
	68780, 68909, 69038, 69167, 69296, 69425, 69554, 69683, 
	69812, 69941, 70070, 70199, 70328, 70457, 70586, 70715, 
	70844, 70973, 71102, 71231, 71360, 71489, 71618, 71747, 
	71876, 72005, 72134, 72263, 72392, 72521, 72650, 72651, 
	72716, 72717, 72802, 72841, 72926, 72928, 72930, 72932, 
	72985, 72987, 73080, 73182, 73274
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 12, 12, 12, 12, 12, 12, 
	18, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 19, 20, 20, 20, 19, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 19, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 21, 
	20, 19, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 23, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 24, 22, 
	19, 22, 22, 22, 19, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 19, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 25, 22, 19, 
	26, 26, 26, 19, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 19, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 27, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 28, 26, 19, 29, 29, 
	29, 19, 29, 29, 29, 29, 29, 30, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 19, 
	29, 19, 29, 29, 29, 19, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 19, 29, 19, 20, 20, 
	20, 19, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 19, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 31, 20, 19, 32, 32, 32, 
	19, 32, 32, 32, 32, 32, 33, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 19, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 34, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	35, 32, 32, 32, 32, 32, 32, 36, 
	32, 19, 32, 32, 32, 19, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 19, 32, 37, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 38, 19, 38, 
	19, 19, 39, 39, 39, 19, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 19, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	40, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 41, 39, 19, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 23, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 19, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 25, 22, 19, 42, 
	42, 42, 19, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	19, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	42, 42, 42, 42, 42, 42, 42, 43, 
	43, 43, 43, 43, 43, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 43, 
	43, 43, 43, 43, 43, 42, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 46, 
	46, 44, 46, 44, 46, 46, 44, 44, 
	46, 46, 46, 47, 46, 46, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	46, 46, 46, 46, 46, 46, 46, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 44, 46, 44, 44, 45, 46, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 44, 44, 44, 46, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 44, 44, 44, 44, 44, 44, 44, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 44, 44, 44, 44, 46, 44, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 44, 44, 44, 44, 44, 46, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 44, 44, 44, 44, 44, 44, 
	50, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 44, 44, 44, 44, 45, 
	44, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 44, 44, 44, 44, 44, 
	45, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 44, 44, 44, 44, 44, 
	44, 44, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 44, 44, 44, 44, 
	45, 44, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 44, 44, 44, 44, 
	44, 45, 51, 52, 52, 52, 51, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 51, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 53, 
	52, 51, 54, 54, 54, 51, 54, 54, 
	54, 54, 54, 55, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 51, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 56, 54, 
	51, 54, 54, 54, 51, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 51, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 57, 54, 51, 
	58, 58, 58, 51, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 51, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 59, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 60, 58, 51, 61, 61, 
	61, 51, 61, 61, 61, 61, 61, 62, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 51, 
	61, 51, 61, 61, 61, 51, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 51, 61, 51, 52, 52, 
	52, 51, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 51, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 63, 52, 51, 64, 64, 64, 
	51, 64, 64, 64, 64, 64, 65, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 51, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 66, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	67, 64, 64, 64, 64, 64, 64, 68, 
	64, 51, 64, 64, 64, 51, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 51, 64, 69, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 70, 51, 70, 
	51, 51, 71, 71, 71, 51, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 51, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	72, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 73, 71, 51, 
	54, 54, 54, 51, 54, 54, 54, 54, 
	54, 55, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 51, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 57, 54, 51, 74, 
	74, 74, 51, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	51, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	74, 74, 74, 74, 74, 74, 74, 75, 
	75, 75, 75, 75, 75, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 75, 
	75, 75, 75, 75, 75, 74, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 78, 
	78, 76, 78, 76, 78, 78, 76, 76, 
	78, 78, 78, 79, 78, 78, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	78, 78, 78, 78, 78, 78, 78, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 76, 78, 76, 76, 77, 78, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 76, 76, 76, 78, 76, 77, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 76, 76, 76, 76, 76, 76, 76, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 76, 76, 76, 76, 78, 76, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 76, 76, 76, 76, 76, 78, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 76, 76, 76, 76, 76, 76, 
	82, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 76, 76, 76, 76, 77, 
	76, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 76, 76, 76, 76, 76, 
	77, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 76, 76, 76, 76, 76, 
	76, 76, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 76, 76, 76, 76, 
	77, 76, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 76, 76, 76, 76, 
	76, 77, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 85, 85, 83, 85, 83, 
	85, 85, 83, 83, 85, 85, 85, 86, 
	85, 85, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 85, 85, 85, 85, 
	85, 85, 85, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 83, 85, 83, 
	83, 84, 85, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 83, 83, 83, 
	85, 83, 84, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 83, 83, 83, 
	83, 83, 83, 83, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 83, 83, 
	83, 83, 85, 83, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 83, 83, 
	83, 83, 83, 85, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 83, 83, 
	83, 83, 83, 83, 89, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 84, 83, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 83, 84, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 83, 
	83, 83, 83, 83, 83, 83, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	83, 83, 83, 83, 84, 83, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	83, 83, 83, 83, 83, 84, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 91, 
	91, 92, 91, 92, 91, 91, 92, 92, 
	91, 91, 91, 93, 91, 91, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	91, 91, 91, 91, 91, 91, 91, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 92, 91, 92, 92, 90, 91, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 92, 92, 92, 91, 92, 90, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 92, 92, 92, 92, 92, 92, 92, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 92, 92, 92, 92, 91, 92, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 92, 92, 92, 92, 92, 91, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 92, 92, 92, 92, 92, 92, 
	96, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 92, 92, 92, 92, 95, 
	92, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 92, 92, 92, 92, 92, 
	95, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 92, 92, 92, 92, 92, 
	92, 92, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 92, 92, 92, 92, 
	97, 92, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 92, 92, 92, 92, 
	92, 97, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 98, 98, 98, 98, 
	98, 98, 98, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 98, 98, 98, 
	98, 99, 98, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 98, 98, 98, 
	98, 98, 99, 100, 101, 101, 101, 100, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 100, 101, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	104, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 105, 102, 102, 102, 102, 104, 102, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 102, 102, 102, 102, 103, 102, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 102, 102, 102, 102, 102, 103, 
	105, 102, 102, 106, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 109, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 107, 
	107, 107, 107, 109, 107, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 107, 
	107, 107, 107, 108, 107, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 107, 
	107, 107, 107, 107, 108, 110, 107, 112, 
	111, 113, 111, 114, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 116, 111, 
	116, 116, 116, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 116, 111, 111, 
	111, 111, 117, 118, 111, 119, 111, 120, 
	121, 122, 123, 124, 117, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 125, 
	111, 126, 122, 127, 128, 111, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	129, 130, 122, 131, 115, 111, 115, 115, 
	115, 115, 115, 115, 115, 115, 132, 115, 
	115, 115, 115, 115, 115, 115, 115, 133, 
	115, 115, 134, 115, 135, 115, 115, 115, 
	136, 137, 111, 131, 111, 115, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 138, 
	111, 138, 138, 138, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 138, 111, 
	111, 111, 111, 139, 140, 111, 141, 111, 
	142, 143, 144, 145, 146, 139, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	147, 111, 148, 144, 149, 150, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 151, 152, 144, 113, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 153, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	154, 108, 108, 155, 108, 156, 108, 108, 
	108, 157, 158, 111, 113, 111, 108, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	109, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 110, 111, 111, 111, 111, 109, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 108, 111, 
	108, 108, 108, 108, 108, 159, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 111, 108, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 109, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 110, 111, 111, 111, 111, 109, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 108, 
	111, 108, 108, 108, 108, 160, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 111, 
	108, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 109, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 110, 111, 111, 111, 111, 
	109, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	108, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 161, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	111, 108, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 109, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 110, 111, 111, 111, 
	111, 109, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 108, 111, 108, 108, 162, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 111, 108, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 109, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 111, 111, 
	111, 111, 109, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 108, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	163, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 111, 108, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 109, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 111, 
	111, 111, 111, 109, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 108, 111, 108, 108, 108, 
	108, 159, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 111, 108, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 109, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 110, 
	111, 111, 111, 111, 109, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 108, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 164, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 111, 108, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 109, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	110, 111, 111, 111, 111, 109, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 165, 108, 108, 108, 108, 108, 
	108, 108, 166, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 111, 108, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	109, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 110, 111, 111, 111, 111, 109, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 108, 111, 
	108, 108, 108, 108, 167, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 111, 108, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 109, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 110, 111, 111, 111, 111, 109, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 108, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 168, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 111, 
	108, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 109, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 110, 111, 111, 111, 111, 
	109, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	108, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 159, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	111, 108, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 109, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 110, 111, 111, 111, 
	111, 109, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 108, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 169, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 111, 108, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 109, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 111, 111, 
	111, 111, 109, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 108, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 159, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 111, 108, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 109, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 111, 
	111, 111, 111, 109, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 108, 111, 108, 108, 108, 
	108, 108, 108, 108, 170, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 111, 108, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 109, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 110, 
	111, 111, 111, 111, 109, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 108, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 171, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 111, 108, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 109, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	110, 111, 111, 111, 111, 109, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 163, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 111, 108, 173, 
	172, 174, 172, 175, 172, 144, 172, 176, 
	172, 172, 172, 172, 172, 172, 172, 177, 
	172, 178, 172, 179, 172, 144, 172, 180, 
	172, 144, 172, 181, 172, 175, 172, 183, 
	182, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 186, 184, 186, 186, 186, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 186, 184, 184, 184, 184, 184, 184, 
	184, 187, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 184, 188, 184, 184, 
	185, 184, 185, 185, 185, 189, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 184, 184, 184, 184, 
	184, 185, 190, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 192, 184, 192, 
	192, 192, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 192, 184, 184, 184, 
	184, 184, 184, 184, 193, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 184, 
	194, 184, 184, 191, 184, 191, 191, 191, 
	195, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 184, 
	184, 184, 184, 184, 191, 197, 196, 197, 
	197, 197, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 197, 196, 196, 196, 
	196, 196, 196, 196, 198, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	199, 196, 200, 196, 201, 196, 201, 201, 
	201, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 201, 196, 196, 196, 196, 
	196, 196, 196, 202, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 203, 
	196, 204, 205, 207, 206, 208, 206, 209, 
	206, 210, 206, 211, 206, 212, 213, 213, 
	213, 212, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 212, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	213, 213, 213, 213, 213, 213, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	213, 215, 204, 216, 217, 216, 216, 216, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 216, 204, 204, 218, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 220, 204, 
	221, 222, 221, 221, 221, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 221, 
	204, 204, 223, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 225, 204, 227, 228, 227, 
	227, 227, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 227, 226, 226, 229, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 230, 230, 230, 230, 
	230, 230, 230, 230, 230, 230, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	231, 226, 233, 234, 233, 233, 233, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 233, 232, 232, 235, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 237, 232, 233, 
	238, 233, 233, 233, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 233, 232, 
	232, 235, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 237, 232, 217, 204, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 241, 
	241, 239, 241, 239, 241, 241, 239, 239, 
	241, 241, 241, 242, 241, 241, 243, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	241, 241, 241, 241, 241, 241, 241, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 239, 241, 239, 239, 240, 241, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 239, 239, 239, 241, 239, 240, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 239, 239, 239, 239, 239, 239, 239, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 239, 239, 239, 239, 241, 239, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 239, 239, 239, 239, 239, 241, 
	244, 241, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 241, 239, 244, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 246, 
	239, 239, 239, 239, 247, 239, 239, 239, 
	239, 239, 248, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 215, 239, 239, 239, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	239, 239, 239, 239, 245, 249, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	239, 239, 239, 248, 239, 245, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	252, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	251, 251, 251, 251, 251, 251, 251, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 251, 251, 251, 251, 250, 251, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 251, 251, 251, 251, 251, 250, 254, 
	253, 257, 256, 252, 251, 257, 258, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 246, 239, 239, 239, 239, 247, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 239, 239, 239, 239, 245, 249, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 239, 239, 239, 239, 239, 245, 
	260, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 257, 259, 
	257, 260, 261, 262, 262, 262, 261, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 261, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 263, 
	262, 261, 264, 264, 264, 261, 264, 264, 
	264, 264, 264, 265, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 261, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 266, 264, 
	261, 264, 264, 264, 261, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 261, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 267, 264, 261, 
	268, 268, 268, 261, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 261, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 269, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 270, 268, 261, 271, 271, 
	271, 261, 271, 271, 271, 271, 271, 272, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 261, 
	271, 261, 271, 271, 271, 261, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 261, 271, 261, 262, 262, 
	262, 261, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 261, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 273, 262, 261, 274, 274, 274, 
	261, 274, 274, 274, 274, 274, 275, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 261, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 276, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	277, 274, 274, 274, 274, 274, 274, 278, 
	274, 261, 274, 274, 274, 261, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 261, 274, 279, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 280, 261, 280, 
	261, 261, 281, 281, 281, 261, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 261, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	282, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 283, 281, 261, 
	264, 264, 264, 261, 264, 264, 264, 264, 
	264, 265, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 261, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 267, 264, 261, 284, 
	284, 284, 261, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	261, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	284, 284, 284, 284, 284, 284, 284, 285, 
	285, 285, 285, 285, 285, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 285, 
	285, 285, 285, 285, 285, 284, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 287, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	288, 204, 204, 289, 204, 287, 204, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 204, 204, 204, 204, 286, 204, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 204, 204, 204, 204, 204, 286, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	287, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 288, 239, 239, 289, 239, 287, 239, 
	286, 286, 286, 286, 286, 286, 290, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 239, 239, 239, 239, 286, 239, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 239, 239, 239, 239, 239, 286, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 287, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 288, 239, 239, 289, 239, 287, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 291, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 239, 239, 239, 239, 286, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 239, 239, 239, 239, 239, 
	286, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 287, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 288, 239, 239, 289, 239, 
	287, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 292, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 239, 239, 239, 239, 
	286, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 239, 239, 239, 239, 
	239, 286, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 287, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 288, 239, 239, 289, 
	239, 287, 239, 286, 286, 286, 292, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 239, 239, 239, 
	239, 286, 239, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 239, 239, 239, 
	239, 239, 286, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 295, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 296, 293, 293, 
	293, 293, 295, 293, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 293, 293, 
	293, 293, 294, 293, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 293, 293, 
	293, 293, 293, 294, 296, 293, 293, 297, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 298, 298, 298, 298, 298, 298, 
	298, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 298, 298, 298, 298, 299, 
	298, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 298, 298, 298, 298, 298, 
	299, 301, 300, 301, 300, 300, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	300, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 300, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 300, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 304, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 304, 308, 307, 309, 
	307, 310, 307, 311, 307, 313, 312, 314, 
	312, 315, 312, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 298, 298, 298, 
	298, 298, 298, 298, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 298, 298, 
	298, 298, 316, 298, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 298, 298, 
	298, 298, 298, 316, 317, 304, 318, 319, 
	318, 318, 318, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 318, 304, 304, 
	320, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 321, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 322, 304, 323, 324, 323, 323, 323, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 323, 304, 304, 325, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 326, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 327, 304, 
	329, 330, 329, 329, 329, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 329, 
	328, 328, 331, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 332, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 333, 328, 335, 336, 335, 
	335, 335, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 335, 334, 334, 337, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	338, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	339, 334, 335, 336, 335, 335, 335, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 335, 334, 334, 337, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 340, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 339, 334, 335, 
	341, 335, 335, 335, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 335, 334, 
	334, 337, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 338, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 339, 334, 342, 304, 319, 304, 
	344, 345, 344, 344, 344, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 344, 
	343, 343, 343, 343, 343, 346, 343, 343, 
	343, 343, 343, 343, 343, 347, 343, 349, 
	345, 349, 349, 349, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 349, 348, 
	351, 350, 354, 353, 355, 348, 356, 352, 
	357, 343, 359, 358, 358, 358, 359, 358, 
	358, 358, 358, 360, 361, 360, 360, 360, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 359, 358, 358, 358, 
	358, 358, 360, 358, 358, 362, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 363, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 364, 358, 
	358, 365, 358, 360, 366, 360, 360, 360, 
	366, 366, 366, 366, 366, 366, 366, 366, 
	366, 366, 366, 366, 366, 366, 366, 366, 
	366, 366, 360, 366, 367, 368, 369, 370, 
	371, 373, 372, 375, 376, 375, 375, 375, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 375, 374, 361, 372, 377, 372, 
	379, 378, 378, 378, 379, 378, 378, 378, 
	378, 380, 381, 380, 380, 380, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 379, 378, 378, 378, 378, 378, 
	380, 378, 378, 382, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 383, 378, 380, 384, 
	380, 380, 380, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 380, 384, 386, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 387, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 388, 385, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 389, 389, 389, 389, 389, 389, 
	389, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 389, 389, 389, 389, 13, 
	389, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 389, 389, 389, 389, 389, 
	13, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 389, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 390, 390, 
	390, 390, 390, 390, 390, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 390, 
	390, 390, 390, 17, 390, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 390, 
	390, 390, 390, 390, 17, 393, 392, 392, 
	392, 393, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 393, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 394, 394, 394, 
	394, 394, 394, 394, 394, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	395, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 396, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	397, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 398, 392, 392, 399, 392, 400, 
	401, 403, 403, 403, 403, 403, 403, 403, 
	403, 402, 404, 404, 404, 404, 404, 404, 
	404, 404, 402, 402, 405, 405, 39, 39, 
	39, 405, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 405, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 40, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 406, 39, 407, 408, 409, 409, 39, 
	39, 39, 409, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	409, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 40, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 410, 39, 38, 409, 411, 412, 
	413, 413, 26, 26, 26, 413, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 413, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	27, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 414, 26, 409, 
	20, 20, 20, 409, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 409, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 415, 20, 405, 26, 
	26, 26, 405, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	405, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 27, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 28, 26, 405, 416, 416, 416, 
	405, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 405, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	417, 416, 418, 419, 419, 416, 416, 416, 
	419, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 419, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	420, 416, 419, 20, 20, 20, 419, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 419, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 415, 
	20, 421, 419, 419, 26, 26, 26, 419, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 419, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 27, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 28, 
	26, 423, 423, 423, 423, 423, 423, 423, 
	423, 423, 423, 422, 422, 422, 422, 422, 
	422, 422, 423, 423, 423, 423, 423, 423, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 423, 423, 423, 423, 423, 423, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 424, 422, 425, 425, 
	425, 425, 425, 425, 425, 425, 425, 425, 
	422, 422, 422, 422, 422, 422, 422, 425, 
	425, 425, 425, 425, 425, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 425, 
	425, 425, 425, 425, 425, 422, 426, 426, 
	426, 426, 426, 426, 426, 426, 426, 426, 
	422, 422, 422, 422, 422, 422, 422, 426, 
	426, 426, 426, 426, 426, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 426, 
	426, 426, 426, 426, 426, 422, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	422, 422, 422, 422, 422, 422, 422, 427, 
	427, 427, 427, 427, 427, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 427, 
	427, 427, 427, 427, 427, 422, 428, 431, 
	430, 430, 430, 431, 430, 430, 430, 430, 
	432, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 431, 430, 430, 430, 430, 430, 432, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 430, 430, 430, 430, 430, 430, 430, 
	433, 433, 433, 433, 433, 433, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	433, 433, 433, 433, 433, 433, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 434, 430, 431, 430, 
	430, 430, 431, 430, 430, 430, 430, 429, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	431, 430, 430, 430, 430, 430, 429, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	430, 430, 430, 430, 430, 430, 430, 435, 
	435, 435, 435, 435, 435, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 435, 
	435, 435, 435, 435, 435, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 436, 430, 429, 431, 435, 
	435, 435, 431, 435, 435, 435, 435, 429, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	431, 435, 435, 435, 435, 435, 429, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 429, 435, 437, 431, 438, 
	438, 438, 431, 438, 438, 438, 438, 432, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	431, 438, 438, 438, 438, 438, 432, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	438, 438, 438, 438, 438, 438, 438, 433, 
	433, 433, 433, 433, 433, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 433, 
	433, 433, 433, 433, 433, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 429, 438, 431, 438, 438, 
	438, 431, 438, 438, 438, 438, 429, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 431, 
	438, 438, 438, 438, 438, 429, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 438, 
	438, 438, 438, 438, 438, 438, 435, 435, 
	435, 435, 435, 435, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 435, 435, 
	435, 435, 435, 435, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 431, 438, 431, 438, 438, 438, 
	431, 438, 438, 438, 438, 439, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 431, 438, 
	438, 438, 438, 438, 439, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 438, 438, 
	438, 438, 438, 438, 438, 440, 440, 440, 
	440, 440, 440, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 440, 440, 440, 
	440, 440, 440, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 441, 438, 431, 438, 438, 438, 431, 
	438, 438, 438, 438, 439, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 431, 438, 438, 
	438, 438, 438, 439, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 438, 438, 438, 
	438, 438, 438, 438, 433, 433, 433, 433, 
	433, 433, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 433, 433, 433, 433, 
	433, 433, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	441, 438, 442, 431, 438, 438, 438, 431, 
	438, 438, 438, 438, 439, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 431, 438, 438, 
	438, 438, 438, 439, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 438, 438, 438, 
	438, 438, 438, 438, 443, 443, 443, 443, 
	443, 443, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 443, 443, 443, 443, 
	443, 443, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	441, 438, 431, 438, 438, 438, 431, 438, 
	438, 438, 438, 439, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 431, 438, 438, 438, 
	438, 438, 439, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 438, 438, 438, 438, 
	438, 438, 438, 444, 444, 444, 444, 444, 
	444, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 444, 444, 444, 444, 444, 
	444, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 441, 
	438, 431, 438, 438, 438, 431, 438, 438, 
	438, 438, 439, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 431, 438, 438, 438, 438, 
	438, 439, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 438, 438, 438, 438, 438, 
	438, 438, 445, 445, 445, 445, 445, 445, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 445, 445, 445, 445, 445, 445, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 441, 438, 
	431, 438, 438, 438, 431, 438, 438, 438, 
	438, 439, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 431, 438, 438, 438, 438, 438, 
	439, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 438, 438, 438, 438, 438, 438, 
	438, 446, 446, 446, 446, 446, 446, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 446, 446, 446, 446, 446, 446, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 441, 438, 431, 
	438, 438, 438, 431, 438, 438, 438, 438, 
	439, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 431, 438, 438, 438, 438, 438, 439, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 438, 438, 438, 438, 438, 438, 438, 
	447, 447, 447, 447, 447, 447, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	447, 447, 447, 447, 447, 447, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 441, 438, 431, 438, 
	438, 438, 431, 438, 438, 438, 438, 429, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	431, 438, 438, 438, 438, 438, 429, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	438, 438, 438, 438, 438, 438, 438, 447, 
	447, 447, 447, 447, 447, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 447, 
	447, 447, 447, 447, 447, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 429, 438, 448, 449, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 450, 450, 450, 450, 450, 450, 450, 
	451, 451, 451, 451, 451, 451, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	451, 451, 451, 451, 451, 451, 450, 450, 
	453, 452, 452, 452, 453, 452, 452, 452, 
	452, 452, 454, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 453, 452, 452, 452, 452, 452, 
	452, 452, 452, 455, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 456, 452, 458, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 459, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 460, 457, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 461, 461, 461, 461, 461, 461, 461, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 461, 461, 461, 461, 45, 461, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 461, 461, 461, 461, 461, 45, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 461, 462, 462, 462, 462, 462, 
	462, 462, 462, 462, 462, 462, 462, 462, 
	462, 462, 462, 462, 462, 462, 462, 462, 
	462, 462, 462, 462, 462, 462, 462, 462, 
	462, 462, 462, 462, 462, 462, 462, 462, 
	462, 462, 462, 462, 462, 462, 462, 462, 
	462, 462, 462, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 462, 462, 462, 
	462, 462, 462, 462, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 462, 462, 
	462, 462, 49, 462, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 462, 462, 
	462, 462, 462, 49, 465, 464, 464, 464, 
	465, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 465, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 466, 466, 466, 466, 
	466, 466, 466, 466, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 467, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 468, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 469, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 470, 464, 464, 471, 464, 472, 473, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	474, 476, 476, 476, 476, 476, 476, 476, 
	476, 474, 474, 477, 477, 71, 71, 71, 
	477, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 477, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 72, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	478, 71, 479, 480, 481, 481, 71, 71, 
	71, 481, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 481, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 72, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 482, 71, 70, 481, 483, 484, 485, 
	485, 58, 58, 58, 485, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 485, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 59, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 486, 58, 481, 52, 
	52, 52, 481, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	481, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 487, 52, 477, 58, 58, 
	58, 477, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 477, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 59, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 60, 58, 477, 488, 488, 488, 477, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 477, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 489, 
	488, 490, 491, 491, 488, 488, 488, 491, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 491, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 492, 
	488, 491, 52, 52, 52, 491, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 491, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 487, 52, 
	493, 491, 491, 58, 58, 58, 491, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 491, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 59, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 60, 58, 
	495, 495, 495, 495, 495, 495, 495, 495, 
	495, 495, 494, 494, 494, 494, 494, 494, 
	494, 495, 495, 495, 495, 495, 495, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 495, 495, 495, 495, 495, 495, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 496, 494, 497, 497, 497, 
	497, 497, 497, 497, 497, 497, 497, 494, 
	494, 494, 494, 494, 494, 494, 497, 497, 
	497, 497, 497, 497, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 497, 497, 
	497, 497, 497, 497, 494, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 494, 
	494, 494, 494, 494, 494, 494, 498, 498, 
	498, 498, 498, 498, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 498, 498, 
	498, 498, 498, 498, 494, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 494, 
	494, 494, 494, 494, 494, 494, 499, 499, 
	499, 499, 499, 499, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 499, 499, 
	499, 499, 499, 499, 494, 500, 503, 502, 
	502, 502, 503, 502, 502, 502, 502, 504, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	503, 502, 502, 502, 502, 502, 504, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	502, 502, 502, 502, 502, 502, 502, 505, 
	505, 505, 505, 505, 505, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 505, 
	505, 505, 505, 505, 505, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 506, 502, 503, 502, 502, 
	502, 503, 502, 502, 502, 502, 501, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 503, 
	502, 502, 502, 502, 502, 501, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 502, 
	502, 502, 502, 502, 502, 502, 507, 507, 
	507, 507, 507, 507, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 507, 507, 
	507, 507, 507, 507, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 508, 502, 501, 503, 507, 507, 
	507, 503, 507, 507, 507, 507, 501, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 503, 
	507, 507, 507, 507, 507, 501, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 501, 507, 509, 503, 510, 510, 
	510, 503, 510, 510, 510, 510, 504, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 503, 
	510, 510, 510, 510, 510, 504, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 510, 
	510, 510, 510, 510, 510, 510, 505, 505, 
	505, 505, 505, 505, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 505, 505, 
	505, 505, 505, 505, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 501, 510, 503, 510, 510, 510, 
	503, 510, 510, 510, 510, 501, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 503, 510, 
	510, 510, 510, 510, 501, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 510, 510, 
	510, 510, 510, 510, 510, 507, 507, 507, 
	507, 507, 507, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 507, 507, 507, 
	507, 507, 507, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 503, 510, 503, 510, 510, 510, 503, 
	510, 510, 510, 510, 511, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 503, 510, 510, 
	510, 510, 510, 511, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 510, 510, 510, 
	510, 510, 510, 510, 512, 512, 512, 512, 
	512, 512, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 512, 512, 512, 512, 
	512, 512, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	513, 510, 503, 510, 510, 510, 503, 510, 
	510, 510, 510, 511, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 503, 510, 510, 510, 
	510, 510, 511, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 510, 510, 510, 510, 
	510, 510, 510, 505, 505, 505, 505, 505, 
	505, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 505, 505, 505, 505, 505, 
	505, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 513, 
	510, 514, 503, 510, 510, 510, 503, 510, 
	510, 510, 510, 511, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 503, 510, 510, 510, 
	510, 510, 511, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 515, 515, 515, 515, 515, 515, 
	515, 515, 515, 515, 510, 510, 510, 510, 
	510, 510, 510, 515, 515, 515, 515, 515, 
	515, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 515, 515, 515, 515, 515, 
	515, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 513, 
	510, 503, 510, 510, 510, 503, 510, 510, 
	510, 510, 511, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 503, 510, 510, 510, 510, 
	510, 511, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 510, 510, 510, 510, 510, 
	510, 510, 516, 516, 516, 516, 516, 516, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 516, 516, 516, 516, 516, 516, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 513, 510, 
	503, 510, 510, 510, 503, 510, 510, 510, 
	510, 511, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 503, 510, 510, 510, 510, 510, 
	511, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 510, 510, 510, 510, 510, 510, 
	510, 517, 517, 517, 517, 517, 517, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 517, 517, 517, 517, 517, 517, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 513, 510, 503, 
	510, 510, 510, 503, 510, 510, 510, 510, 
	511, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 503, 510, 510, 510, 510, 510, 511, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 510, 510, 510, 510, 510, 510, 510, 
	518, 518, 518, 518, 518, 518, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	518, 518, 518, 518, 518, 518, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 513, 510, 503, 510, 
	510, 510, 503, 510, 510, 510, 510, 511, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	503, 510, 510, 510, 510, 510, 511, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 519, 519, 
	519, 519, 519, 519, 519, 519, 519, 519, 
	510, 510, 510, 510, 510, 510, 510, 519, 
	519, 519, 519, 519, 519, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 519, 
	519, 519, 519, 519, 519, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 513, 510, 503, 510, 510, 
	510, 503, 510, 510, 510, 510, 501, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 503, 
	510, 510, 510, 510, 510, 501, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 519, 519, 519, 
	519, 519, 519, 519, 519, 519, 519, 510, 
	510, 510, 510, 510, 510, 510, 519, 519, 
	519, 519, 519, 519, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 519, 519, 
	519, 519, 519, 519, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 501, 510, 520, 521, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	522, 522, 522, 522, 522, 522, 522, 523, 
	523, 523, 523, 523, 523, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 523, 
	523, 523, 523, 523, 523, 522, 522, 525, 
	524, 524, 524, 525, 524, 524, 524, 524, 
	526, 527, 526, 526, 526, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 525, 524, 524, 524, 524, 524, 526, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 528, 524, 526, 529, 526, 
	526, 526, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 526, 529, 530, 531, 
	531, 531, 530, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	530, 531, 533, 532, 532, 532, 533, 532, 
	532, 532, 532, 532, 534, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 533, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 535, 532, 
	536, 537, 537, 537, 536, 537, 537, 537, 
	537, 537, 538, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 536, 537, 540, 539, 539, 539, 
	540, 539, 539, 539, 539, 539, 541, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 542, 
	539, 544, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 545, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	546, 543, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 547, 547, 547, 547, 
	547, 547, 547, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 547, 547, 547, 
	547, 77, 547, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 547, 547, 547, 
	547, 547, 77, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 547, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	548, 548, 548, 548, 548, 548, 548, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 548, 548, 548, 548, 81, 548, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 548, 548, 548, 548, 548, 81, 550, 
	549, 549, 549, 550, 549, 549, 549, 549, 
	549, 551, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 550, 549, 553, 552, 552, 552, 553, 
	552, 552, 552, 552, 554, 555, 554, 554, 
	554, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 553, 552, 552, 
	552, 552, 552, 554, 552, 552, 556, 552, 
	554, 557, 554, 554, 554, 557, 557, 557, 
	557, 557, 557, 557, 557, 557, 557, 557, 
	557, 557, 557, 557, 557, 557, 557, 554, 
	557, 559, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 560, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	561, 558, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 562, 562, 562, 562, 
	562, 562, 562, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 562, 562, 562, 
	562, 84, 562, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 562, 562, 562, 
	562, 562, 84, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 562, 563, 563, 
	563, 563, 563, 563, 563, 563, 563, 563, 
	563, 563, 563, 563, 563, 563, 563, 563, 
	563, 563, 563, 563, 563, 563, 563, 563, 
	563, 563, 563, 563, 563, 563, 563, 563, 
	563, 563, 563, 563, 563, 563, 563, 563, 
	563, 563, 563, 563, 563, 563, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	563, 563, 563, 563, 563, 563, 563, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 563, 563, 563, 563, 88, 563, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 563, 563, 563, 563, 563, 88, 565, 
	564, 564, 564, 565, 564, 564, 564, 564, 
	566, 567, 566, 566, 566, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 565, 564, 564, 564, 564, 564, 566, 
	564, 566, 568, 566, 566, 566, 568, 568, 
	568, 568, 568, 568, 568, 568, 568, 568, 
	568, 568, 568, 568, 568, 568, 568, 568, 
	566, 568, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 569, 569, 569, 569, 
	569, 569, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 569, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 571, 
	571, 571, 571, 571, 571, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 571, 
	572, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 573, 92, 574, 574, 
	574, 574, 574, 574, 574, 574, 574, 574, 
	574, 574, 574, 574, 574, 574, 574, 574, 
	574, 574, 574, 574, 574, 574, 574, 574, 
	574, 574, 574, 574, 574, 574, 574, 574, 
	574, 574, 574, 574, 574, 574, 574, 574, 
	574, 574, 574, 574, 574, 574, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	574, 574, 574, 574, 574, 574, 574, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 574, 574, 574, 574, 90, 574, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 574, 574, 574, 574, 574, 90, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 574, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 575, 575, 575, 575, 
	575, 575, 575, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 575, 575, 575, 
	575, 95, 575, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 575, 575, 575, 
	575, 575, 95, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 576, 576, 576, 
	576, 576, 576, 576, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 576, 576, 
	576, 576, 97, 576, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 576, 576, 
	576, 576, 576, 97, 578, 579, 579, 579, 
	578, 579, 579, 579, 579, 580, 581, 580, 
	580, 580, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 578, 579, 
	579, 579, 579, 579, 580, 582, 579, 583, 
	584, 585, 586, 579, 579, 579, 587, 588, 
	579, 588, 579, 589, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 590, 579, 
	591, 592, 593, 579, 579, 594, 595, 594, 
	594, 596, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 597, 
	598, 579, 589, 599, 589, 600, 601, 602, 
	603, 604, 605, 577, 577, 606, 577, 577, 
	577, 607, 608, 609, 577, 577, 610, 611, 
	612, 613, 577, 614, 577, 615, 577, 579, 
	616, 579, 588, 579, 577, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 618, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 617, 
	617, 617, 618, 617, 618, 617, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	617, 617, 617, 617, 577, 617, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	617, 617, 617, 617, 617, 577, 580, 619, 
	580, 580, 580, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 580, 619, 620, 
	589, 621, 621, 589, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 589, 621, 622, 623, 624, 625, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	99, 99, 626, 99, 626, 99, 99, 626, 
	626, 99, 99, 99, 628, 99, 99, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 99, 99, 99, 99, 99, 99, 99, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 626, 99, 626, 626, 627, 99, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 626, 626, 626, 99, 626, 627, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	630, 630, 630, 630, 630, 630, 630, 630, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 630, 630, 630, 630, 630, 630, 
	630, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 630, 630, 630, 630, 627, 
	630, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 627, 627, 627, 627, 627, 
	627, 627, 627, 630, 630, 630, 630, 630, 
	627, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 630, 631, 621, 589, 621, 
	589, 621, 589, 621, 633, 632, 589, 634, 
	621, 589, 621, 635, 589, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 626, 626, 626, 626, 
	626, 626, 626, 626, 589, 626, 589, 621, 
	589, 589, 621, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 617, 618, 617, 617, 617, 
	617, 617, 617, 617, 617, 617, 617, 617, 
	617, 617, 617, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 617, 617, 617, 
	618, 617, 618, 617, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 617, 617, 
	617, 617, 594, 617, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 617, 617, 
	617, 617, 617, 594, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 618, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 636, 636, 
	636, 618, 636, 618, 636, 594, 594, 594, 
	594, 637, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 636, 
	636, 636, 636, 594, 636, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 636, 
	636, 636, 636, 636, 594, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 618, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 636, 
	636, 636, 618, 636, 618, 636, 594, 594, 
	594, 594, 594, 594, 638, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	636, 636, 636, 636, 594, 636, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	636, 636, 636, 636, 636, 594, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 618, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	636, 636, 636, 618, 636, 618, 636, 594, 
	594, 594, 594, 594, 594, 594, 594, 639, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 636, 636, 636, 636, 594, 636, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 636, 636, 636, 636, 636, 594, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	618, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 636, 636, 636, 618, 636, 618, 636, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 640, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 636, 636, 636, 636, 594, 636, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 636, 636, 636, 636, 636, 594, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 618, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 636, 636, 636, 618, 636, 618, 
	636, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 641, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 636, 636, 636, 636, 594, 
	636, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 636, 636, 636, 636, 636, 
	594, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 636, 618, 636, 636, 636, 636, 636, 
	636, 636, 636, 636, 636, 636, 636, 636, 
	636, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 636, 636, 636, 618, 636, 
	618, 636, 594, 594, 594, 640, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 636, 636, 636, 636, 
	594, 636, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 636, 636, 636, 636, 
	636, 594, 635, 626, 581, 626, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 643, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 644, 645, 577, 577, 
	577, 577, 577, 646, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 647, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 648, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 649, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 650, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 651, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 652, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 653, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 654, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 655, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 656, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 657, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	653, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 658, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 657, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 659, 577, 660, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	661, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 662, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 655, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 655, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	663, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 664, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 665, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 666, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 655, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 667, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 668, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 655, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 669, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 670, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 671, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 655, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 672, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 662, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 673, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 655, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 674, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 675, 675, 675, 675, 675, 675, 675, 
	675, 675, 675, 675, 675, 675, 675, 675, 
	675, 675, 675, 675, 675, 675, 675, 675, 
	675, 675, 675, 675, 675, 675, 675, 675, 
	675, 675, 618, 675, 675, 675, 675, 675, 
	675, 675, 675, 675, 675, 675, 675, 675, 
	675, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 675, 675, 675, 618, 675, 
	618, 675, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 675, 675, 675, 675, 
	577, 675, 577, 577, 577, 577, 577, 577, 
	577, 577, 676, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 675, 675, 675, 675, 
	675, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	677, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	678, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	679, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 680, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 681, 577, 682, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 683, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 655, 577, 577, 
	577, 684, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 655, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 655, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 685, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	686, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 671, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 687, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 609, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 669, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 655, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 655, 577, 
	577, 577, 577, 577, 577, 577, 655, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	688, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 689, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	690, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	671, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 691, 577, 577, 577, 692, 577, 
	577, 577, 577, 577, 693, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 693, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 655, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 655, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 694, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 695, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 696, 697, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 655, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 698, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 671, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	699, 577, 577, 700, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	655, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 666, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 701, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 702, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 684, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 703, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 609, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 577, 577, 577, 704, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 698, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 666, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 705, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 706, 577, 577, 577, 
	577, 577, 577, 577, 707, 577, 577, 577, 
	577, 577, 577, 577, 708, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 618, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 618, 642, 
	618, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	577, 642, 577, 577, 577, 577, 684, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 642, 
	642, 577, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 618, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 642, 642, 642, 618, 
	642, 618, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 577, 642, 577, 577, 577, 577, 672, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	642, 642, 577, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 618, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 642, 642, 642, 
	618, 642, 618, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 577, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 692, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 642, 642, 577, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 618, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 642, 642, 
	642, 618, 642, 618, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 577, 642, 577, 577, 577, 
	577, 577, 577, 577, 709, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 642, 642, 577, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 618, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 642, 
	642, 642, 618, 642, 618, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 577, 642, 577, 577, 
	577, 577, 666, 577, 577, 577, 690, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 642, 642, 577, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 618, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	642, 642, 642, 618, 642, 618, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 577, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 710, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 642, 642, 577, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	618, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 642, 642, 642, 618, 642, 618, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 577, 642, 
	577, 577, 577, 577, 711, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 642, 642, 577, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	642, 618, 642, 642, 642, 642, 642, 642, 
	642, 642, 642, 642, 642, 642, 642, 642, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 642, 642, 642, 618, 642, 618, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 577, 
	642, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 660, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 642, 642, 642, 642, 642, 
	577, 589, 621, 713, 714, 714, 714, 713, 
	714, 714, 714, 714, 715, 714, 715, 715, 
	715, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 713, 714, 714, 
	714, 714, 714, 715, 714, 714, 716, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 714, 717, 
	714, 714, 712, 714, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 712, 712, 
	712, 712, 712, 712, 712, 712, 714, 714, 
	714, 714, 714, 712, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 104, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 105, 718, 
	718, 718, 718, 104, 718, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 718, 
	718, 718, 718, 103, 718, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 718, 
	718, 718, 718, 718, 103, 715, 719, 715, 
	715, 715, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 715, 719, 720, 721, 
	722, 723, 724, 718, 725, 727, 728, 728, 
	728, 727, 728, 728, 728, 728, 729, 730, 
	729, 729, 729, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 727, 
	728, 728, 728, 728, 728, 729, 731, 728, 
	732, 728, 733, 734, 728, 728, 728, 735, 
	736, 728, 736, 728, 733, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 737, 738, 739, 728, 728, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	741, 742, 728, 733, 726, 733, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	728, 743, 728, 736, 728, 726, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 744, 745, 
	744, 744, 744, 744, 744, 744, 744, 744, 
	744, 744, 744, 744, 744, 744, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	744, 744, 744, 744, 744, 745, 744, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 744, 744, 744, 744, 726, 744, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 744, 744, 744, 744, 744, 726, 747, 
	746, 748, 729, 749, 729, 729, 729, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 729, 749, 750, 733, 751, 751, 733, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 733, 751, 752, 
	753, 754, 755, 733, 751, 733, 751, 733, 
	751, 733, 756, 751, 733, 751, 758, 733, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 733, 
	757, 733, 751, 733, 733, 751, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 745, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	759, 759, 759, 759, 759, 745, 759, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 759, 759, 759, 759, 740, 759, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 740, 740, 740, 740, 740, 740, 740, 
	740, 759, 759, 759, 759, 759, 740, 758, 
	757, 730, 757, 733, 751, 761, 760, 760, 
	760, 761, 760, 760, 760, 760, 762, 763, 
	762, 762, 762, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 761, 
	760, 760, 760, 760, 760, 762, 760, 760, 
	764, 760, 113, 765, 760, 766, 760, 767, 
	113, 144, 768, 146, 113, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 769, 
	760, 770, 144, 771, 772, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	144, 773, 144, 113, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 774, 760, 
	760, 760, 760, 760, 760, 760, 760, 775, 
	760, 760, 776, 760, 777, 760, 760, 760, 
	157, 158, 760, 113, 760, 778, 778, 778, 
	778, 778, 778, 778, 778, 778, 762, 778, 
	762, 762, 762, 778, 778, 778, 778, 778, 
	778, 778, 778, 778, 778, 778, 778, 778, 
	778, 778, 778, 778, 778, 762, 778, 778, 
	778, 778, 139, 140, 778, 141, 778, 142, 
	143, 144, 145, 146, 139, 778, 778, 778, 
	778, 778, 778, 778, 778, 778, 778, 147, 
	778, 148, 144, 149, 150, 778, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	151, 152, 144, 113, 108, 778, 108, 108, 
	108, 108, 108, 108, 108, 108, 153, 108, 
	108, 108, 108, 108, 108, 108, 108, 154, 
	108, 108, 155, 108, 156, 108, 108, 108, 
	157, 158, 778, 113, 778, 108, 779, 780, 
	780, 780, 779, 780, 780, 780, 780, 144, 
	781, 144, 144, 144, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	779, 780, 780, 780, 780, 780, 144, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 144, 780, 144, 781, 144, 
	144, 144, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 144, 107, 107, 107, 
	107, 107, 113, 107, 107, 107, 107, 107, 
	107, 107, 144, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 144, 107, 144, 781, 144, 144, 144, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 144, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 144, 
	107, 782, 144, 781, 144, 144, 144, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 144, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 784, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 144, 783, 
	144, 781, 144, 144, 144, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 144, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 144, 144, 107, 785, 
	779, 144, 779, 787, 786, 789, 790, 789, 
	789, 789, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 789, 788, 791, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	109, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 110, 779, 779, 779, 779, 109, 779, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 779, 779, 779, 779, 108, 779, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 779, 779, 779, 779, 779, 108, 
	792, 144, 781, 144, 144, 144, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	144, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 144, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 113, 779, 793, 794, 
	795, 796, 797, 798, 144, 781, 144, 144, 
	144, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 144, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 113, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	144, 779, 144, 786, 113, 799, 113, 799, 
	800, 801, 800, 800, 800, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 800, 
	788, 802, 799, 803, 803, 803, 803, 803, 
	803, 803, 803, 803, 116, 803, 116, 116, 
	116, 803, 803, 803, 803, 803, 803, 803, 
	803, 803, 803, 803, 803, 803, 803, 803, 
	803, 803, 803, 116, 803, 803, 803, 803, 
	117, 118, 803, 119, 803, 120, 121, 122, 
	123, 124, 117, 803, 803, 803, 803, 803, 
	803, 803, 803, 803, 803, 125, 803, 126, 
	122, 127, 128, 803, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 129, 130, 
	122, 131, 115, 803, 115, 115, 115, 115, 
	115, 115, 115, 115, 132, 115, 115, 115, 
	115, 115, 115, 115, 115, 133, 115, 115, 
	134, 115, 135, 115, 115, 115, 136, 137, 
	803, 131, 803, 115, 144, 799, 804, 799, 
	805, 799, 806, 799, 807, 183, 183, 183, 
	807, 183, 183, 183, 183, 808, 183, 808, 
	808, 808, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 807, 183, 
	183, 183, 183, 183, 808, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 183, 
	809, 183, 183, 185, 183, 185, 185, 185, 
	189, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 183, 
	183, 183, 183, 183, 185, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 810, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 183, 
	182, 182, 182, 182, 810, 182, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	182, 182, 182, 182, 185, 182, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	182, 182, 182, 182, 182, 185, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 186, 
	811, 186, 186, 186, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 186, 811, 
	811, 811, 811, 811, 811, 811, 187, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 811, 188, 811, 811, 185, 811, 185, 
	185, 185, 189, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 811, 811, 811, 811, 811, 185, 812, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 810, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 183, 811, 811, 811, 811, 810, 
	811, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 811, 811, 811, 811, 185, 
	811, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 813, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 811, 811, 811, 811, 811, 
	185, 190, 811, 815, 814, 814, 814, 815, 
	814, 814, 814, 814, 816, 814, 816, 816, 
	816, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 815, 814, 814, 
	814, 814, 814, 816, 814, 814, 817, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 818, 
	814, 814, 814, 814, 814, 814, 814, 819, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 820, 814, 
	816, 821, 816, 816, 816, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 816, 
	821, 822, 823, 824, 825, 827, 826, 828, 
	829, 826, 830, 832, 833, 833, 833, 832, 
	833, 833, 833, 833, 834, 835, 834, 834, 
	834, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 832, 833, 833, 
	833, 833, 833, 834, 833, 833, 836, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 833, 837, 
	833, 833, 831, 833, 831, 831, 831, 831, 
	831, 831, 831, 831, 838, 831, 831, 831, 
	831, 831, 831, 831, 831, 839, 831, 831, 
	840, 831, 841, 831, 831, 831, 833, 833, 
	833, 833, 833, 831, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 842, 842, 
	842, 842, 842, 842, 842, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 842, 
	842, 842, 842, 831, 842, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 842, 
	842, 842, 842, 842, 831, 834, 843, 834, 
	834, 834, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 834, 843, 844, 845, 
	846, 847, 848, 850, 849, 851, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 852, 852, 852, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 831, 852, 831, 
	831, 831, 831, 831, 853, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 852, 831, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 852, 852, 852, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 831, 852, 
	831, 831, 831, 831, 854, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 852, 831, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 852, 852, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 831, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 855, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 852, 
	831, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 852, 
	852, 852, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	831, 852, 831, 831, 856, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	852, 831, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	852, 852, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 831, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 857, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 852, 831, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 852, 852, 852, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 831, 852, 831, 831, 831, 831, 
	853, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 852, 831, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 852, 852, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 831, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 858, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 852, 831, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 852, 852, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 831, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 859, 831, 831, 831, 831, 831, 831, 
	831, 860, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 852, 831, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 852, 852, 852, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 831, 852, 831, 
	831, 831, 831, 861, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 852, 831, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 852, 852, 852, 852, 852, 852, 852, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 831, 852, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 862, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 852, 831, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 852, 852, 852, 852, 852, 852, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 831, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 853, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 852, 
	831, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 852, 852, 852, 852, 852, 
	852, 852, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	831, 852, 831, 831, 831, 831, 831, 831, 
	831, 831, 863, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	852, 831, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 852, 852, 852, 852, 
	852, 852, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 831, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 853, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 852, 831, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 852, 852, 852, 
	852, 852, 852, 852, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 831, 852, 831, 831, 831, 831, 
	831, 831, 831, 864, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 852, 831, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 852, 852, 
	852, 852, 852, 852, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 831, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 865, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 852, 831, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 852, 
	852, 852, 852, 852, 852, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 831, 852, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 857, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	852, 852, 852, 852, 852, 831, 867, 215, 
	215, 215, 867, 215, 215, 215, 215, 868, 
	869, 868, 868, 868, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	867, 215, 215, 215, 215, 215, 868, 870, 
	215, 871, 215, 872, 873, 215, 874, 215, 
	875, 876, 215, 877, 878, 879, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	880, 215, 881, 882, 883, 884, 215, 885, 
	886, 885, 885, 887, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 888, 889, 215, 890, 891, 215, 892, 
	893, 894, 895, 896, 897, 866, 866, 898, 
	866, 866, 866, 899, 900, 901, 866, 866, 
	902, 903, 904, 905, 866, 906, 866, 907, 
	866, 908, 909, 215, 890, 215, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	914, 913, 913, 915, 913, 916, 918, 919, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 920, 
	917, 922, 921, 923, 924, 925, 868, 926, 
	868, 868, 868, 926, 926, 926, 926, 926, 
	926, 926, 926, 926, 926, 926, 926, 926, 
	926, 926, 926, 926, 926, 868, 926, 928, 
	927, 930, 931, 930, 930, 930, 929, 929, 
	929, 929, 929, 929, 929, 929, 929, 929, 
	929, 929, 929, 929, 929, 929, 929, 929, 
	930, 929, 215, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 215, 932, 933, 934, 935, 
	936, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 938, 938, 938, 938, 938, 
	938, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 939, 939, 939, 939, 939, 
	939, 939, 939, 938, 940, 213, 213, 213, 
	940, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 940, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 213, 
	213, 213, 213, 213, 213, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 213, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 215, 
	941, 943, 945, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 215, 944, 215, 
	204, 216, 217, 216, 216, 216, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	216, 941, 941, 218, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 941, 941, 941, 215, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 220, 941, 233, 234, 
	233, 233, 233, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 233, 232, 232, 
	235, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 237, 232, 216, 217, 216, 216, 216, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 216, 941, 941, 218, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 941, 941, 941, 215, 
	215, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 220, 941, 
	947, 932, 949, 948, 932, 950, 950, 950, 
	932, 950, 950, 950, 950, 950, 950, 950, 
	950, 950, 950, 950, 950, 950, 950, 950, 
	950, 950, 950, 950, 950, 950, 932, 950, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 952, 953, 932, 954, 241, 955, 953, 
	932, 932, 956, 957, 932, 957, 932, 241, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 958, 932, 959, 960, 961, 932, 
	962, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 963, 932, 932, 241, 951, 
	241, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 932, 964, 932, 965, 932, 
	951, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 967, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 966, 966, 966, 968, 966, 
	967, 966, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 966, 966, 966, 966, 
	951, 966, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 966, 966, 966, 966, 
	966, 951, 970, 969, 971, 973, 974, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 975, 972, 
	977, 978, 976, 979, 980, 981, 982, 241, 
	966, 966, 983, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	241, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 966, 966, 966, 966, 
	966, 966, 966, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 966, 966, 966, 
	966, 240, 966, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 966, 966, 966, 
	966, 966, 240, 243, 243, 243, 243, 243, 
	243, 243, 243, 243, 243, 966, 984, 966, 
	241, 966, 241, 966, 241, 985, 966, 241, 
	966, 241, 966, 241, 241, 966, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	986, 986, 986, 986, 986, 986, 989, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 986, 986, 986, 986, 987, 986, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 987, 987, 987, 987, 987, 987, 987, 
	987, 986, 986, 986, 986, 986, 987, 991, 
	991, 991, 991, 991, 991, 991, 991, 991, 
	991, 990, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 992, 992, 992, 992, 
	992, 992, 992, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 992, 992, 992, 
	992, 993, 992, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 993, 992, 992, 992, 
	992, 992, 993, 984, 966, 983, 966, 995, 
	996, 932, 997, 256, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 257, 246, 258, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 257, 247, 257, 260, 215, 932, 
	890, 215, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 215, 932, 215, 942, 932, 1001, 1000, 
	1000, 1000, 1001, 1000, 1000, 1000, 1000, 1002, 
	1003, 1002, 1002, 1002, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1001, 1000, 1000, 1000, 1000, 1000, 1002, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1000, 1005, 1000, 1000, 1004, 1000, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1000, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1006, 1006, 
	1006, 1006, 1007, 1006, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1006, 1006, 
	1006, 1006, 1006, 1007, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1008, 
	1008, 1008, 1008, 1009, 1008, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1008, 
	1008, 1008, 1008, 1008, 1009, 1012, 1011, 1011, 
	1011, 1012, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1012, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1014, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1015, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1016, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1017, 1011, 1011, 1018, 1011, 1019, 
	1020, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1021, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1021, 1021, 1024, 1024, 281, 281, 
	281, 1024, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 1024, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 282, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 1025, 281, 1026, 1027, 1028, 1028, 281, 
	281, 281, 1028, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	1028, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 282, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 1029, 281, 280, 1028, 1030, 1031, 
	1032, 1032, 268, 268, 268, 1032, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 1032, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	269, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 1033, 268, 1028, 
	262, 262, 262, 1028, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 1028, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 1034, 262, 1024, 268, 
	268, 268, 1024, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	1024, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 269, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 270, 268, 1024, 1035, 1035, 1035, 
	1024, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1024, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1036, 1035, 1037, 1038, 1038, 1035, 1035, 1035, 
	1038, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1038, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1039, 1035, 1038, 262, 262, 262, 1038, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 1038, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 1034, 
	262, 1040, 1038, 1038, 268, 268, 268, 1038, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 1038, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 269, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 270, 
	268, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1042, 1042, 1042, 1042, 1042, 1042, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1042, 1042, 1042, 1042, 1042, 1042, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1043, 1041, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1044, 
	1044, 1044, 1044, 1044, 1044, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1044, 
	1044, 1044, 1044, 1044, 1044, 1041, 1045, 1045, 
	1045, 1045, 1045, 1045, 1045, 1045, 1045, 1045, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1045, 
	1045, 1045, 1045, 1045, 1045, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1045, 
	1045, 1045, 1045, 1045, 1045, 1041, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1046, 
	1046, 1046, 1046, 1046, 1046, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1046, 
	1046, 1046, 1046, 1046, 1046, 1041, 1047, 1050, 
	1049, 1049, 1049, 1050, 1049, 1049, 1049, 1049, 
	1051, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1050, 1049, 1049, 1049, 1049, 1049, 1051, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1052, 
	1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 
	1052, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1052, 1052, 1052, 1052, 1052, 1052, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1052, 1052, 1052, 1052, 1052, 1052, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1053, 1049, 1050, 1049, 
	1049, 1049, 1050, 1049, 1049, 1049, 1049, 1048, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1050, 1049, 1049, 1049, 1049, 1049, 1048, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1054, 
	1054, 1054, 1054, 1054, 1054, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1054, 
	1054, 1054, 1054, 1054, 1054, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1055, 1049, 1048, 1050, 1054, 
	1054, 1054, 1050, 1054, 1054, 1054, 1054, 1048, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1050, 1054, 1054, 1054, 1054, 1054, 1048, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1048, 1054, 1056, 1050, 1057, 
	1057, 1057, 1050, 1057, 1057, 1057, 1057, 1051, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1057, 1051, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1058, 1058, 
	1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1058, 
	1058, 1058, 1058, 1058, 1058, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1058, 
	1058, 1058, 1058, 1058, 1058, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1048, 1057, 1050, 1057, 1057, 
	1057, 1050, 1057, 1057, 1057, 1057, 1048, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1057, 1048, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1054, 1054, 
	1054, 1054, 1054, 1054, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1054, 1054, 
	1054, 1054, 1054, 1054, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1050, 1057, 1050, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1059, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1057, 1059, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1060, 1060, 1060, 
	1060, 1060, 1060, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1060, 1060, 1060, 
	1060, 1060, 1060, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1061, 1057, 1050, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1059, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1057, 1059, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1058, 1058, 1058, 1058, 1058, 
	1058, 1058, 1058, 1058, 1058, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1058, 1058, 1058, 1058, 
	1058, 1058, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1058, 1058, 1058, 1058, 
	1058, 1058, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1061, 1057, 1062, 1050, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1059, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1057, 1059, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1063, 1063, 1063, 1063, 1063, 
	1063, 1063, 1063, 1063, 1063, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1063, 1063, 1063, 1063, 
	1063, 1063, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1063, 1063, 1063, 1063, 
	1063, 1063, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1061, 1057, 1050, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1059, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1050, 1057, 1057, 1057, 
	1057, 1057, 1059, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1064, 1064, 1064, 1064, 1064, 1064, 
	1064, 1064, 1064, 1064, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1064, 1064, 1064, 1064, 1064, 
	1064, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1064, 1064, 1064, 1064, 1064, 
	1064, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1061, 
	1057, 1050, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1059, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1050, 1057, 1057, 1057, 1057, 
	1057, 1059, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1065, 1065, 1065, 1065, 1065, 1065, 1065, 
	1065, 1065, 1065, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1065, 1065, 1065, 1065, 1065, 1065, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1065, 1065, 1065, 1065, 1065, 1065, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1061, 1057, 
	1050, 1057, 1057, 1057, 1050, 1057, 1057, 1057, 
	1057, 1059, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1050, 1057, 1057, 1057, 1057, 1057, 
	1059, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1066, 1066, 1066, 1066, 1066, 1066, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1066, 1066, 1066, 1066, 1066, 1066, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1061, 1057, 1050, 
	1057, 1057, 1057, 1050, 1057, 1057, 1057, 1057, 
	1059, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1050, 1057, 1057, 1057, 1057, 1057, 1059, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1067, 1067, 1067, 1067, 1067, 1067, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1067, 1067, 1067, 1067, 1067, 1067, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1061, 1057, 1050, 1057, 
	1057, 1057, 1050, 1057, 1057, 1057, 1057, 1048, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1057, 1048, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1067, 
	1067, 1067, 1067, 1067, 1067, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1067, 
	1067, 1067, 1067, 1067, 1067, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1048, 1057, 1050, 1057, 1057, 
	1057, 1050, 1057, 1057, 1057, 1057, 1068, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1057, 1068, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1069, 1069, 1069, 
	1069, 1069, 1069, 1069, 1069, 1069, 1069, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1069, 1069, 
	1069, 1069, 1069, 1069, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1069, 1069, 
	1069, 1069, 1069, 1069, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1061, 1057, 1050, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1068, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1057, 1068, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1070, 1070, 1070, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1070, 1070, 1070, 
	1070, 1070, 1070, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1070, 1070, 1070, 
	1070, 1070, 1070, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1061, 1057, 1050, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1068, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1057, 1068, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1071, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1071, 1071, 1071, 1071, 
	1071, 1071, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1071, 1071, 1071, 1071, 
	1071, 1071, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1048, 1057, 1050, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1068, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1050, 1057, 1057, 1057, 
	1057, 1057, 1068, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1072, 1072, 1072, 1072, 1072, 1072, 
	1072, 1072, 1072, 1072, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1072, 1072, 1072, 1072, 1072, 
	1072, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1072, 1072, 1072, 1072, 1072, 
	1072, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1048, 
	1057, 1050, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1068, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1050, 1057, 1057, 1057, 1057, 
	1057, 1068, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1073, 1073, 1073, 1073, 1073, 1073, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1073, 1073, 1073, 1073, 1073, 1073, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1048, 1057, 
	1050, 1057, 1057, 1057, 1050, 1057, 1057, 1057, 
	1057, 1068, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1050, 1057, 1057, 1057, 1057, 1057, 
	1068, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1074, 1074, 1074, 1074, 1074, 1074, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1074, 1074, 1074, 1074, 1074, 1074, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1048, 1057, 1050, 
	1057, 1057, 1057, 1050, 1057, 1057, 1057, 1057, 
	1068, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1050, 1057, 1057, 1057, 1057, 1057, 1068, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1075, 1075, 1075, 1075, 1075, 1075, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1075, 1075, 1075, 1075, 1075, 1075, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1048, 1057, 1050, 1057, 
	1057, 1057, 1050, 1057, 1057, 1057, 1057, 1068, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1057, 1068, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1067, 
	1067, 1067, 1067, 1067, 1067, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1067, 
	1067, 1067, 1067, 1067, 1067, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1048, 1057, 1050, 1057, 1057, 
	1057, 1050, 1057, 1057, 1057, 1057, 1068, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1057, 1068, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1076, 1076, 
	1076, 1076, 1076, 1076, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1076, 1076, 
	1076, 1076, 1076, 1076, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1061, 1057, 1050, 1057, 1057, 1057, 
	1050, 1057, 1057, 1057, 1057, 1068, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1057, 1068, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1077, 1077, 1077, 1077, 
	1077, 1077, 1077, 1077, 1077, 1077, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1077, 1077, 1077, 
	1077, 1077, 1077, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1077, 1077, 1077, 
	1077, 1077, 1077, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1061, 1057, 1050, 1057, 1057, 1057, 1050, 
	1057, 1057, 1057, 1057, 1068, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1057, 1068, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1078, 1078, 1078, 1078, 1078, 
	1078, 1078, 1078, 1078, 1078, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1078, 1078, 1078, 1078, 
	1078, 1078, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1078, 1078, 1078, 1078, 
	1078, 1078, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1061, 1057, 1050, 1057, 1057, 1057, 1050, 1057, 
	1057, 1057, 1057, 1068, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1050, 1057, 1057, 1057, 
	1057, 1057, 1068, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1079, 1079, 1079, 1079, 1079, 
	1079, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1079, 1079, 1079, 1079, 1079, 
	1079, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1061, 
	1057, 1050, 1057, 1057, 1057, 1050, 1057, 1057, 
	1057, 1057, 1068, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1050, 1057, 1057, 1057, 1057, 
	1057, 1068, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1067, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1067, 1067, 1067, 1067, 1067, 1067, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1067, 1067, 1067, 1067, 1067, 1067, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1061, 1057, 
	1080, 1081, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1083, 1083, 1083, 1083, 1083, 
	1083, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1083, 1083, 1083, 1083, 1083, 
	1083, 1082, 1082, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 287, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 288, 204, 204, 
	289, 204, 287, 204, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 204, 204, 
	204, 204, 286, 204, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 204, 204, 
	204, 204, 204, 286, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 287, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 288, 932, 
	932, 289, 932, 287, 932, 286, 286, 286, 
	286, 1084, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 932, 
	932, 932, 932, 286, 932, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 932, 
	932, 932, 932, 932, 286, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 287, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 288, 
	932, 932, 289, 932, 287, 932, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 1085, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	932, 932, 932, 932, 286, 932, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	932, 932, 932, 932, 932, 286, 1086, 1087, 
	932, 927, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 1088, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	1089, 1090, 866, 866, 866, 866, 866, 1091, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1092, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	1093, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 1094, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 1095, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 1096, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1097, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 1098, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 1099, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 1100, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 287, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	204, 204, 289, 204, 287, 204, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	204, 204, 204, 204, 866, 204, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	204, 204, 204, 204, 204, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 1101, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1102, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 1098, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 1103, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	1102, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1104, 
	866, 1105, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 1106, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 1107, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1100, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 1100, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 1108, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1109, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 866, 866, 
	1110, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 1111, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1100, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 1112, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 1113, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1100, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	1114, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1115, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1116, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 1100, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 1117, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 1107, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 1118, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1100, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 866, 1100, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1119, 866, 1120, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1121, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 1100, 866, 866, 
	866, 1118, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 1100, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 1122, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1123, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 1116, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 1124, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 901, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1114, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	1100, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 1125, 866, 866, 
	866, 866, 866, 866, 866, 1100, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1126, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 1127, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1128, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1116, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 1129, 866, 866, 866, 1130, 866, 866, 
	866, 866, 866, 1131, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 1131, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1100, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1100, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 1132, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 1133, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 1134, 1135, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1100, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 1136, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 1137, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 1138, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1141, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1142, 1139, 1139, 1143, 1139, 1141, 1139, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1139, 1139, 1139, 1139, 1140, 1139, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1139, 1139, 1139, 1139, 1139, 1140, 918, 
	1144, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	920, 917, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 1145, 866, 866, 1146, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 1100, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 1111, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 1147, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1148, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1118, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1149, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 901, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 866, 866, 
	866, 1150, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1151, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 1111, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	1116, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1152, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 1153, 866, 866, 866, 866, 866, 866, 
	866, 1154, 866, 866, 866, 866, 866, 866, 
	866, 1155, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 1118, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 1156, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 1157, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 1125, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 1158, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 910, 911, 911, 
	911, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 287, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 288, 910, 910, 
	289, 910, 287, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 912, 
	910, 910, 866, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 1125, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 910, 910, 
	910, 910, 910, 866, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 910, 911, 
	911, 911, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 911, 287, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 288, 910, 
	910, 289, 910, 287, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	912, 910, 910, 866, 910, 866, 866, 866, 
	866, 866, 866, 866, 1159, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 910, 
	910, 910, 910, 910, 866, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 910, 
	911, 911, 911, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 911, 287, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 288, 
	910, 910, 289, 910, 287, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 912, 910, 910, 866, 910, 866, 866, 
	866, 866, 1111, 866, 866, 866, 1160, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	910, 910, 910, 910, 910, 866, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	910, 911, 911, 911, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 911, 287, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	288, 910, 910, 289, 910, 287, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 912, 910, 910, 866, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 1161, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 910, 910, 910, 910, 910, 866, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 910, 911, 911, 911, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 911, 
	287, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 288, 910, 910, 289, 910, 287, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 912, 910, 910, 866, 910, 
	866, 866, 866, 866, 1125, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 910, 910, 910, 910, 910, 866, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 910, 911, 911, 911, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	911, 287, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 288, 910, 910, 289, 910, 287, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 912, 910, 910, 866, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 1162, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 910, 910, 910, 910, 910, 
	866, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 910, 911, 911, 911, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 911, 287, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 288, 910, 910, 289, 910, 
	287, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 912, 910, 910, 
	866, 910, 866, 866, 866, 866, 1163, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 910, 910, 910, 910, 
	910, 866, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 911, 910, 911, 911, 911, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 911, 287, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 288, 910, 910, 289, 
	910, 287, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 912, 910, 
	910, 866, 910, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 1105, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 910, 910, 910, 
	910, 910, 866, 1164, 215, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 932, 932, 932, 932, 932, 
	932, 932, 932, 1165, 932, 1167, 1166, 1166, 
	1166, 1167, 1166, 1166, 1166, 1166, 1168, 1169, 
	1168, 1168, 1168, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1167, 
	1166, 1166, 1166, 1166, 1166, 1168, 1166, 1166, 
	1170, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1171, 1166, 1168, 1172, 1168, 1168, 1168, 
	1172, 1172, 1172, 1172, 1172, 1172, 1172, 1172, 
	1172, 1172, 1172, 1172, 1172, 1172, 1172, 1172, 
	1172, 1172, 1168, 1172, 1173, 1174, 1175, 1176, 
	1177, 1179, 1178, 1180, 1182, 1183, 1183, 1183, 
	1182, 1183, 1183, 1183, 1183, 1184, 1185, 1184, 
	1184, 1184, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1182, 1183, 
	1183, 1183, 1183, 1183, 1184, 1183, 1186, 1187, 
	1183, 1183, 1183, 1186, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1183, 
	1188, 1183, 1183, 1181, 1183, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1183, 
	1183, 1183, 1183, 1183, 1181, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 295, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 296, 
	1189, 1189, 1189, 1189, 295, 1189, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	1189, 1189, 1189, 1189, 294, 1189, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	1189, 1189, 1189, 1189, 1189, 294, 1184, 1190, 
	1184, 1184, 1184, 1190, 1190, 1190, 1190, 1190, 
	1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
	1190, 1190, 1190, 1190, 1190, 1184, 1190, 1191, 
	1192, 1193, 1194, 1195, 1196, 1189, 1197, 1199, 
	1200, 1200, 1200, 1199, 1200, 1200, 1200, 1200, 
	1201, 1202, 1201, 1201, 1201, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1199, 1200, 1200, 1200, 1200, 1200, 1201, 
	1203, 1204, 1205, 1206, 1207, 1208, 1204, 1209, 
	1210, 1211, 1207, 1212, 1213, 1214, 1207, 1215, 
	1216, 1216, 1216, 1216, 1216, 1216, 1216, 1216, 
	1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 
	1224, 1225, 1224, 1224, 1226, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1227, 1228, 1229, 1207, 1230, 1204, 
	1231, 1232, 1233, 1234, 1235, 1236, 1198, 1198, 
	1237, 1198, 1198, 1198, 1238, 1239, 1240, 1198, 
	1198, 1241, 1242, 1243, 1244, 1198, 1245, 1198, 
	1246, 1198, 1247, 1248, 1249, 1250, 1200, 1198, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 1251, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 304, 304, 304, 304, 304, 1251, 
	304, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 304, 304, 304, 304, 1198, 
	304, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 304, 304, 304, 304, 304, 
	1198, 1253, 1252, 1254, 1201, 1255, 1201, 1201, 
	1201, 1255, 1255, 1255, 1255, 1255, 1255, 1255, 
	1255, 1255, 1255, 1255, 1255, 1255, 1255, 1255, 
	1255, 1255, 1255, 1201, 1255, 1256, 1258, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1258, 
	1257, 1259, 1260, 1261, 1262, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 299, 299, 
	1263, 299, 1263, 299, 299, 1263, 1263, 299, 
	299, 299, 1264, 299, 299, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 299, 
	299, 299, 299, 299, 299, 299, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	1263, 299, 1263, 1263, 316, 299, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	1263, 1263, 1263, 299, 1263, 316, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 
	1266, 1266, 1266, 1266, 1266, 1266, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	1266, 1266, 1266, 1266, 1266, 1266, 1266, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 1266, 1266, 1266, 1266, 316, 1266, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 1266, 1266, 1266, 1266, 1266, 316, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1266, 1267, 304, 1207, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1269, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1267, 1268, 1270, 1271, 1207, 
	1272, 1272, 1272, 1272, 1272, 1272, 1272, 1272, 
	1272, 1272, 1272, 1272, 1272, 1272, 1272, 1272, 
	1272, 1272, 1267, 1272, 1267, 1273, 1268, 1275, 
	1274, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 1274, 1277, 1276, 1278, 1276, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1280, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1281, 
	1279, 1279, 1279, 1279, 1279, 1280, 1279, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 1279, 1279, 
	1279, 1279, 1279, 1279, 1279, 1279, 301, 1279, 
	1283, 1282, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1285, 1282, 1286, 1287, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1288, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1289, 1282, 1282, 1282, 1282, 1282, 
	1282, 1290, 1282, 1282, 1285, 1282, 1286, 1287, 
	1282, 1282, 1282, 1291, 1282, 1282, 1282, 1282, 
	1282, 1288, 1282, 1282, 1292, 1282, 1282, 1282, 
	1282, 1282, 1289, 1282, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 1293, 1293, 
	1293, 1293, 1293, 1293, 1293, 1293, 1293, 1293, 
	1293, 1294, 1293, 1293, 1293, 1293, 1293, 1293, 
	1293, 1293, 1293, 1293, 1293, 1293, 1293, 1293, 
	1293, 1293, 1293, 1293, 1293, 1293, 1293, 1293, 
	1293, 1293, 1293, 1295, 1293, 1293, 1293, 1293, 
	1293, 1294, 1293, 1293, 1293, 1296, 1293, 1293, 
	1293, 1293, 1293, 1293, 1293, 1293, 1297, 1293, 
	1298, 304, 1298, 304, 304, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 304, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1298, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1300, 1299, 1302, 1301, 1303, 1305, 1304, 
	1304, 1304, 1306, 1304, 1307, 1308, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1290, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1291, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1292, 1282, 1309, 1309, 1309, 1309, 1309, 1309, 
	1309, 1309, 1309, 1309, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1310, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1291, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1292, 1282, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1313, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1314, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1315, 1311, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1316, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1314, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1315, 1311, 1314, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1315, 
	1311, 1318, 1317, 1319, 1321, 1320, 1320, 1320, 
	1322, 1320, 1324, 1323, 1325, 1326, 1328, 1328, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1329, 1327, 1327, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1330, 
	1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 
	1331, 1327, 1332, 1332, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1333, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1314, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1315, 1311, 1332, 1332, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1316, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1314, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1315, 1311, 1335, 1335, 1335, 1335, 1335, 1335, 
	1335, 1335, 1335, 1335, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1336, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1337, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1338, 1334, 1340, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1339, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1339, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1339, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1339, 
	1339, 1339, 1339, 1339, 1339, 1341, 1339, 1339, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1342, 
	1339, 1339, 1339, 1339, 1339, 1339, 1339, 1339, 
	1343, 1339, 1345, 1345, 1345, 1345, 1345, 1345, 
	1345, 1345, 1345, 1345, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1345, 1345, 1345, 1345, 1345, 
	1345, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1346, 1344, 1345, 1345, 1345, 1345, 1345, 
	1345, 1344, 1344, 1347, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1348, 1344, 1349, 1349, 
	1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1349, 
	1349, 1349, 1349, 1349, 1349, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1350, 1311, 1349, 
	1349, 1349, 1349, 1349, 1349, 1311, 1311, 1314, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1315, 1311, 1349, 1349, 1349, 1349, 1349, 1349, 
	1349, 1349, 1349, 1349, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1349, 1349, 1349, 1349, 1349, 
	1349, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1316, 1311, 1349, 1349, 1349, 1349, 1349, 
	1349, 1311, 1311, 1314, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1315, 1311, 1352, 1351, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1354, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1355, 
	1351, 1351, 1351, 1351, 1351, 1354, 1351, 1351, 
	1351, 1356, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1357, 1351, 1358, 1358, 1358, 1358, 
	1358, 1358, 1358, 1358, 1358, 1358, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1359, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1356, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1357, 1351, 
	1360, 1311, 1361, 1361, 1361, 1361, 1361, 1361, 
	1361, 1361, 1361, 1361, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1362, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1363, 1311, 1311, 1311, 1311, 1311, 1362, 
	1311, 1311, 1311, 1314, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1315, 1311, 1361, 1361, 
	1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1316, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1314, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1315, 1311, 1269, 1276, 1207, 1364, 1268, 1258, 
	1268, 1365, 1366, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 
	1276, 1276, 1258, 1276, 1258, 1268, 1258, 1207, 
	1268, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 1263, 1263, 1263, 1263, 1263, 1263, 1263, 
	1263, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 1263, 1263, 1263, 1263, 1263, 
	1263, 1367, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 1263, 1263, 1263, 1263, 
	316, 1263, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 1263, 1263, 1263, 1263, 
	1263, 316, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 1251, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1368, 304, 304, 304, 
	304, 1251, 304, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 304, 304, 304, 
	304, 1224, 304, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 304, 304, 304, 
	304, 304, 1224, 1369, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1251, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1368, 1370, 
	1370, 1370, 1370, 1251, 1370, 1224, 1224, 1224, 
	1224, 1371, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1370, 
	1370, 1370, 1370, 1224, 1370, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1370, 
	1370, 1370, 1370, 1370, 1224, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1251, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1368, 
	1370, 1370, 1370, 1370, 1251, 1370, 1224, 1224, 
	1224, 1224, 1224, 1224, 1372, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1370, 1370, 1370, 1370, 1224, 1370, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1370, 1370, 1370, 1370, 1370, 1224, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1251, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1368, 1370, 1370, 1370, 1370, 1251, 1370, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1373, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1370, 1370, 1370, 1370, 1224, 1370, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1370, 1370, 1370, 1370, 1370, 1224, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1251, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1368, 1370, 1370, 1370, 1370, 1251, 1370, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1374, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1370, 1370, 1370, 1370, 1224, 1370, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1370, 1370, 1370, 1370, 1370, 1224, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1251, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1368, 1370, 1370, 1370, 1370, 1251, 
	1370, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1375, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1370, 1370, 1370, 1370, 1224, 
	1370, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1370, 1370, 1370, 1370, 1370, 
	1224, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1251, 1370, 1370, 1370, 1370, 1370, 
	1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 
	1370, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1368, 1370, 1370, 1370, 1370, 
	1251, 1370, 1224, 1224, 1224, 1374, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1370, 1370, 1370, 1370, 
	1224, 1370, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1370, 1370, 1370, 1370, 
	1370, 1224, 1376, 1378, 1377, 1379, 1380, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1382, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1383, 1384, 1198, 
	1198, 1198, 1198, 1198, 1385, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1386, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1387, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1388, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1389, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1390, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1391, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1392, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1393, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1394, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1395, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1396, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1397, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1398, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1399, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1400, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1396, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1401, 1198, 1402, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1403, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1404, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1405, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1406, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1407, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1408, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1409, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1410, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1406, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1411, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1412, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1413, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1414, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1415, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1416, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1406, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1417, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1418, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1419, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1420, 1420, 1420, 1420, 1420, 
	1420, 1420, 1420, 1420, 318, 319, 318, 318, 
	318, 1420, 1420, 1420, 1420, 1420, 1420, 1420, 
	1420, 1420, 1420, 1420, 1420, 1420, 1420, 1420, 
	1420, 1420, 1420, 318, 1251, 1420, 320, 1420, 
	1420, 1420, 1420, 1420, 1420, 1420, 1420, 1420, 
	1420, 1420, 1420, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1420, 1420, 321, 
	1420, 1420, 1251, 1420, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1420, 322, 
	1420, 1420, 1198, 1420, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1420, 1420, 
	1420, 1420, 1420, 1198, 335, 336, 335, 335, 
	335, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 335, 334, 334, 337, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 340, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 339, 
	334, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1422, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1423, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1424, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1251, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1425, 1425, 1425, 
	1425, 1425, 1251, 1425, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1425, 1425, 
	1425, 1425, 1198, 1425, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1426, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1425, 1425, 
	1425, 1425, 1425, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1427, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1428, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1429, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1430, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1431, 1198, 1432, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1433, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1406, 
	1198, 1198, 1198, 1434, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1406, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1399, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1435, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1436, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1416, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1437, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1240, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1438, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1439, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1399, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1406, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1440, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1406, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1441, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1442, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1443, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1416, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1444, 1198, 
	1198, 1198, 1445, 1198, 1198, 1198, 1198, 1198, 
	1446, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1447, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1413, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1399, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1448, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1449, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1450, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1451, 1452, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1399, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1453, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1454, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1440, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1455, 1198, 
	1198, 1456, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1399, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1457, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1413, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1458, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1459, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1460, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1399, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1461, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1462, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1448, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1463, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1464, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1410, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1439, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1465, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1466, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1467, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1468, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1469, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1405, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1470, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1471, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1440, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1472, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1440, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1198, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1473, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1198, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1198, 1381, 1198, 1198, 1198, 1198, 
	1410, 1198, 1198, 1198, 1474, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1198, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1381, 1381, 
	1381, 1381, 1381, 1251, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1198, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1475, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1198, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1381, 
	1381, 1381, 1381, 1381, 1251, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1198, 1381, 1198, 1198, 
	1198, 1198, 1440, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1198, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1381, 1381, 1381, 1381, 1381, 1251, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1198, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1476, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1198, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1381, 1381, 1381, 1381, 1381, 1251, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1198, 1381, 
	1198, 1198, 1198, 1198, 1477, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1198, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1251, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1381, 1381, 1381, 1381, 1381, 1251, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1198, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1478, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1198, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1251, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1381, 1381, 1381, 1381, 1381, 
	1251, 1381, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1198, 1381, 1198, 1198, 1198, 1448, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1198, 1198, 1198, 1198, 
	1198, 1198, 1198, 1198, 1381, 1381, 1381, 1381, 
	1381, 1198, 1479, 1267, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1207, 1257, 1480, 1482, 1481, 1482, 
	1482, 1482, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1482, 1481, 1481, 1483, 
	1481, 1481, 1484, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 347, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 
	1485, 1481, 344, 345, 344, 344, 344, 1486, 
	1486, 1486, 1486, 1486, 1486, 1486, 1486, 1486, 
	1486, 1486, 1486, 1486, 1486, 1486, 1486, 1486, 
	1486, 344, 1486, 1486, 1486, 1486, 1486, 346, 
	1486, 1486, 1486, 1486, 1486, 1486, 1486, 347, 
	1486, 349, 1487, 349, 349, 349, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	349, 1487, 1487, 1488, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 
	1487, 1487, 1487, 1487, 1489, 1487, 351, 350, 
	357, 1486, 355, 1486, 1491, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1492, 
	1490, 1491, 1490, 1491, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1494, 1490, 
	1491, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1495, 1490, 1491, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1496, 1490, 1498, 1496, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	185, 2, 3, 4, 191, 6, 7, 8, 
	9, 10, 185, 185, 194, 197, 194, 12, 
	198, 199, 14, 194, 206, 207, 210, 211, 
	217, 212, 213, 214, 19, 215, 216, 219, 
	221, 222, 223, 224, 225, 25, 18, 208, 
	209, 27, 248, 249, 251, 253, 251, 30, 
	254, 255, 32, 251, 262, 263, 266, 267, 
	273, 268, 269, 270, 37, 271, 272, 275, 
	277, 278, 279, 280, 281, 43, 36, 264, 
	265, 45, 304, 305, 312, 314, 312, 48, 
	315, 316, 50, 318, 321, 318, 52, 322, 
	323, 54, 329, 328, 0, 56, 330, 331, 
	58, 332, 333, 333, 333, 333, 446, 61, 
	62, 63, 446, 474, 64, 65, 474, 474, 
	478, 478, 69, 64, 70, 476, 477, 479, 
	480, 478, 474, 481, 482, 484, 66, 67, 
	485, 486, 68, 478, 71, 72, 77, 84, 
	488, 489, 70, 476, 477, 479, 480, 478, 
	474, 481, 482, 484, 66, 67, 485, 486, 
	68, 71, 72, 77, 84, 488, 489, 487, 
	73, 74, 75, 76, 78, 79, 82, 80, 
	81, 83, 85, 86, 474, 88, 89, 90, 
	92, 95, 93, 94, 96, 98, 505, 505, 
	505, 506, 100, 508, 101, 509, 102, 506, 
	100, 508, 101, 509, 543, 103, 543, 104, 
	105, 103, 543, 104, 543, 543, 543, 108, 
	109, 110, 111, 554, 543, 543, 559, 543, 
	114, 115, 116, 543, 119, 114, 115, 116, 
	543, 119, 117, 117, 115, 116, 565, 118, 
	117, 117, 115, 116, 565, 118, 115, 543, 
	581, 543, 121, 582, 588, 125, 597, 598, 
	130, 131, 125, 126, 596, 126, 596, 543, 
	127, 128, 129, 599, 132, 543, 613, 614, 
	617, 618, 624, 619, 620, 621, 137, 622, 
	623, 626, 628, 629, 630, 631, 632, 143, 
	136, 615, 616, 145, 668, 669, 147, 545, 
	106, 547, 149, 150, 671, 773, 152, 153, 
	154, 773, 781, 781, 781, 157, 803, 802, 
	781, 805, 807, 781, 162, 163, 164, 811, 
	781, 166, 167, 822, 791, 844, 170, 171, 
	172, 176, 177, 170, 171, 172, 176, 177, 
	173, 173, 171, 172, 174, 175, 173, 173, 
	171, 172, 174, 175, 892, 171, 781, 961, 
	178, 963, 184, 961, 961, 179, 181, 963, 
	961, 181, 963, 183, 963, 961, 185, 185, 
	186, 187, 188, 190, 192, 193, 185, 185, 
	185, 189, 185, 189, 185, 1, 185, 185, 
	185, 5, 194, 194, 195, 194, 196, 200, 
	194, 194, 11, 13, 194, 194, 194, 194, 
	201, 202, 203, 15, 21, 26, 226, 28, 
	194, 194, 194, 204, 205, 194, 16, 194, 
	194, 194, 17, 194, 194, 194, 20, 218, 
	220, 22, 194, 194, 23, 24, 194, 227, 
	231, 228, 229, 230, 194, 194, 232, 233, 
	236, 238, 247, 234, 235, 194, 237, 239, 
	241, 240, 194, 242, 243, 244, 245, 246, 
	194, 194, 194, 250, 251, 251, 251, 252, 
	256, 251, 29, 31, 251, 251, 251, 251, 
	257, 258, 259, 33, 39, 44, 282, 46, 
	251, 251, 251, 260, 261, 251, 34, 251, 
	251, 251, 35, 251, 251, 251, 38, 274, 
	276, 40, 251, 251, 41, 42, 251, 283, 
	287, 284, 285, 286, 251, 251, 288, 289, 
	292, 294, 303, 290, 291, 251, 293, 295, 
	297, 296, 251, 298, 299, 300, 301, 302, 
	251, 251, 251, 306, 307, 307, 308, 307, 
	309, 307, 307, 307, 310, 310, 310, 311, 
	310, 310, 310, 312, 312, 312, 313, 312, 
	47, 49, 312, 312, 312, 317, 317, 317, 
	318, 318, 319, 318, 320, 318, 318, 51, 
	53, 318, 318, 318, 324, 324, 325, 324, 
	324, 326, 327, 326, 55, 57, 328, 328, 
	328, 334, 333, 333, 335, 336, 337, 338, 
	340, 343, 344, 345, 346, 333, 347, 348, 
	350, 352, 353, 354, 358, 360, 361, 362, 
	378, 383, 390, 395, 402, 409, 412, 413, 
	417, 411, 421, 429, 433, 435, 440, 442, 
	445, 333, 333, 333, 333, 333, 333, 339, 
	333, 339, 333, 341, 59, 342, 333, 60, 
	333, 333, 349, 351, 333, 355, 356, 357, 
	353, 359, 333, 363, 364, 373, 376, 365, 
	366, 367, 368, 369, 370, 371, 372, 334, 
	374, 375, 377, 379, 382, 380, 381, 384, 
	387, 385, 386, 388, 389, 391, 393, 392, 
	394, 396, 397, 333, 398, 399, 400, 401, 
	333, 403, 406, 404, 405, 407, 408, 410, 
	414, 415, 416, 418, 420, 419, 422, 423, 
	424, 426, 425, 427, 428, 430, 431, 432, 
	434, 436, 437, 438, 439, 441, 443, 444, 
	447, 446, 446, 448, 449, 451, 446, 446, 
	446, 450, 446, 450, 452, 446, 454, 453, 
	453, 457, 458, 459, 460, 453, 462, 463, 
	464, 465, 467, 469, 470, 471, 472, 473, 
	453, 455, 453, 456, 453, 453, 453, 453, 
	453, 461, 453, 461, 466, 453, 468, 453, 
	474, 474, 475, 490, 491, 477, 493, 494, 
	481, 495, 496, 497, 498, 499, 501, 502, 
	503, 504, 474, 474, 474, 474, 474, 474, 
	478, 483, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 492, 474, 492, 474, 474, 
	474, 474, 500, 474, 87, 91, 97, 505, 
	507, 510, 99, 505, 505, 506, 511, 511, 
	512, 513, 515, 517, 518, 511, 511, 514, 
	511, 514, 511, 516, 511, 511, 511, 520, 
	519, 519, 521, 522, 523, 525, 527, 528, 
	533, 540, 519, 519, 519, 519, 524, 519, 
	524, 519, 526, 519, 519, 520, 529, 530, 
	531, 532, 534, 535, 538, 536, 537, 539, 
	541, 542, 544, 543, 552, 553, 555, 556, 
	558, 560, 561, 562, 564, 566, 567, 569, 
	570, 595, 601, 602, 603, 671, 672, 673, 
	674, 675, 563, 677, 694, 699, 706, 711, 
	713, 719, 722, 723, 727, 721, 731, 742, 
	746, 749, 757, 761, 764, 765, 543, 103, 
	104, 543, 106, 546, 543, 543, 548, 550, 
	551, 543, 549, 543, 543, 543, 543, 543, 
	107, 543, 543, 543, 543, 543, 557, 543, 
	557, 543, 543, 112, 543, 543, 113, 543, 
	543, 563, 543, 568, 543, 543, 543, 571, 
	580, 543, 120, 583, 584, 585, 543, 586, 
	122, 589, 590, 123, 593, 594, 543, 572, 
	574, 543, 573, 543, 543, 575, 578, 579, 
	543, 576, 577, 543, 543, 543, 543, 543, 
	543, 587, 543, 581, 591, 592, 543, 591, 
	543, 581, 591, 124, 600, 543, 543, 543, 
	604, 543, 543, 543, 605, 607, 543, 606, 
	543, 606, 543, 608, 609, 610, 133, 139, 
	144, 633, 146, 543, 543, 543, 611, 612, 
	543, 134, 543, 543, 543, 135, 543, 543, 
	543, 138, 625, 627, 140, 543, 543, 141, 
	142, 543, 634, 638, 635, 636, 637, 543, 
	543, 639, 640, 643, 654, 667, 641, 642, 
	543, 644, 645, 646, 648, 647, 543, 649, 
	650, 651, 652, 653, 655, 662, 656, 657, 
	658, 659, 660, 661, 663, 664, 665, 666, 
	543, 543, 543, 670, 148, 151, 543, 676, 
	678, 679, 689, 692, 680, 681, 682, 683, 
	684, 685, 686, 687, 688, 690, 691, 693, 
	695, 698, 696, 697, 700, 703, 701, 702, 
	704, 705, 707, 709, 708, 710, 712, 714, 
	716, 715, 717, 718, 720, 688, 724, 725, 
	726, 728, 730, 729, 732, 733, 734, 739, 
	735, 736, 737, 543, 544, 545, 106, 738, 
	550, 740, 741, 743, 744, 745, 747, 748, 
	750, 751, 752, 755, 753, 754, 756, 758, 
	759, 760, 762, 763, 543, 563, 766, 766, 
	767, 768, 769, 771, 766, 766, 766, 770, 
	766, 770, 766, 772, 766, 774, 773, 773, 
	775, 776, 773, 777, 779, 773, 773, 773, 
	773, 778, 773, 778, 780, 773, 782, 781, 
	781, 785, 786, 787, 781, 788, 790, 793, 
	794, 795, 796, 797, 781, 798, 799, 804, 
	832, 836, 781, 837, 839, 841, 781, 842, 
	843, 845, 849, 851, 852, 854, 855, 873, 
	878, 885, 893, 900, 907, 912, 913, 917, 
	911, 922, 932, 938, 941, 950, 954, 958, 
	959, 960, 793, 783, 781, 784, 781, 781, 
	781, 781, 781, 781, 789, 781, 789, 781, 
	155, 792, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 800, 781, 801, 781, 781, 
	156, 158, 781, 159, 813, 824, 827, 806, 
	828, 829, 814, 818, 820, 781, 806, 159, 
	808, 810, 160, 781, 808, 781, 809, 781, 
	781, 161, 812, 781, 781, 815, 817, 781, 
	815, 816, 818, 820, 817, 781, 819, 781, 
	781, 821, 823, 781, 165, 781, 781, 781, 
	825, 817, 818, 820, 825, 826, 781, 815, 
	817, 818, 820, 781, 815, 817, 818, 820, 
	781, 830, 817, 818, 820, 830, 831, 781, 
	159, 832, 806, 833, 818, 820, 834, 817, 
	159, 834, 806, 835, 838, 840, 781, 168, 
	169, 781, 781, 846, 847, 848, 843, 850, 
	781, 781, 853, 781, 781, 781, 856, 857, 
	866, 871, 858, 859, 860, 861, 862, 863, 
	864, 865, 782, 867, 868, 869, 870, 782, 
	872, 874, 877, 875, 876, 782, 782, 879, 
	882, 880, 881, 883, 884, 782, 886, 888, 
	887, 889, 890, 891, 781, 781, 894, 782, 
	895, 781, 896, 897, 898, 899, 783, 901, 
	904, 902, 903, 905, 906, 908, 909, 910, 
	782, 914, 915, 916, 918, 920, 921, 919, 
	782, 923, 924, 925, 928, 926, 927, 929, 
	930, 931, 933, 935, 934, 936, 937, 939, 
	940, 942, 943, 945, 948, 944, 946, 947, 
	949, 951, 952, 953, 955, 956, 957, 781, 
	781, 961, 962, 964, 965, 966, 961, 961, 
	180, 182, 968, 967, 969, 967, 970, 971, 
	972, 967, 967
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 0, 6, 0, 7, 0, 8, 
	0, 7, 0, 0, 0, 0, 8, 7, 
	0, 8, 0, 7, 7, 0, 0, 0, 
	0, 0, 0, 0, 9, 0, 10, 0, 
	0, 0, 0, 11, 0, 7, 0, 8, 
	0, 7, 0, 0, 0, 0, 8, 7, 
	0, 8, 0, 7, 7, 0, 0, 0, 
	0, 0, 0, 0, 12, 0, 13, 0, 
	0, 0, 0, 14, 0, 15, 0, 0, 
	0, 0, 0, 16, 0, 0, 0, 0, 
	0, 0, 17, 18, 19, 20, 21, 0, 
	0, 0, 22, 23, 0, 0, 24, 25, 
	26, 27, 28, 29, 29, 30, 31, 29, 
	32, 31, 33, 31, 29, 29, 30, 29, 
	34, 29, 29, 35, 29, 29, 29, 29, 
	29, 29, 0, 36, 37, 0, 38, 37, 
	39, 37, 0, 0, 36, 0, 40, 0, 
	0, 0, 0, 0, 0, 0, 0, 27, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 41, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 42, 43, 
	44, 45, 0, 0, 0, 45, 28, 46, 
	29, 29, 29, 46, 47, 0, 48, 0, 
	28, 29, 49, 29, 50, 51, 52, 0, 
	0, 0, 0, 0, 53, 54, 0, 55, 
	0, 28, 0, 56, 0, 29, 57, 29, 
	58, 29, 59, 60, 61, 60, 62, 60, 
	0, 63, 64, 63, 65, 63, 66, 67, 
	0, 68, 0, 0, 0, 0, 69, 69, 
	0, 0, 70, 70, 71, 0, 28, 72, 
	0, 0, 0, 69, 0, 73, 0, 7, 
	0, 8, 0, 7, 0, 0, 0, 0, 
	8, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 74, 
	0, 0, 0, 0, 74, 75, 0, 0, 
	0, 76, 77, 78, 79, 0, 7, 7, 
	80, 81, 81, 82, 0, 0, 0, 0, 
	83, 0, 0, 0, 0, 0, 0, 28, 
	0, 0, 0, 29, 57, 29, 29, 29, 
	59, 60, 61, 60, 60, 60, 0, 63, 
	64, 63, 63, 63, 84, 66, 85, 86, 
	0, 87, 88, 89, 90, 0, 59, 91, 
	92, 0, 93, 28, 94, 95, 98, 99, 
	0, 28, 0, 7, 0, 7, 100, 101, 
	102, 59, 103, 0, 104, 0, 105, 106, 
	107, 0, 108, 109, 0, 110, 7, 7, 
	111, 112, 0, 0, 113, 114, 115, 116, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	118, 119, 120, 0, 0, 121, 0, 122, 
	123, 124, 0, 125, 126, 127, 0, 7, 
	0, 0, 128, 129, 0, 28, 130, 0, 
	0, 0, 0, 0, 131, 132, 0, 0, 
	0, 0, 0, 0, 0, 133, 0, 0, 
	0, 0, 134, 0, 0, 0, 0, 0, 
	135, 136, 137, 0, 138, 139, 140, 7, 
	7, 141, 0, 0, 142, 143, 144, 145, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	146, 147, 148, 0, 0, 149, 0, 150, 
	151, 152, 0, 153, 154, 155, 0, 7, 
	0, 0, 156, 157, 0, 28, 158, 0, 
	0, 0, 0, 0, 159, 160, 0, 0, 
	0, 0, 0, 0, 0, 161, 0, 0, 
	0, 0, 162, 0, 0, 0, 0, 0, 
	163, 164, 165, 0, 166, 167, 0, 168, 
	0, 169, 170, 171, 172, 173, 174, 0, 
	175, 176, 177, 178, 179, 180, 7, 181, 
	0, 0, 182, 183, 184, 185, 186, 187, 
	188, 189, 0, 190, 7, 191, 192, 0, 
	0, 193, 194, 195, 196, 197, 0, 198, 
	199, 200, 0, 201, 0, 0, 202, 203, 
	204, 205, 206, 207, 0, 28, 0, 0, 
	7, 7, 0, 0, 0, 208, 0, 0, 
	0, 0, 209, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 210, 211, 212, 213, 214, 215, 59, 
	216, 0, 217, 0, 0, 0, 218, 0, 
	219, 220, 0, 0, 221, 0, 0, 0, 
	222, 0, 223, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 222, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 224, 0, 0, 0, 0, 
	225, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	7, 226, 227, 0, 0, 0, 228, 229, 
	230, 59, 231, 0, 28, 232, 0, 233, 
	234, 0, 28, 0, 0, 235, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	236, 0, 237, 0, 238, 239, 240, 241, 
	242, 59, 243, 0, 0, 244, 0, 245, 
	246, 247, 248, 28, 0, 27, 0, 0, 
	27, 0, 0, 0, 0, 0, 0, 7, 
	7, 7, 249, 250, 251, 252, 253, 254, 
	255, 0, 256, 257, 258, 259, 260, 261, 
	262, 263, 264, 59, 265, 0, 266, 267, 
	268, 269, 270, 271, 0, 0, 0, 272, 
	7, 7, 0, 273, 274, 275, 276, 277, 
	0, 0, 0, 0, 0, 278, 279, 59, 
	280, 0, 281, 28, 282, 283, 284, 285, 
	286, 287, 0, 28, 0, 0, 0, 0, 
	0, 0, 288, 289, 290, 291, 59, 292, 
	0, 293, 28, 294, 295, 296, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 297, 298, 0, 8, 0, 0, 
	7, 299, 0, 0, 299, 299, 0, 0, 
	7, 300, 0, 300, 0, 300, 300, 300, 
	0, 0, 300, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 0, 0, 301, 302, 
	302, 303, 304, 0, 305, 306, 0, 74, 
	0, 307, 0, 308, 309, 310, 311, 312, 
	29, 313, 314, 315, 316, 317, 59, 318, 
	0, 319, 320, 0, 321, 322, 0, 323, 
	324, 299, 325, 0, 326, 327, 328, 0, 
	0, 329, 0, 0, 0, 0, 330, 0, 
	0, 0, 0, 0, 0, 0, 331, 0, 
	0, 332, 0, 333, 334, 0, 0, 0, 
	335, 0, 0, 336, 337, 338, 339, 340, 
	341, 0, 342, 343, 343, 0, 344, 0, 
	345, 346, 346, 0, 0, 347, 348, 349, 
	0, 350, 351, 352, 0, 7, 353, 354, 
	355, 0, 356, 117, 117, 117, 117, 117, 
	117, 117, 117, 357, 358, 359, 0, 0, 
	360, 0, 361, 362, 363, 0, 364, 365, 
	366, 0, 7, 0, 0, 367, 368, 0, 
	28, 369, 0, 0, 0, 0, 0, 370, 
	371, 0, 0, 0, 0, 0, 0, 0, 
	372, 0, 0, 0, 0, 0, 373, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	374, 375, 376, 0, 0, 0, 377, 28, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 74, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 378, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 379, 380, 381, 382, 383, 383, 
	379, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 384, 385, 386, 387, 
	0, 28, 0, 0, 388, 389, 390, 59, 
	391, 0, 392, 28, 393, 7, 394, 395, 
	0, 28, 396, 0, 0, 397, 398, 399, 
	400, 59, 401, 0, 28, 402, 403, 404, 
	405, 0, 28, 0, 406, 0, 7, 407, 
	0, 0, 0, 0, 408, 0, 0, 409, 
	409, 0, 410, 0, 0, 0, 411, 7, 
	412, 412, 412, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 413, 414, 415, 0, 416, 417, 
	418, 419, 420, 421, 59, 422, 0, 423, 
	0, 0, 424, 425, 426, 427, 428, 429, 
	430, 431, 432, 0, 433, 0, 434, 435, 
	0, 0, 436, 437, 438, 0, 0, 439, 
	0, 0, 438, 440, 440, 441, 442, 0, 
	443, 444, 0, 445, 446, 447, 0, 448, 
	449, 0, 0, 450, 451, 438, 438, 452, 
	0, 0, 453, 453, 0, 454, 0, 455, 
	456, 7, 0, 457, 0, 458, 459, 460, 
	461, 461, 462, 462, 0, 0, 463, 464, 
	464, 465, 465, 466, 467, 467, 468, 468, 
	469, 470, 470, 471, 471, 0, 0, 472, 
	473, 474, 475, 476, 477, 477, 474, 476, 
	478, 409, 479, 0, 0, 0, 480, 0, 
	0, 481, 482, 412, 412, 412, 483, 412, 
	484, 485, 28, 486, 487, 488, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 489, 0, 0, 0, 0, 483, 
	0, 0, 0, 0, 0, 490, 491, 0, 
	0, 0, 0, 0, 0, 492, 0, 0, 
	0, 0, 0, 491, 493, 494, 0, 495, 
	0, 496, 0, 0, 0, 0, 497, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	498, 0, 0, 0, 0, 0, 0, 0, 
	497, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 499, 
	500, 501, 7, 502, 88, 502, 503, 504, 
	0, 0, 0, 505, 0, 506, 0, 0, 
	0, 507, 508
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 96, 0, 
	96, 0, 0, 0, 0, 96, 96, 0, 
	0, 0, 0, 0, 96, 0, 96, 0, 
	96, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 97, 0, 
	97, 0, 0, 0, 0, 97, 97, 0, 
	0, 0, 0, 0, 97, 0, 97, 0, 
	97, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 45, 45, 45, 
	45, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 77, 
	77, 77, 77, 84, 84, 84, 84, 0, 
	0, 0, 0, 99, 101, 103, 103, 103, 
	108, 108, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 183, 185, 185, 185, 197, 
	197, 197, 205, 207, 207, 207, 207, 207, 
	213, 205, 205, 205, 205, 205, 205, 205, 
	240, 240, 240, 240, 240, 240, 205, 256, 
	205, 256, 240, 240, 205, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 205, 240, 240, 240, 240, 
	294, 294, 294, 299, 301, 301, 301, 305, 
	305, 308, 308, 308, 308, 313, 313, 313, 
	299, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 344, 349, 349, 353, 349, 353, 
	344, 0, 367, 368, 369, 371, 373, 375, 
	373, 373, 0, 385, 386, 390, 390, 391, 
	392, 401, 402, 403, 403, 403, 406, 406, 
	408, 409, 410, 410, 410, 412, 413, 414, 
	414, 410, 406, 406, 419, 420, 420, 420, 
	420, 420, 423, 423, 423, 423, 429, 430, 
	430, 430, 430, 438, 430, 430, 430, 430, 
	443, 430, 430, 430, 430, 430, 430, 449, 
	450, 451, 451, 0, 458, 462, 462, 463, 
	464, 473, 474, 475, 475, 475, 478, 478, 
	480, 481, 482, 482, 482, 484, 485, 486, 
	486, 482, 478, 478, 491, 492, 492, 492, 
	492, 492, 495, 495, 495, 495, 501, 502, 
	502, 502, 502, 510, 502, 502, 502, 502, 
	515, 502, 502, 502, 502, 502, 502, 521, 
	522, 523, 523, 0, 530, 531, 0, 537, 
	0, 544, 548, 548, 549, 0, 0, 558, 
	559, 563, 563, 564, 0, 569, 0, 572, 
	0, 575, 575, 576, 577, 0, 618, 620, 
	621, 622, 623, 625, 627, 631, 631, 622, 
	622, 622, 622, 633, 622, 622, 627, 622, 
	622, 618, 637, 637, 637, 637, 637, 637, 
	627, 627, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 676, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 622, 0, 719, 
	720, 721, 723, 719, 726, 0, 745, 747, 
	749, 750, 751, 752, 753, 755, 752, 752, 
	752, 752, 752, 758, 752, 752, 760, 758, 
	758, 752, 0, 779, 780, 108, 108, 783, 
	784, 108, 780, 780, 787, 789, 792, 780, 
	793, 780, 794, 795, 797, 799, 780, 787, 
	800, 800, 789, 800, 804, 800, 800, 800, 
	800, 0, 183, 812, 813, 812, 812, 0, 
	822, 823, 825, 827, 829, 827, 831, 0, 
	843, 844, 845, 846, 848, 850, 852, 853, 
	853, 853, 853, 853, 853, 853, 853, 853, 
	853, 853, 853, 853, 853, 853, 853, 0, 
	911, 914, 917, 918, 922, 924, 925, 926, 
	927, 928, 930, 933, 934, 936, 938, 941, 
	942, 944, 945, 205, 942, 947, 942, 933, 
	949, 933, 933, 967, 970, 972, 973, 977, 
	980, 981, 982, 983, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 987, 991, 
	993, 967, 967, 933, 998, 999, 999, 999, 
	933, 933, 933, 1000, 1007, 1007, 1009, 1011, 
	1020, 1021, 1022, 1022, 1022, 1025, 1025, 1027, 
	1028, 1029, 1029, 1029, 1031, 1032, 1033, 1033, 
	1029, 1025, 1025, 1038, 1039, 1039, 1039, 1039, 
	1039, 1042, 1042, 1042, 1042, 1048, 1049, 1049, 
	1049, 1049, 1057, 1049, 1049, 1049, 1049, 1063, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1049, 1049, 1081, 1082, 1083, 1083, 205, 
	933, 933, 1087, 933, 928, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	205, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 1140, 918, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 1165, 933, 0, 1173, 
	1174, 1175, 1177, 1179, 1181, 0, 1190, 1191, 
	1192, 1193, 1195, 1190, 1198, 0, 305, 1253, 
	1255, 1256, 1257, 1258, 1260, 1262, 1264, 1267, 
	1267, 305, 1269, 1271, 1272, 1273, 1269, 1275, 
	1277, 1277, 1280, 1280, 1283, 1294, 305, 1300, 
	1302, 1304, 1305, 1308, 1309, 1283, 1283, 1312, 
	1312, 1312, 1318, 1320, 1321, 1324, 1326, 1327, 
	1328, 1312, 1312, 1335, 1340, 1345, 1312, 1312, 
	1352, 1352, 1312, 1312, 1277, 1269, 1269, 1277, 
	1269, 1269, 1264, 305, 1370, 1371, 1371, 1371, 
	1371, 1371, 1371, 1377, 1264, 1380, 1381, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1421, 1422, 1382, 1382, 1426, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1480, 1258, 
	1481, 0, 1487, 1488, 1487, 1487, 1487, 0, 
	1494, 1494, 1494, 1494, 1498
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 185;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 194;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 251;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 307;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 310;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 312;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 317;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 318;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 324;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 326;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 328;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 333;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 446;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 453;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 474;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 505;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 511;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 519;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 543;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 766;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 773;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 781;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 961;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 967;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 185;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg, :context, :command_start

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # True at the end of "def foo a:"
    @in_kwarg      = false

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 10970 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 97 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 10998 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 117 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 59 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 63 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 304 then
# line 1252 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1533 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1549 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1577 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 70 then
# line 1769 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 343 then
# line 1861 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 346 then
# line 1862 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 354 then
# line 1882 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 383 then
# line 1971 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 302 then
# line 2052 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 470 then
# line 2238 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 464 then
# line 2239 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 467 then
# line 2240 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 461 then
# line 2241 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 476 then
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 438 then
# line 2243 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 453 then
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 446 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 443 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 88 then
# line 2490 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 113 then
# line 1085 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 109 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 108 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 115 then
# line 1027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 114 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 111 then
# line 998 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 112 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 881 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 857 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 142 then
# line 1085 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 139 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 138 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 144 then
# line 1027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 143 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 141 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 881 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 857 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 167 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 166 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 169 then
# line 998 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 170 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 172 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 182 then
# line 1085 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 179 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 178 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 184 then
# line 1027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 183 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 181 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 857 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 186 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 185 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 193 then
# line 1085 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 189 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 188 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 195 then
# line 1027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 194 then
# line 1011 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 191 then
# line 998 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 192 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 857 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 197 then
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 196 then
# line 857 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 199 then
# line 998 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 200 then
# line 1182 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 201 then
# line 1169 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 781;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1321 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 202 then
# line 1321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 204 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 203 then
# line 1344 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 225 then
# line 1365 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 211 then
# line 1373 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1377 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 781; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 208 then
# line 1386 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 220 then
# line 1390 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1396 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
       end
		end
	when 207 then
# line 1409 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 206 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 224 then
# line 1365 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 221 then
# line 1369 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 223 then
# line 1373 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 218 then
# line 1377 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 781; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 1386 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 219 then
# line 1393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 212 then
# line 1406 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 217 then
# line 1409 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1386 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1409 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 210 then
# line 1 "NONE"
		begin
	case  @act
	when 43 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 44 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 45 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1421 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 226 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 229 then
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 228 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1427 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 235 then
# line 1453 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 234 then
# line 1459 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 233 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 245 then
# line 1438 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 236 then
# line 1442 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 241 then
# line 1453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 239 then
# line 1456 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 244 then
# line 1459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 268 then
# line 1519 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 251 then
# line 1537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 257 then
# line 1561 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1569 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 259 then
# line 1578 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1589 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 246 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 247 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 258 then
# line 1528 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 254 then
# line 1550 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 256 then
# line 1566 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 250 then
# line 1589 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 249 then
# line 1594 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 267 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1594 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1603 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 71 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 72 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 77 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 272 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 273 then
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1639 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 84 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 85 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
 end
end 
			end
	when 283 then
# line 1675 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 276 then
# line 1681 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 277 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 278 then
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 281 then
# line 1681 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 287 then
# line 1705 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 295 then
# line 1697 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 289 then
# line 1699 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 293 then
# line 1705 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 288 then
# line 1 "NONE"
		begin
	case  @act
	when 92 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 93 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
 end
end 
			end
	when 56 then
# line 1720 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 328 then
# line 1737 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 320 then
# line 1744 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 54 then
# line 1751 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 341 then
# line 1826 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 333
		_goto_level = _again
		next
	end

       end
		end
	when 329 then
# line 1834 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 340 then
# line 1842 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 68 then
# line 1856 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 351 then
# line 1897 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 350 then
# line 1907 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 330 then
# line 1966 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 51 then
# line 1987 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 781;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 766;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 327 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 27
          emit(:tBDOT3)
        else
          emit(:tDOT3)
        end

         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 2054 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 446;
        else
           @cs = 505;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 2073 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 298 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 325 then
# line 1720 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 324 then
# line 1727 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 321 then
# line 1751 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 319 then
# line 1757 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 348 then
# line 1817 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 331 then
# line 1856 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 344 then
# line 1864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 349 then
# line 1907 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 355 then
# line 1913 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 322 then
# line 1966 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 326 then
# line 2014 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 301 then
# line 1306 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 311 then
# line 2070 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 313 then
# line 2073 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 316 then
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 53 then
# line 1757 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 72 then
# line 1817 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 73 then
# line 1884 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 47 then
# line 1306 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 52 then
# line 2070 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 67 then
# line 2089 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1 "NONE"
		begin
	case  @act
	when 98 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 105 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 116 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
      end
	when 120 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 121 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 126 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 131 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
end 
			end
	when 386 then
# line 2109 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 387 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 388 then
# line 2097 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 392 then
# line 2109 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 76 then
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 2124 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 395 then
# line 2134 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 394 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 398 then
# line 2128 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 397 then
# line 2134 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 75 then
# line 2134 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 431 then
# line 2145 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 85 then
# line 2186 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 406 then
# line 2322 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 78 then
# line 2340 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 427 then
# line 2347 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 480 then
# line 2371 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 420 then
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 425 then
# line 2415 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 411 then
# line 2419 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 408 then
# line 2438 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 410 then
# line 2451 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 485 then
# line 2455 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 405 then
# line 2461 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 404 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 496 then
# line 2182 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 494 then
# line 2186 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 493 then
# line 2197 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 435 then
# line 2272 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 482 then
# line 2332 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 424 then
# line 2340 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 432 then
# line 2347 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 488 then
# line 1306 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 430 then
# line 2371 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 426 then
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 419 then
# line 2386 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 433 then
# line 2438 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 417 then
# line 2445 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 423 then
# line 2461 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 83 then
# line 2245 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 79 then
# line 2272 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 82 then
# line 2304 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 77 then
# line 2461 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 80 then
# line 1 "NONE"
		begin
	case  @act
	when 144 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 151 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 153 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 155 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 159 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 163 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 164 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 166 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 95 then
# line 2491 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 501 then
# line 2494 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 504 then
# line 2477 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 503 then
# line 2494 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 90 then
# line 2477 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 86 then
# line 2494 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 92 then
# line 1 "NONE"
		begin
	case  @act
	when 180 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 182 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 507 then
# line 2504 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 506 then
# line 2512 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 106 then
# line 2522 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2526 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 98 then
# line 2529 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 99 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 100 then
# line 2519 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 105 then
# line 2522 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 104 then
# line 2529 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2529 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 66 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 110 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 140 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 168 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 187 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 190 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 198 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 269 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1519 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 260 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1578 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 252 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1589 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 352 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1897 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 315 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2073 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 434 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 508 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2504 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 505 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2509 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 107 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2522 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2526 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 456 then
# line 626 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 454 then
# line 627 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 459 then
# line 628 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 457 then
# line 629 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 455 then
# line 630 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 458 then
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 447 then
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 448 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 449 then
# line 640 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 451 then
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 450 then
# line 642 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 134 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 162 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 373 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 146 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 357 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 360 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 362 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 359 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 137 then
# line 742 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 165 then
# line 742 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 376 then
# line 742 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 136 then
# line 746 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 164 then
# line 746 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 375 then
# line 746 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 131 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 370 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 130 then
# line 756 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 158 then
# line 756 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 369 then
# line 756 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 135 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 163 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 374 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 132 then
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 160 then
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 371 then
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 147 then
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 358 then
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 171 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 176 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 57 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1533 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1549 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1577 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 213 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1406 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 232 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 240 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1456 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1589 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 271 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1594 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 263 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1600 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 282 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 294 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1699 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 290 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1702 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 58 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1720 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2054 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 446;
        else
           @cs = 505;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 312 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2070 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 393 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2097 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 389 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2100 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

      end
     end
		end
	when 402 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2128 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 399 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2131 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 185
		_goto_level = _again
		next
	end
  end
		end
	when 486 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2445 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 418 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2448 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 961
		_goto_level = _again
		next
	end
  end
		end
	when 101 then
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2519 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 262 then
# line 1050 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1500 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 284 then
# line 1050 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1662 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 384 then
# line 1050 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1942 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 499 then
# line 1050 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2153 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 500 then
# line 1059 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end

    @paren_nest -= 1
  		end
# line 2390 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 60 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 64 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 216 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1406 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 231 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1456 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 265 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1597 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 280 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 292 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1699 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 318 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2070 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 391 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2097 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2128 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 422 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2445 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 103 then
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2519 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 237 then
# line 1252 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1446 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 332 then
# line 1252 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 303 then
# line 1252 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 415 then
# line 1252 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 144 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 151 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 153 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 155 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 159 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 163 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 164 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 166 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 238 then
# line 1253 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1446 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 333 then
# line 1253 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 305 then
# line 1253 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 416 then
# line 1253 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2354 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 334 then
# line 1258 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 306 then
# line 1258 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 335 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 307 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 339 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 310 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 338 then
# line 1261 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 309 then
# line 1261 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 98 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 105 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 116 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
      end
	when 120 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 121 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 126 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 131 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
end 
			end
	when 336 then
# line 1262 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 308 then
# line 1262 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 337 then
# line 1267 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 481 then
# line 1272 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2336 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 261 then
# line 1278 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1494 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 377 then
# line 1278 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1956 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 484 then
# line 1278 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2423 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 487 then
# line 1284 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2390 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 253 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1475 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 266 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1488 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 274 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1616 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 323 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1961 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 428 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2386 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 429 then
# line 1301 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2390 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 71 then
# line 1769 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 347 then
# line 1770 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1771 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 342 then
# line 1861 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
# line 1864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 345 then
# line 1862 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
# line 1864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 353 then
# line 1882 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 380 then
# line 1971 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1972 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 471 then
# line 2238 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 465 then
# line 2239 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 468 then
# line 2240 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 462 then
# line 2241 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 477 then
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 440 then
# line 2243 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 478 then
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 89 then
# line 2490 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2491 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 444 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 222 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1365 "lib/parser/lexer.rl"
		begin
 @act = 43;		end
	when 209 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1369 "lib/parser/lexer.rl"
		begin
 @act = 44;		end
	when 205 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1373 "lib/parser/lexer.rl"
		begin
 @act = 45;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1537 "lib/parser/lexer.rl"
		begin
 @act = 71;		end
	when 255 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1550 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1589 "lib/parser/lexer.rl"
		begin
 @act = 77;		end
	when 248 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1594 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 275 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @act = 84;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 296 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1693 "lib/parser/lexer.rl"
		begin
 @act = 92;		end
	when 285 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1697 "lib/parser/lexer.rl"
		begin
 @act = 93;		end
	when 69 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1817 "lib/parser/lexer.rl"
		begin
 @act = 105;		end
	when 385 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 299 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1966 "lib/parser/lexer.rl"
		begin
 @act = 120;		end
	when 379 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1972 "lib/parser/lexer.rl"
		begin
 @act = 121;		end
	when 378 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1978 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 74 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @act = 126;		end
	when 297 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1306 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 300 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @act = 131;		end
	when 495 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2153 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 490 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2182 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 498 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2192 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 491 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2197 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 492 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 497 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2206 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 489 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2217 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 483 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2231 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 409 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 442 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2289 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 81 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 412 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2332 "lib/parser/lexer.rl"
		begin
 @act = 159;		end
	when 403 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1306 "lib/parser/lexer.rl"
		begin
 @act = 163;		end
	when 414 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2354 "lib/parser/lexer.rl"
		begin
 @act = 164;		end
	when 407 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @act = 166;		end
	when 413 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2386 "lib/parser/lexer.rl"
		begin
 @act = 167;		end
	when 87 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2477 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 502 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2494 "lib/parser/lexer.rl"
		begin
 @act = 182;		end
	when 177 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 124 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 363 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 157 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 368 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 361 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 367 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 365 then
# line 731 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 133 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 161 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 372 then
# line 762 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 776 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 145 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 356 then
# line 808 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 802 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 215 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1406 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 230 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 242 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1456 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 264 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1597 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 279 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 291 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1699 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 317 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2070 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 390 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2097 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 400 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2128 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 421 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2445 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 102 then
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2519 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 473 then
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 437 then
# line 2243 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 452 then
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 441 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 270 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1594 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1589 "lib/parser/lexer.rl"
		begin
 @act = 77;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 94 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2477 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 65 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1720 "lib/parser/lexer.rl"
		begin
 @act = 98;		end
	when 84 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2186 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 93 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2477 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1549 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1550 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 382 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1971 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2043 "lib/parser/lexer.rl"
		begin
 @act = 126;		end
	when 381 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1971 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1306 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 474 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 127 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 366 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 881 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 364 then
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 716 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 469 then
# line 2238 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 463 then
# line 2239 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 466 then
# line 2240 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 2241 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 472 then
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 436 then
# line 2243 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 848 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1549 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1550 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1720 "lib/parser/lexer.rl"
		begin
 @act = 98;		end
	when 91 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1208 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1211 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2477 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 479 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2277 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 475 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2242 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2277 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 439 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2243 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2244 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2277 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
# line 23498 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 96 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 23508 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 284 "lib/parser/lexer.rl"
    # %

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2534 "lib/parser/lexer.rl"

  # %
end
