// Generated by CoffeeScript 1.3.3
(function() {
  var initialize, initialize_taurus, taurus_element, taurus_models, taurus_websocket;

  taurus_websocket = null;

  taurus_models = function() {
    var elem, _i, _len, _ref, _results;
    _ref = $('[data-taurus-model]');
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      elem = _ref[_i];
      _results.push(elem.dataset['taurusModel']);
    }
    return _results;
  };

  taurus_element = function(model) {
    return $('[data-taurus-model="' + model + '"]');
  };

  initialize = function() {
    var CircularLinearGauge, dom, gauge, gauge_props, geonext, plot, props;
    console.log("Initializing page...");
    $('title').html(':: Taurus ::');
    gauge_props = {
      interactionArea: "none",
      minimum: -140,
      maximum: 150
    };
    dom = require("dojo/dom");
    CircularLinearGauge = require("dojox/dgauges/components/default/CircularLinearGauge");
    gauge = new CircularLinearGauge(gauge_props, dom.byId("gauge01"));
    gauge.set('value', 44);
    taurus_websocket = new WebSocket("ws://pc151.cells.es:8888/taurus");
    taurus_websocket.onopen = function() {
      $('title').html(':: Taurus :: Connected');
      return initialize_taurus();
    };
    taurus_websocket.onmessage = function(event) {
      var elements, event_data, g, indicatorText;
      event_data = JSON.parse(event.data);
      elements = taurus_element(event_data.model);
      elements.filter(":not([data-taurus-controller = 'Gauge'])").css(event_data.css).html(event_data.html);
      elements.filter("input").css('background-color', '').css('color', '');
      g = elements.filter("#gauge01");
      if (g.length && gauge) {
        indicatorText = gauge.getElement("indicatorText");
        indicatorText.set('value', event_data.html);
        return indicatorText.indicator.set('value', event_data.html);
      }
    };
    taurus_websocket.onerror = function(event) {
      return $('body').append('<div>Error:' + event + ' ' + '</div>');
    };
    taurus_websocket.onclose = function(event) {
      return $('title').html(':: Taurus :: Disconnected');
    };
    plot = JXG.JSXGraph.initBoard('plot', {
      boundingbox: [-10, 10, 10, -10],
      axis: true,
      grid: true
    });
    geonext = JXG.JSXGraph.loadBoardFromFile('geonext', 'static/geonext/triangle.gxt', 'Geonext');
    props = {
      position: ["right", "bottom"],
      width: 460
    };
    $('#motor-attributes').dialog(props);
    $("#tangotest-attributes").hide();
    $('#show-tangotest').button().click(function() {
      return $('#tangotest-attributes').show('bounce', {}, 500, function() {});
    });
    return console.log("Finished initializing page");
  };

  initialize_taurus = function() {
    var json_models, models;
    console.log("Initializing taurus...");
    models = taurus_models();
    json_models = JSON.stringify({
      models: models
    });
    taurus_websocket.send(json_models);
    return console.log("Finished initializing taurus");
  };

  $(function() {
    var dojo_requirements;
    dojo_requirements = ["dojo/_base/kernel", "dojo/parser", "dojo/dom", "dojox/dgauges/components/default/CircularLinearGauge"];
    return require(dojo_requirements, initialize);
  });

}).call(this);
