from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CONF = _Mock()

SIGNAL = _Mock()

_ = _Mock()

builtins = _Mock()

create_action = _Mock()

create_banner = _Mock()

get_conf_path = _Mock()

get_error_match = _Mock()

get_std_icon = _Mock()

get_versions = _Mock()

getargtxt = _Mock()

getcwd = _Mock()

getdoc = _Mock()

getobjdir = _Mock()

getsource = _Mock()

oedit = _Mock()

os = _Mock()

threading = _Mock()

time = _Mock()

to_binary_string = _Mock()

to_text_string = _Mock()

u = _Mock()

DEBUG = 0

class InternalShell(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoWrap = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  SEPARATOR = '\n\n##---(Tue Mar 10 11:03:54 2015)---'
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WidgetWidth = 1
  WinPanel = 3

class Interpreter(_Mock):
  pass
  _Thread__initialized = False
  p1 = '>>> '
  p2 = '... '

class Popen(_Mock):
  pass
  _child_created = False

class PythonShellWidget(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoWrap = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  SEPARATOR = '\n\n##---(Tue Mar 10 11:03:54 2015)---'
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WidgetWidth = 1
  WinPanel = 3

class QEventLoop(_Mock):
  pass
  AllEvents = 0
  DeferredDeletion = 16
  ExcludeSocketNotifiers = 2
  ExcludeUserInputEvents = 1
  WaitForMoreEvents = 4
  X11ExcludeTimers = 8

class QMessageBox(_Mock):
  pass
  Abort = 262144
  AcceptRole = 0
  Accepted = 1
  ActionRole = 3
  Apply = 33554432
  ApplyRole = 8
  ButtonMask = -769
  Cancel = 4194304
  Close = 2097152
  Critical = 3
  Default = 256
  DestructiveRole = 2
  Discard = 8388608
  DrawChildren = 2
  DrawWindowBackground = 1
  Escape = 512
  FirstButton = 1024
  FlagMask = 768
  Help = 16777216
  HelpRole = 4
  Ignore = 1048576
  IgnoreMask = 4
  Information = 1
  InvalidRole = -1
  LastButton = 134217728
  No = 65536
  NoAll = 131072
  NoButton = 0
  NoIcon = 0
  NoRole = 6
  NoToAll = 131072
  Ok = 1024
  Open = 8192
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Question = 4
  RejectRole = 1
  Rejected = 0
  Reset = 67108864
  ResetRole = 7
  RestoreDefaults = 134217728
  Retry = 524288
  Save = 2048
  SaveAll = 4096
  Warning = 2
  Yes = 16384
  YesAll = 32768
  YesRole = 5
  YesToAll = 32768

class QObject(_Mock):
  pass


class SysOutput(_Mock):
  pass


class WidgetProxy(_Mock):
  pass


class WidgetProxyData(_Mock):
  pass


