/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef UKUITASKBUTTON_H
#define UKUITASKBUTTON_H

#include <QObject>
#include <QToolButton>
#include <QGSettings>
#include <QAction>
#include <QStyleOption>
#include <QPainter>
#include <QMouseEvent>
#include <QMenu>
#include <QVariant>
#include <QApplication>
#include <QDesktopWidget>
#include <QtX11Extras/QX11Info>
#include "../panel/xdg-desktop-file/xdgdesktopfile.h"
#include <QtDBus>
#include <QPropertyAnimation>

#include <windowmanager/windowmanager.h>
#include "../panel/customstyle.h"

using namespace kdk;

class UKUITaskButton : public QToolButton
{
    Q_OBJECT
    Q_PROPERTY(int opacity READ opacity WRITE setOpacity)

public:
    UKUITaskButton(const WindowId window, const QString desktopFile, QWidget *parent = nullptr);
    virtual ~UKUITaskButton();

    enum PanelPosition{
        Bottom = 0, //!< The bottom side of the screen.
        Top,    //!< The top side of the screen.
        Left,   //!< The left side of the screen.
        Right   //!< The right side of the screen.
    };


    WindowId windowId() const;
    QString desktopFileName();
    void setDesktopFileName(QString desktopFileName);
    void updateIcon();
    void updateCaption();
    bool isLeaderWindow();
    bool isActiveWindow();
    bool isOnCurrentDesktop();
    void refreshIconGeometry();
    void activeWindow();
    void minimizeWindow();
    void closeWindow();
    void quickLaunchAction();
    void execAction(QString additionalAction = QString{});
    void getAdditionalActions();
    void rightMenuCloseAction(QMenu *menu, QPoint pos);
    QRect caculateMenuPosition(QPoint const & absolutePos, QSize const & windowSize);
    bool isHorizontalPanel();
    void setSystemStyle();

    bool hasUrgencyHint() const { return m_urgencyHint; }
    void setUrgencyHint(bool set);

    bool m_isDemandingAttention = false;
    QPropertyAnimation *m_hightlightAnimation = NULL;

    void setOpacity(int alpha);
    int opacity() const;
    int m_alpha;
    CustomStyle *m_opacityStyle = NULL;

Q_SIGNALS:
    void pinToTaskbar(QString desktopFile);
    void unPinFromTaskbar(QString desktopFile);
    void closeGroup();
    void enterButton(QList<WindowId>winIdList, QString groupName, int x, int y);
    void leaveButton(QList<WindowId>winIdList, QString groupName, int x, int y);

public Q_SLOTS:
    void onButtonsCountChanged(int buttonsCount);
    void onButtonsStatusChanged(bool isPinned);
    void onWindowChanged(WId id, NET::Properties properties, NET::Properties2 properties2);

protected:
    void paintEvent(QPaintEvent *e) override;
    void enterEvent(QEvent *e) override;
    void leaveEvent(QEvent *e) override;
    void contextMenuEvent(QContextMenuEvent *e) override;

    void mouseReleaseEvent(QMouseEvent *e) override;
    void mousePressEvent(QMouseEvent *event) override;

private:
    WindowId m_windowId;
    QString m_desktopFileName;
    QIcon m_icon;
    QString m_caption;
    std::unique_ptr<QGSettings> m_styleGsettings;
    std::unique_ptr<QGSettings> m_gsettings;
    QStringList m_gsettingKeys;
    std::unique_ptr<QAction> m_act;
    QList<QAction *> m_additionalActionsList;
    QObject *m_parent = nullptr;
    int m_panelPosition = 0;
    int m_panelSize = 46;
    bool m_isDemandAttention = false;
    bool m_isGrouping = true;
    int m_iconSize = 32;
    int m_buttonsCount = 0;
    bool m_isPinned = false;
    bool m_urgencyHint = false;
    enum TaskButtonEvent {ENTEREVENT, LEAVEEVENT, OTHEREVENT};
    TaskButtonEvent  m_taskBtnEvent;
    QTimer *m_timer;


    void timeToEmit();

};








#endif // UKUITASKBUTTON_H
