/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class IO {
    InputStream in = null;
    OutputStream out = null;
    byte[] inbuffer = new byte[1024];
    byte[] outbuffer = new byte[1024];
    int instart = 0;
    int inend = 0;
    int outindex = 0;
    int inrest = 0;
    byte[] ba = new byte[1];
    byte[] sa = new byte[2];
    byte[] ia = new byte[8];

    IO() {
    }

    abstract int readShort() throws IOException;

    abstract int readInt() throws IOException;

    abstract void writeShort(int var1) throws IOException;

    abstract void writeInt(int var1) throws IOException;

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    int available() throws IOException {
        if (0 < this.inrest) {
            return 1;
        }
        return this.in.available();
    }

    int readByte() throws IOException {
        if (this.inrest < 1) {
            this.read(1);
        }
        --this.inrest;
        return this.inbuffer[this.instart++] & 0xFF;
    }

    void readByte(byte[] byArray) throws IOException {
        this.readByte(byArray, 0, byArray.length);
    }

    void readByte(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while ((n3 = this.inrest) < n2) {
            if (n3 != 0) {
                System.arraycopy(this.inbuffer, this.instart, byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.instart += n3;
                this.inrest -= n3;
            }
            this.read(n2);
        }
        System.arraycopy(this.inbuffer, this.instart, byArray, n, n2);
        this.instart += n2;
        this.inrest -= n2;
    }

    void readPad(int n) throws IOException {
        while (n > 0) {
            if (this.inrest < n) {
                this.instart += this.inrest;
                this.inrest = 0;
                this.read(n -= this.inrest);
                continue;
            }
            this.instart += n;
            this.inrest -= n;
            break;
        }
    }

    protected final void read(int n) throws IOException {
        if (n > this.inbuffer.length) {
            n = this.inbuffer.length;
        }
        this.inend = 0;
        this.instart = 0;
        do {
            int n2;
            if ((n2 = this.in.read(this.inbuffer, this.inend, this.inbuffer.length - this.inend)) == -1) {
                throw new IOException();
            }
            this.inend += n2;
        } while (n > this.inend);
        this.inrest = this.inend - this.instart;
    }

    void writeByte(byte by) throws IOException {
        if (this.outbuffer.length - this.outindex < 1) {
            this.flush();
        }
        this.outbuffer[this.outindex++] = by;
    }

    void writeByte(int n) throws IOException {
        this.writeByte((byte)n);
    }

    void writeByte(byte[] byArray) throws IOException {
        this.writeByte(byArray, 0, byArray.length);
    }

    void writeByte(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        while ((n3 = this.outbuffer.length - this.outindex) < n2) {
            if (n3 != 0) {
                System.arraycopy(byArray, n, this.outbuffer, this.outindex, n3);
                n += n3;
                n2 -= n3;
                this.outindex += n3;
            }
            this.flush();
        }
        System.arraycopy(byArray, n, this.outbuffer, this.outindex, n2);
        this.outindex += n2;
    }

    void writePad(int n) throws IOException {
        int n2;
        while ((n2 = this.outbuffer.length - this.outindex) < n) {
            if (n2 != 0) {
                this.outindex += n2;
                n -= n2;
            }
            this.flush();
        }
        this.outindex += n;
    }

    synchronized void flush() throws IOException {
        if (this.outindex == 0) {
            return;
        }
        this.out.write(this.outbuffer, 0, this.outindex);
        this.outindex = 0;
    }

    synchronized void immediateWrite(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    void close() throws IOException {
        this.in.close();
        this.out.close();
    }
}

