#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
from winswitch.util.config import get_local_server_config
from winswitch.util.file_io import get_local_server_config_filename, load_properties, populate_object_from_properties

logger=Logger("config_test", log_colour=Logger.RED, _debug=True)

def test_get_local_server_config():
	# load properties
	filename = get_local_server_config_filename(False)
	props = load_properties(filename)
	logger.log("properties(%s)=%s" % (filename, props))
	for v in ["debug_mode"]:
		option = props.get(v)
		assert option, "could not find %s in properties from %s" % (v, filename)
	config = get_local_server_config()
	assert config

def test_populate_dict():
	props = {'dict["a"]' : "1",
			'boolean' : "True",
			"int" : 1,
			"not_persisted" : "abc"}
	t = test_dict()
	populate_object_from_properties(props, t, test_dict)
	assert t.not_persisted is None
	assert t.boolean is True
	assert t.int is 1
	assert len(t.dict)>0
	logger.log("test_populate_dict() dict=%s" % t.dict)

class test_dict():
	PERSIST = ["dict", "boolean", "int"]
	def __init__(self):
		self.dict = {}
		self.boolean = False
		self.int = 0
		self.not_persisted = None

def main():
	test_populate_dict()
	test_get_local_server_config()


if __name__ == "__main__":
	main()