#import <Cocoa/Cocoa.h>
#include <AppKit/NSPasteboard.h>

#include "fssimplewindow.h"

void FsChangeToProgramDirC()
{
	NSString *path;
	path = [[NSBundle mainBundle] bundlePath];
	printf("BundlePath:%s\n",[path UTF8String]);

	[[NSFileManager defaultManager] changeCurrentDirectoryPath:path];
}

void FsGetAppDataDirC(char *o_szPath, int iLength, const char *szOverrideBundleId)
{
	NSError *error;
	NSFileManager *manager = [NSFileManager defaultManager];
	NSURL *applicationSupport = [manager URLForDirectory:NSApplicationSupportDirectory inDomain:NSUserDomainMask appropriateForURL:nil create:false error:&error];
	NSString *identifier = [[NSBundle mainBundle] bundleIdentifier];
	if(szOverrideBundleId != nil) identifier = [[NSString alloc] initWithCString:szOverrideBundleId encoding:NSUTF8StringEncoding];
	NSURL *folder = [applicationSupport URLByAppendingPathComponent:identifier];
	[manager createDirectoryAtURL:folder withIntermediateDirectories:true attributes:nil error:&error];

	NSString* file = [folder path];
	[file getCString:o_szPath maxLength:iLength encoding:NSUTF8StringEncoding];
}

bool FsFileOpenDialogC(char *szPath, int iLength, struct file_dialog_info *pFI)
{
	bool bResult = false;
	NSOpenPanel *dlg = [NSOpenPanel openPanel];
	NSURL *path = [NSURL fileURLWithPath:[NSString stringWithCString:pFI->szStartPath encoding:NSUTF8StringEncoding]];

	NSMutableArray *filters = [NSMutableArray arrayWithCapacity:pFI->iNumFilters];
	int i;
	for(i=0; i<pFI->iNumFilters; i++) {
		NSString *filter = [NSString stringWithCString:pFI->szFilters[i] encoding:NSUTF8StringEncoding];
		[filters addObject:filter];
	}

	[dlg setCanChooseFiles:YES];
	[dlg setCanChooseDirectories:NO];
	[dlg setDirectoryURL:path];
	[dlg setAllowedFileTypes:filters];

	//display the dialog and wait for OK
	if([dlg runModal] == NSOKButton) {
		NSString* file = [[dlg URL] path];
		[file getCString:szPath maxLength:iLength encoding:NSUTF8StringEncoding];
		bResult = true;
	}
	[dlg release];
	[path release];
	return bResult;
}

bool FsFileSaveDialogC(char *szPath, int iLength, struct file_dialog_info *pFI)
{
	bool bResult = false;
	NSSavePanel *dlg = [NSSavePanel savePanel];
	NSURL *path = [NSURL fileURLWithPath:[NSString stringWithCString:pFI->szStartPath encoding:NSUTF8StringEncoding]];

	NSMutableArray *filters = [NSMutableArray arrayWithCapacity:pFI->iNumFilters];
	int i;
	for(i=0; i<pFI->iNumFilters; i++) {
		NSString *filter = [NSString stringWithCString:pFI->szFilters[i] encoding:NSUTF8StringEncoding];
		[filters addObject:filter];
	}

	[dlg setDirectoryURL:path];
	[dlg setAllowedFileTypes:filters];

	//display the dialog and wait for OK
	if([dlg runModal] == NSOKButton) {
		NSString* file = [[dlg URL] path];
		[file getCString:szPath maxLength:iLength encoding:NSUTF8StringEncoding];
		bResult = true;
	}
	[dlg release];
	[path release];
	return bResult;
}


bool FsGetClipboardTextC(char *szText, int iLength)
{
	bool bResult = false;
	NSPasteboard* pb = [NSPasteboard generalPasteboard];
	NSString *string = [pb stringForType:NSStringPboardType];

	if(string) {
		[string getCString:szText maxLength:iLength encoding:NSUTF8StringEncoding];
		bResult = true;
	}
	return bResult;
}

int FsMessageBoxC(char* szHeader, char* szMessage)
{
	//convert the strings from char* to CFStringRef
	CFStringRef header_ref      = CFStringCreateWithCString( NULL, szHeader,     strlen(szHeader)    );
	CFStringRef message_ref  = CFStringCreateWithCString( NULL, szMessage,  strlen(szMessage) );
	
	CFOptionFlags result;  //result code from the message box
	
	//launch the message box
	CFUserNotificationDisplayAlert(
		0, // no timeout
		kCFUserNotificationNoteAlertLevel, //change it depending message_type flags ( MB_ICONASTERISK.... etc.)
		NULL, //icon url, use default, you can change it depending message_type flags
		NULL, //not used
		NULL, //localization of strings
		header_ref, //header text
		message_ref, //message text
		NULL, //default "ok" text in button
		CFSTR("Cancel"), //alternate button title
		NULL, //other button title, null--> no other button
		&result //response flags
		);
	
	//clean up the strings
	CFRelease( header_ref );
	CFRelease( message_ref );
	
	//convert the result
	if( result == kCFUserNotificationDefaultResponse )
		return 0;
	else
		return 1;
}
