let version = "1.0.8-00205-gd3d29c86"

let rec realpath path =
  if path = "/" || path = "." then
    path
  else
    begin
      let dirname = Filename.dirname path in
      let new_dirname = realpath dirname in
      let new_path =
        if dirname == new_dirname then path
        else Filename.concat new_dirname (Filename.basename path) in
      let rec follow new_path =
        match
          try Some (Unix.readlink new_path) with Unix.Unix_error _ -> None
        with
        | None -> new_path
        | Some target ->
            let new_path =
              if Filename.is_relative target then
                Filename.concat (Filename.dirname new_path) target
              else
                target in
            follow new_path in
      follow new_path
    end

let path =
  try (Sys.getenv "COCCINELLE_HOME")
  with Not_found->
    (* was "${exec_prefix}/lib/coccinelle": incorrect, since "${exec_prefix}/lib" expands into
       "${exec_prefix}/lib" (litteraly, without further expansion, that is
       unlikely to be a valid path! *)
    let exec_realpath = realpath Sys.executable_name in
    let exec_dir = Filename.dirname exec_realpath in
    if Sys.file_exists (Filename.concat exec_dir "standard.iso") then
      exec_dir
    else
      List.fold_left Filename.concat exec_dir
	[Filename.parent_dir_name; "lib"; "coccinelle"]


let std_iso = ref (Filename.concat path "standard.iso")
let std_h   = ref (Filename.concat path "standard.h")

let dynlink_is_native = Dynlink.is_native
let get_temp_dir_name = (Filename.get_temp_dir_name ())

let configure_flags = ""
let ocaml_version = "4.09.0"

let python_interpreter = ref "python"
