/* SPDX-License-Identifier: GPL-2.0-only */

#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NATIVE, DEEP, NF1),	// ESPI_IO0
	PAD_CFG_NF(GPP_A1, NATIVE, DEEP, NF1),	// ESPI_IO1
	PAD_CFG_NF(GPP_A2, NATIVE, DEEP, NF1),	// ESPI_IO2
	PAD_CFG_NF(GPP_A3, NATIVE, DEEP, NF1),	// ESPI_IO3
	PAD_CFG_NF(GPP_A4, NATIVE, DEEP, NF1),	// ESPI_CS0#
	PAD_CFG_NF(GPP_A5, NATIVE, DEEP, NF1),	// ESPI_CLK
	PAD_CFG_NF(GPP_A6, NATIVE, DEEP, NF1),	// ESPI_RESET#
	PAD_CFG_NF(GPP_A7, NATIVE, DEEP, NF1),	// ESPI_CS1#
	PAD_CFG_NF(GPP_A8, UP_20K, DEEP, NF1),	// ESPI_CS2#
	PAD_CFG_NF(GPP_A9, UP_20K, DEEP, NF1),	// ESPI_CS3#
	PAD_CFG_NF(GPP_A10, UP_20K, DEEP, NF1),	// ESPI_ALERT0#
	PAD_CFG_NF(GPP_A11, UP_20K, DEEP, NF1),	// ESPI_ALERT1#
	PAD_CFG_NF(GPP_A12, UP_20K, DEEP, NF1),	// ESPI_ALERT2#
	PAD_CFG_NF(GPP_A13, DN_20K, DEEP, NF1),	// ESPI_ALERT3#
	_PAD_CFG_STRUCT(GPP_A14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),	// HDA_BITCLK
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),	// HDA_SYNC
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1),	// HDA_SDOUT
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),	// HDA_SDIN0
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),	// HDA_RST#
	PAD_NC(GPP_R5, NONE),
	_PAD_CFG_STRUCT(GPP_R6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	_PAD_CFG_STRUCT(GPP_R7, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	_PAD_CFG_STRUCT(GPP_R8, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	PAD_CFG_NF(GPP_R9, NATIVE, DEEP, NF1),	// PCIE_LNK_DOWN
	PAD_CFG_NF(GPP_R10, NATIVE, DEEP, NF1),	// ISH_UART0_RTS#
	PAD_CFG_NF(GPP_R11, NATIVE, DEEP, NF1),	// SX_EXIT_HOLDOFF#
	_PAD_CFG_STRUCT(GPP_R12, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CLKOUT_48 */
	_PAD_CFG_STRUCT(GPP_R13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* ISH_GP7 */
	PAD_NC(GPP_R14, NONE),
	PAD_NC(GPP_R15, NONE),
	PAD_NC(GPP_R16, NONE),
	PAD_NC(GPP_R17, NONE),
	PAD_CFG_GPO(GPP_R18, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_R19, NONE),

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_GPO(GPP_B0, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_B1, NONE),
	PAD_NC(GPP_B2, NONE),
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_NC(GPP_B7, NONE),
	PAD_CFG_NF(GPP_B8, NONE, DEEP, NF1),	// SRCCLKREQ3
	PAD_NC(GPP_B9, NONE),
	PAD_NC(GPP_B10, NONE),
	PAD_CFG_GPO(GPP_B11, 1, DEEP),	/* GPIO */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	// SLP_S0#
	PAD_NC(GPP_B13, NONE),
	PAD_NC(GPP_B14, NONE),
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_NC(GPP_B18, NONE),
	PAD_NC(GPP_B19, NONE),
	_PAD_CFG_STRUCT(GPP_B20, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* GSPI1_CLK */
	_PAD_CFG_STRUCT(GPP_B21, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* GSPI1_MISO */
	_PAD_CFG_STRUCT(GPP_B22, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* GSPI1_MOSI */
	PAD_CFG_GPO(GPP_B23, 1, PLTRST),	/* GPIO */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	_PAD_CFG_STRUCT(GPP_D4, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML1CLK */
	_PAD_CFG_STRUCT(GPP_D5, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_RF_RESET# */
	_PAD_CFG_STRUCT(GPP_D6, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* MODEM_CLKREQ */
	PAD_NC(GPP_D7, NONE),
	PAD_NC(GPP_D8, NONE),
	_PAD_CFG_STRUCT(GPP_D9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML0CLK */
	_PAD_CFG_STRUCT(GPP_D10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML0DATA */
	PAD_CFG_GPO(GPP_D11, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_D12, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	_PAD_CFG_STRUCT(GPP_D15, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML1DATA */
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),
	PAD_NC(GPP_D20, NONE),
	PAD_NC(GPP_D21, NONE),
	PAD_NC(GPP_D22, NONE),
	PAD_NC(GPP_D23, NONE),

	/* ------- GPIO Group GPP_C ------- */
	_PAD_CFG_STRUCT(GPP_C0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SMBCLK */
	_PAD_CFG_STRUCT(GPP_C1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SMBDATA */
	PAD_CFG_GPO(GPP_C2, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_C3, PAD_FUNC(NF3) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* I2C2_SDA */
	_PAD_CFG_STRUCT(GPP_C4, PAD_FUNC(NF3) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* I2C2_SCL */
	PAD_CFG_GPO(GPP_C5, 0, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_C6, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C3_SDA */
	_PAD_CFG_STRUCT(GPP_C7, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C3_SCL */
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_CFG_GPO(GPP_C12, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_C13, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_C14, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_C15, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_C16, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C0_SDA */
	_PAD_CFG_STRUCT(GPP_C17, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C0_SCL */
	_PAD_CFG_STRUCT(GPP_C18, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C1_SDA */
	_PAD_CFG_STRUCT(GPP_C19, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* I2C1_SCL */
	PAD_NC(GPP_C20, NONE),
	PAD_NC(GPP_C21, NONE),
	PAD_NC(GPP_C22, NONE),
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_S ------- */
	_PAD_CFG_STRUCT(GPP_S0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SNDW1_CLK */
	_PAD_CFG_STRUCT(GPP_S1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SNDW1_DATA */
	_PAD_CFG_STRUCT(GPP_S2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SNDW2_CLK */
	_PAD_CFG_STRUCT(GPP_S3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SNDW2_DATA */
	_PAD_CFG_STRUCT(GPP_S4, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DMIC_CLKA1 */
	_PAD_CFG_STRUCT(GPP_S5, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DMIC_DATA1 */
	_PAD_CFG_STRUCT(GPP_S6, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DMIC_CLKA0 */
	_PAD_CFG_STRUCT(GPP_S7, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DMIC_DATA0 */

	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, NONE),
	PAD_CFG_GPO(GPP_G1, 0, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G2, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G3, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G4, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_G5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SLP_DRAM# */
	PAD_CFG_GPO(GPP_G6, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G7, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_G8, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP3_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_G9, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP3_CTRLDATA */
	_PAD_CFG_STRUCT(GPP_G10, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP4_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_G11, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP4_CTRLDATA */
	_PAD_CFG_STRUCT(GPP_G12, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP1_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_G13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP1_CTRLDATA */
	_PAD_CFG_STRUCT(GPP_G14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP2_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_G15, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* DDP2_CTRLDATA */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1),	/* BATLOW# */
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1),	/* ACPRESENT */
	PAD_CFG_NF(GPD2, NATIVE, PWROK, NF1),	/* LAN_WAKE# */
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1),	/* PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),	/* SLP_A# */
	PAD_CFG_GPO(GPD7, 0, PWROK),		/* GPIO */
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),	/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, PWROK, NF1),	/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1),	/* SLP_S5# */
	PAD_CFG_NF(GPD11, NONE, PWROK, NF1),	/* LANPHYPC */
	PAD_NC(GPD12, NONE),			/* GPIO */

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, DEEP, NF1),	/* SATAXPCIE0 */
	PAD_CFG_NF(GPP_E1, NONE, PLTRST, NF1),	/* SATAXPCIE1 */
	PAD_CFG_GPO(GPP_E2, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_E3, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_E4, 1, PLTRST),		/* SATA_DEVSLP0 */
	PAD_CFG_NF(GPP_E5, NONE, RSMRST, NF1),	/* SATA_DEVSLP1 */
	PAD_CFG_GPO(GPP_E6, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF2),	/* SATALED# */
	PAD_CFG_NF(GPP_E9, NONE, PLTRST, NF1),	/* USB_OC0# */
	PAD_CFG_NF(GPP_E10, NONE, PLTRST, NF1),	/* USB_OC1# */
	PAD_CFG_NF(GPP_E11, NONE, PLTRST, NF1),	/* USB_OC2# */
	PAD_CFG_NF(GPP_E12, NONE, PLTRST, NF1),	/* USB_OC3# */

	/* ------- GPIO Group GPP_F ------- */
	_PAD_CFG_STRUCT(GPP_F0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SATAXPCIE3 */
	_PAD_CFG_STRUCT(GPP_F1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SATAXPCIE4 */
	_PAD_CFG_STRUCT(GPP_F2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SATAXPCIE5 */
	PAD_CFG_GPO(GPP_F3, 0, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_F4, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_F5, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_F6, NONE),
	PAD_CFG_GPO(GPP_F7, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_F8, NONE),
	PAD_CFG_GPO(GPP_F9, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_F10, NONE),
	PAD_CFG_GPO(GPP_F11, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_F12, 1, DEEP),		/* GPIO */
	PAD_CFG_GPO(GPP_F13, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_F14, NONE, PLTRST, NF1),	/* PS_ON# */
	PAD_CFG_GPI_TRIG_OWN(GPP_F15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_F16, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_F17, NONE),
	PAD_CFG_GPO(GPP_F18, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_F19, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* eDP_VDDEN */
	_PAD_CFG_STRUCT(GPP_F20, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* eDP_BKLTEN */
	_PAD_CFG_STRUCT(GPP_F21, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* eDP_BKLTCTL */
	PAD_NC(GPP_F22, NONE),
	PAD_CFG_GPO(GPP_F23, 1, PLTRST),	/* GPIO */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE),
	PAD_NC(GPP_H1, NONE),
	PAD_NC(GPP_H2, NONE),
	PAD_NC(GPP_H3, NONE),
	PAD_NC(GPP_H4, NONE),
	PAD_NC(GPP_H5, NONE),
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),	// SRCCLKREQ12
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),	// SRCCLKREQ13
	PAD_CFG_NF(GPP_H8, NONE, DEEP, NF1),	// SRCCLKREQ14
	PAD_CFG_NF(GPP_H9, NONE, DEEP, NF1),	// SRCCLKREQ15
	PAD_CFG_GPO(GPP_H10, 1, PLTRST),	// GPIO */
	PAD_NC(GPP_H11, NONE),
	PAD_CFG_GPO(GPP_H12, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H13, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H14, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H15, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H16, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H17, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H18, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_H19, NONE),
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_CFG_GPO(GPP_H23, 1, PLTRST),	/* GPIO */

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_GPO(GPP_J0, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_J1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CPU_C10_GATE# */
	_PAD_CFG_STRUCT(GPP_J2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_BRI_DT */
	_PAD_CFG_STRUCT(GPP_J3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* CNV_BRI_RSP */
	_PAD_CFG_STRUCT(GPP_J4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_RGI_DT */
	_PAD_CFG_STRUCT(GPP_J5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* CNV_RGI_RSP */
	PAD_NC(GPP_J6, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_J7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_J8, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_J9, 1, PLTRST),	/* GPIO */

	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPO(GPP_K0, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_K1, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_K2, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_K3, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_K4, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_K5, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_K6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPDA */
	_PAD_CFG_STRUCT(GPP_K7, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPDB */
	_PAD_CFG_STRUCT(GPP_K8, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CORE_VID0 */
	_PAD_CFG_STRUCT(GPP_K9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CORE_VID1 */
	PAD_CFG_GPO(GPP_K10, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_K11, NONE),

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_I ------- */
	_PAD_CFG_STRUCT(GPP_I0, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* PMCALERT# */
	_PAD_CFG_STRUCT(GPP_I1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPD1 */
	_PAD_CFG_STRUCT(GPP_I2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* DDSP_HPD2 */
	_PAD_CFG_STRUCT(GPP_I3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPD3 */
	_PAD_CFG_STRUCT(GPP_I4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPD4 */
	_PAD_CFG_STRUCT(GPP_I5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDPB_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_I6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* DDPB_CTRLDATA */
	PAD_NC(GPP_I7, NONE),
	PAD_CFG_GPO(GPP_I8, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_I9, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_I10, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_I11, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* I2C4_SDA */
	_PAD_CFG_STRUCT(GPP_I12, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* I2C4_SCL */
	_PAD_CFG_STRUCT(GPP_I13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* USB_OC6# */
	_PAD_CFG_STRUCT(GPP_I14, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* I2C5_SCL */
};
