<!--
SPDX-FileCopyrightInfo: Copyright © DUNE Project contributors, see file LICENSE.md in module root
SPDX-License-Identifier: LGPL-3.0-or-later OR LicenseRef-GPL-2.0-only-with-PDELab-exception
-->

TypeTree
========

TypeTree is a template library for constructing and operating on statically
typed trees of objects. It is based around the idea of defining loosely coupled,
componentized algorithms. Component lookup happens through tag dispatch, making
it very easy to extend and / or modify existing algorithms as well as constructing
new algorithms for existing types of tree nodes.

The provided algorithms include visitor-based iteration of both single trees and
pairs of trees and a powerful tree transformation algorithm that automatically
decomposes an existing tree and constructs the transformed one, only requiring
the user to specify the per-node transformation policies.

Moreover, there are some more specialized utility algorithms for compile-time
reductions over trees and leaves, which are mainly useful for the construction
of template meta programs.

Finally, there are mixin implementations of the three default node concepts in
the library (leaf nodes, power nodes and composite nodes). For more complicated
use patterns, the library also contains generic implementations of proxy nodes
and, on top of that functionality, filtered nodes that can reorder and / or
restrict access to some of their children.

The TypeTree library was originally developed as part of [PDELab][0] to support its
tree-based abstraction of function spaces, but has attracted wider-spread interest.
To facility integration with other projects, we have extracted the code from
PDELab into this standalone library

This package contains the TypeTree library code. For usage examples your best bet
is to look at the PDELab package.

If you have downloaded a release tarball, you can find the autogenerated Doxygen
API documentation in doc/doxygen/html. Otherwise, you can build this documentation
yourself by calling "make doc". Note that you need Doxygen and GraphViz available at
configure time to be able to build the documentation.

See the file [CHANGELOG.md][8] for recent changes to the library.

Dependencies
------------

TypeTree depends on the dune-common core module:

* https://gitlab.dune-project.org/core/dune-common

License
-------

The TypeTree library, headers and test programs are free open-source software,
dual-licensed under version 3 or later of the GNU Lesser General Public License
and version 2 of the GNU General Public License with a special run-time exception.

See the file [LICENSE.md][7] for full copying permissions.

Installation
------------

For installation instructions please see the [DUNE website][2].

Links
-----

[0]: http://www.dune-project.org/pdelab/
[1]: http://www.dune-project.org
[2]: http://www.dune-project.org/doc/installation-notes.html
[4]: http://gcc.gnu.org/onlinedocs/libstdc++/faq.html#faq.license
[5]: http://lists.dune-project.org/mailman/listinfo/dune-pdelab
[6]: http://gitlab.dune-project.org/pdelab/dune-typetree/issues
[7]: LICENSE.md
[8]: CHANGELOG.md
