#!/bin/sh

srcdir=${srcdir:-.}
. $srcdir/common.inc.sh

prepare 3

echo=${ECHO:-/bin/echo}

chroot=fakechroot

echo something > $testtree/somefile

t=`$srcdir/$chroot.sh $testtree /bin/cat somefile 2>&1`
test "$t" = "something" || not
ok "$chroot cat somefile returns" $t

t=`$srcdir/$chroot.sh $testtree /usr/bin/env /bin/sh -c '/bin/cat somefile' 2>&1`
test "$t" = "something" || not
ok "$chroot cat somefile returns" $t

t=`$srcdir/$chroot.sh $testtree /usr/bin/env FAKECHROOT_ELFLOADER=$echo /bin/sh -c '/bin/cat somefile' 2>&1`
case "$t" in *"/bin/cat somefile");; *) not; esac
ok "$chroot cat somefile with FAKECHROOT_ELFLOADER=$echo returns" $t

cleanup
