/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __NAME_HPP_INCLUDED
#define __NAME_HPP_INCLUDED

#include <string>
#include <list>
#include <stdexcept>
#include "frontend/ast/Expression.hpp"

namespace ast {

class Symbol;

//! base class for any VHDL name.
class Name : public Expression {
public:
	//! c'tor
	/** @param n string of the name
	 *  @param cands list with candidates of correlating symbols.
	 *  @param loc corresponding location
	 */
	Name(
		std::string *n,
		std::list<Symbol*> cands,
		Location loc
		) : 	Expression(loc), 
			name(n), 
			candidates(cands) {}

	/** actual name */
	std::string *name;

	/** candidates symbols for this Name */
	std::list<Symbol*> candidates;

	//! return the declaration of the symbol
	/** This method will return the declaration of the symbol. The symbol
	 *  must hence be resolved to a unique name, otherwise this method
	 *  may not get called.
	 *  @return declaration of the simple name.
	 */
	SymbolDeclaration *getDeclaration(void) const;

	/** get the name of the definition. Will return a name, 
	 *  that must be the same for each parse run of an identical 
	 *  design hierarchy, and that must be unique within this 
	 *  hierarchy.
	 *
	 *  This function is a convenience only function (taking the 
	 *  symbol's definition and call getICName() there and should
	 *  probably go away (FIXME).
	 *
	 *  @throw std::logic_error, in case the name is not uniquely 
	 *         resolved.
	 *  @return name of the definition.
	 */
	std::string getName(void) const /* throw(std::logic_error) */;

protected:
	//! d'tor
	virtual ~Name() {
		delete this->name;
	}
};

}; /* namespace ast */

#endif /* __NAME_HPP_INCLUDED */
