/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/SimpleName.hpp"
#include <cassert>
#include "frontend/misc/Symbol.hpp"
#include "frontend/ast/SignalDeclaration.hpp"

namespace ast {

bool
SimpleName::isSignal(void) const
{
	assert(this->candidates.size() >= 1);

	if (this->candidates.size() != 1) {
		// overloaded -> function or procedure
		return false;
	}
	
	switch (this->candidates.front()->type) {
	case SYMBOL_SIGNAL:
	case SYMBOL_PORT:
		return true;

	case SYMBOL_PARAMETER: {
		// might be a signal, check
		const SignalDeclaration *sig = 
			dynamic_cast<const SignalDeclaration*>(
				&this->candidates.front()->declaration);
		if (sig != NULL) {
			return true;
		}

		break;
	    }
	default:
		break;
	}

	return false;
}

bool
SimpleName::operator==(const SimpleName &other) const
{
	if ((*this->name) != (*other.name)) {
		return false;
	}

	// FIXME will that dereference pointers?
	if (this->prefixStrings != other.prefixStrings) {
		return false;
	}

	if (this->candidates.size() != other.candidates.size()) {
		return false;
	}

	std::list<Symbol *>::const_iterator i = this->candidates.begin();
	std::list<Symbol *>::const_iterator j = other.candidates.begin();

	for (; i != this->candidates.end(); i++, j++) {
		if ((*i)->type != (*j)->type) {
			return false;
		}
	}

	return true;
}

}; /* namespace ast */
