/* $Id$ 
 *
 * Div: division (intermediate opcode).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __DIV_HPP_INCLUDED
#define __DIV_HPP_INCLUDED

namespace intermediate {

//! division
/** This class will perform a division.
 *  
 *  Errors: right is 0.
 *
 *  Read Operands: left, right
 *  Write Operands: dst
 *
 *  left operand: dividend (any type).
 *  right operand: divisor (any type)
 *  dst: resulting quotient (any type)
 *
 *  Operation: dst = left / right
 */
class Div : public OpCode {
public:
	//! c'tor
	/** @param l left operand
	 *  @param r right operand
	 *  @param dst destination register
	 */
	Div(
		Operand *l, 
		Operand *r,
		Register *destination
		) :	left(l), right(r), dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination
	Register *dst;

protected:
	virtual ~Div() {
		util::MiscUtil::terminate(this->left);
		util::MiscUtil::terminate(this->right);
		util::MiscUtil::terminate(this->dst);
	}
};


}; /* namespace intermediate */


#endif /* __DIV_HPP_INCLUDED */
