/* $Id$ 
 *
 * ImmediateOperand: An operand with a value.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/operands/ImmediateOperand.hpp"

namespace intermediate {

ImmediateOperand *ImmediateOperand::one = NULL;
ImmediateOperand *ImmediateOperand::zero = NULL;

ImmediateOperand *
ImmediateOperand::getZero(void)
{
	if (ImmediateOperand::zero == NULL) {
		ImmediateOperand::zero = 
			new ImmediateOperand(
				static_cast<universal_integer>(0));
		return ImmediateOperand::zero;
	}

	return ImmediateOperand::zero;
}

ImmediateOperand *
ImmediateOperand::getOne(void)
{
	if (ImmediateOperand::one == NULL) {
		ImmediateOperand::one = 
			new ImmediateOperand(
				static_cast<universal_integer>(1));
		return ImmediateOperand::one;
	}

	return ImmediateOperand::one;
}


}; /* namespace intermediate */
