#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug
from fenrirscreenreader.core.soundDriver import sound_driver


class driver(sound_driver):
    def __init__(self):
        sound_driver.__init__(self)

    def initialize(self, environment):
        self.env = environment
        self._initialized = True
        print("Sound Debug Driver: Initialized")

    def shutdown(self):
        if not self._initialized:
            return
        self.cancel()
        self._initialized = False
        print("Sound Debug Driver: Shutdown")

    def play_frequence(
        self, frequence, duration, adjust_volume=0.0, interrupt=True
    ):
        if not self._initialized:
            return
        if interrupt:
            self.cancel()
        print(
            "Sound Debug Driver: play_frequence:"
            + " freq:"
            + str(frequence)
            + " duration:"
            + str(duration)
            + " adjust_volume:"
            + str(adjust_volume)
        )
        print("Sound Debug Driver: -----------------------------------")

    def play_sound_file(self, file_path, interrupt=True):
        if not self._initialized:
            return
        if interrupt:
            self.cancel()
        print("Sound Debug Driver: play_sound_file:" + str(file_path))
        print("Sound Debug Driver: -----------------------------------")

    def cancel(self):
        if not self._initialized:
            return
        print("Sound Debug Driver: Cancel")

    def set_callback(self, callback):
        if not self._initialized:
            return
        print("Sound Debug Driver: set_callback")

    def set_volume(self, volume):
        if not self._initialized:
            return
        self.volume = volume
        print("Sound Debug Driver: set_volume:" + str(self.volume))
