/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class NullAssignmentRule
extends AbstractRule {
    public Object visit(ASTNullLiteral node, Object data) {
        if (node.getNthParent(5) instanceof ASTStatementExpression) {
            ASTStatementExpression n = (ASTStatementExpression)node.getNthParent(5);
            if (this.isAssignmentToFinalField(n)) {
                return data;
            }
            if (n.jjtGetNumChildren() > 2 && n.jjtGetChild(1) instanceof ASTAssignmentOperator) {
                this.addViolation(data, node);
            }
        } else if (node.getNthParent(4) instanceof ASTConditionalExpression) {
            if (this.isBadTernary((ASTConditionalExpression)node.getNthParent(4))) {
                this.addViolation(data, node);
            }
        } else if (node.getNthParent(5) instanceof ASTConditionalExpression && node.getNthParent(4) instanceof ASTExpression && this.isBadTernary((ASTConditionalExpression)node.getNthParent(5))) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean isAssignmentToFinalField(ASTStatementExpression n) {
        ASTName name = n.getFirstChildOfType(ASTName.class);
        return name != null && name.getNameDeclaration() instanceof VariableNameDeclaration && ((VariableNameDeclaration)name.getNameDeclaration()).getAccessNodeParent().isFinal();
    }

    private boolean isBadTernary(ASTConditionalExpression n) {
        return n.isTernary() && !(n.jjtGetChild(0) instanceof ASTEqualityExpression);
    }
}

