/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class StringUtil {
    public static final String[] EMPTY_STRINGS = new String[0];
    private static final boolean supportsUTF8 = System.getProperty("net.sourceforge.pmd.supportUTF8", "no").equals("yes");
    private static final String[] ENTITIES = new String[130];

    public static String replaceString(String original, char oldChar, String newString) {
        String fixedNew = newString == null ? "" : newString;
        StringBuffer desc = new StringBuffer();
        int index = original.indexOf(oldChar);
        int last = 0;
        while (index != -1) {
            desc.append(original.substring(last, index));
            desc.append(fixedNew);
            last = index + 1;
            index = original.indexOf(oldChar, last);
        }
        desc.append(original.substring(last));
        return desc.toString();
    }

    public static String replaceString(String original, String oldString, String newString) {
        String fixedNew = newString == null ? "" : newString;
        StringBuffer desc = new StringBuffer();
        int index = original.indexOf(oldString);
        int last = 0;
        while (index != -1) {
            desc.append(original.substring(last, index));
            desc.append(fixedNew);
            last = index + oldString.length();
            index = original.indexOf(oldString, last);
        }
        desc.append(original.substring(last));
        return desc.toString();
    }

    public static void appendXmlEscaped(StringBuffer buf, String src) {
        StringUtil.appendXmlEscaped(buf, src, supportsUTF8);
    }

    public static String htmlEncode(String string) {
        String encoded = StringUtil.replaceString(string, '&', "&amp;");
        encoded = StringUtil.replaceString(encoded, '<', "&lt;");
        return StringUtil.replaceString(encoded, '>', "&gt;");
    }

    private static void appendXmlEscaped(StringBuffer buf, String src, boolean supportUTF8) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c > '~') {
                if (!supportUTF8) {
                    if (c <= '\u00ff') {
                        buf.append(ENTITIES[c - 126]);
                        continue;
                    }
                    buf.append("&u").append(Integer.toHexString(c)).append(';');
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            buf.append(c);
        }
    }

    public static String[] substringsOf(String source, char delimiter) {
        if (source == null || source.length() == 0) {
            return EMPTY_STRINGS;
        }
        int delimiterCount = 0;
        int length = source.length();
        char[] chars = source.toCharArray();
        for (int i = 0; i < length; ++i) {
            if (chars[i] != delimiter) continue;
            ++delimiterCount;
        }
        if (delimiterCount == 0) {
            return new String[]{source};
        }
        String[] results = new String[delimiterCount + 1];
        int i = 0;
        int offset = 0;
        while (offset <= length) {
            int pos = source.indexOf(delimiter, offset);
            if (pos < 0) {
                pos = length;
            }
            results[i++] = pos == offset ? "" : source.substring(offset, pos);
            offset = pos + 1;
        }
        return results;
    }

    public static String[] substringsOf(String str, String separator) {
        if (str == null || str.length() == 0) {
            return EMPTY_STRINGS;
        }
        int index = str.indexOf(separator);
        if (index == -1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int currPos = 0;
        int len = separator.length();
        while (index != -1) {
            list.add(str.substring(currPos, index));
            currPos = index + len;
            index = str.indexOf(separator, currPos);
        }
        list.add(str.substring(currPos));
        return list.toArray(new String[list.size()]);
    }

    public static void asStringOn(StringBuffer sb, Iterator iter, String separator) {
        if (!iter.hasNext()) {
            return;
        }
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(separator);
            sb.append(iter.next());
        }
    }

    public static int lengthOfShortestIn(String[] strings) {
        int minLength = Integer.MAX_VALUE;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) {
                return 0;
            }
            minLength = Math.min(minLength, strings[i].length());
        }
        return minLength;
    }

    public static int maxCommonLeadingWhitespaceForAll(String[] strings) {
        int shortest = StringUtil.lengthOfShortestIn(strings);
        if (shortest == 0) {
            return 0;
        }
        char[] matches = new char[shortest];
        for (int m = 0; m < matches.length; ++m) {
            matches[m] = strings[0].charAt(m);
            if (!Character.isWhitespace(matches[m])) {
                return m;
            }
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                if (str.charAt(m) == matches[m]) continue;
                return m;
            }
        }
        return shortest;
    }

    public static String[] trimStartOn(String[] strings, int trimDepth) {
        if (trimDepth == 0) {
            return strings;
        }
        String[] results = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            results[i] = strings[i].substring(trimDepth);
        }
        return results;
    }

    public static String lpad(String s, int length) {
        String res = s;
        if (length - s.length() > 0) {
            char[] arr = new char[length - s.length()];
            Arrays.fill(arr, ' ');
            res = new StringBuffer(length).append(arr).append(s).toString();
        }
        return res;
    }

    public static boolean isSame(String s1, String s2, boolean trim, boolean ignoreCase, boolean standardizeWhitespace) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (trim) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if (standardizeWhitespace) {
            s1 = s1.replaceAll("\\s+", " ");
            s2 = s2.replaceAll("\\s+", " ");
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    static {
        for (int i = 126; i <= 255; ++i) {
            StringUtil.ENTITIES[i - 126] = "&#" + i + ';';
        }
    }
}

