/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class AtLeastXNumberOfInvocationsChecker {
    public static void checkAtLeastNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount) {
        List<Invocation> actualInvocations = InvocationsFinder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            List<Location> allLocations = InvocationsFinder.getAllLocations(actualInvocations);
            throw Reporter.tooFewActualInvocations(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, allLocations);
        }
        InvocationMarker.markVerified(actualInvocations, wanted);
    }

    public static void checkAtLeastNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext orderingContext) {
        List<Invocation> chunk = InvocationsFinder.findAllMatchingUnverifiedChunks(invocations, wanted, orderingContext);
        int actualCount = chunk.size();
        if (wantedCount > actualCount) {
            List<Location> allLocations = InvocationsFinder.getAllLocations(chunk);
            throw Reporter.tooFewActualInvocationsInOrder(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, allLocations);
        }
        InvocationMarker.markVerifiedInOrder(chunk, wanted, orderingContext);
    }
}

