#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

package FreePWING::FPWUtils::FPWUtils;

require 5.005;
use strict;
use integer;

use vars qw(@ISA
            @EXPORT
            @EXPORT_OK
	    $work_directory
	    $text_file_name
	    $text_ref_file_name
	    $text_tag_file_name
	    $menu_file_name
	    $menu_ref_file_name
	    $menu_tag_file_name
	    $copyright_file_name
	    $copyright_ref_file_name
	    $copyright_tag_file_name
	    $heading_file_name
	    $word_file_name
	    $endword_file_name
	    $keyword_file_name
	    $sort_file_name
	    $endsort_file_name
	    $keysort_file_name
	    $index_file_name
	    $endindex_file_name
	    $keyindex_file_name
	    $index_ref_file_name
	    $endindex_ref_file_name
	    $keyindex_ref_file_name
	    $control_file_name
	    $control_ref_file_name
	    $color_graphic_file_name
	    $color_graphic_tag_file_name
	    $sound_file_name
	    $sound_tag_file_name
	    $sound_fmt_file_name
	    $honmon_file_name
	    $half_char_name_file_name
	    $full_char_name_file_name
	    $half_char_bitmap_16_file_name
	    $half_char_bitmap_24_file_name
	    $half_char_bitmap_30_file_name
	    $half_char_bitmap_48_file_name
	    $full_char_bitmap_16_file_name
	    $full_char_bitmap_24_file_name
	    $full_char_bitmap_30_file_name
	    $full_char_bitmap_48_file_name
	    $sort_command);

@ISA = qw(Exporter);
@EXPORT = qw($work_directory
	     $text_file_name
	     $text_ref_file_name
	     $text_tag_file_name
	     $menu_file_name
	     $menu_ref_file_name
	     $menu_tag_file_name
	     $copyright_file_name
	     $copyright_ref_file_name
	     $copyright_tag_file_name
	     $heading_file_name
	     $word_file_name
	     $endword_file_name
	     $keyword_file_name
	     $sort_file_name
	     $endsort_file_name
	     $keysort_file_name
	     $index_file_name
	     $endindex_file_name
	     $keyindex_file_name
	     $index_ref_file_name
	     $endindex_ref_file_name
	     $keyindex_ref_file_name
	     $control_file_name
	     $control_ref_file_name
	     $color_graphic_file_name
	     $color_graphic_tag_file_name
	     $sound_file_name
	     $sound_tag_file_name
	     $sound_fmt_file_name
	     $honmon_file_name
	     $half_char_name_file_name
	     $full_char_name_file_name
	     $half_char_bitmap_16_file_name
	     $half_char_bitmap_24_file_name
	     $half_char_bitmap_30_file_name
	     $half_char_bitmap_48_file_name
	     $full_char_bitmap_16_file_name
	     $full_char_bitmap_24_file_name
	     $full_char_bitmap_30_file_name
	     $full_char_bitmap_48_file_name
	     $sort_command
	     initialize_fpwutils
	     finalize_fpwutils);

# ȥե񤭹ǥ쥯ȥ
$work_directory = '.';

#
# ѤѿνԤ
#
sub initialize_fpwutils {
    # ʸե̾
    $text_file_name = "$work_directory/text";

    # ʸλȾե̾
    $text_ref_file_name = "$work_directory/textref";
    
    # ʸΥե̾
    $text_tag_file_name = "$work_directory/texttag";
    
    # ˥塼ե̾
    $menu_file_name = "$work_directory/menu";
    
    # ˥塼λȾե̾
    $menu_ref_file_name = "$work_directory/menuref";
    
    # ˥塼Υե̾
    $menu_tag_file_name = "$work_directory/menutag";
    
    # ɽե̾
    $copyright_file_name = "$work_directory/copy";
    
    # ɽλȾե̾
    $copyright_ref_file_name = "$work_directory/copyref";
    
    # ɽΥե̾
    $copyright_tag_file_name = "$work_directory/copytag";
    
    # Фե̾
    $heading_file_name = "$work_directory/head";
    
    # Ѥ̤ñե̾
    $word_file_name = "$work_directory/word";
    
    # Ѥ̤ñե̾
    $endword_file_name = "$work_directory/eword";
    
    # ︡Ѥ̤ñե̾
    $keyword_file_name = "$work_directory/kword";
    
    # ѤѤñե̾
    $sort_file_name = "$work_directory/sort";
    
    # ѤѤñե̾
    $endsort_file_name = "$work_directory/esort";
    
    # ︡ѤѤñե̾
    $keysort_file_name = "$work_directory/ksort";
    
    # ץǥåλȾե̾
    $index_file_name = "$work_directory/idx";
    
    # ץǥåե̾
    $endindex_file_name = "$work_directory/eidx";
    
    # ︡ǥåե̾
    $keyindex_file_name = "$work_directory/kidx";
    
    # ץǥåե̾
    $index_ref_file_name = "$work_directory/idxref";
    
    # ץǥåλȾե̾
    $endindex_ref_file_name = "$work_directory/eidxref";
    
    # ︡ǥåλȾե̾
    $keyindex_ref_file_name = "$work_directory/kidxref";
    
    # Ҵե̾
    $control_file_name = "$work_directory/ctrl";
    
    # ҴλȾե̾
    $control_ref_file_name = "$work_directory/ctrlref";
    
    # 顼ǥե̾
    $color_graphic_file_name = "$work_directory/cgr";

    # 顼ǥե̾
    $color_graphic_tag_file_name = "$work_directory/cgrtag";

    # ե̾
    $sound_file_name = "$work_directory/snd";

    # ե̾
    $sound_tag_file_name = "$work_directory/sndtag";

    # ե̾ (satomii)
    $sound_fmt_file_name = "$work_directory/sndfmt";

    # HONMON ե̾
    $honmon_file_name = "honmon";
    
    # Ⱦѳ̾ե
    $half_char_name_file_name = "$work_directory/halfchar";
    
    # ѳ̾ե
    $full_char_name_file_name = "$work_directory/fullchar";
    
    # Ⱦѳӥåȥޥåץե̾
    $half_char_bitmap_16_file_name = "gai16h";
    $half_char_bitmap_24_file_name = "gai24h";
    $half_char_bitmap_30_file_name = "gai30h";
    $half_char_bitmap_48_file_name = "gai48h";
    
    # ѳӥåȥޥåץե̾
    $full_char_bitmap_16_file_name = "gai16f";
    $full_char_bitmap_24_file_name = "gai24f";
    $full_char_bitmap_30_file_name = "gai30f";
    $full_char_bitmap_48_file_name = "gai48f";
}

#
# ѤѿθԤ
#
sub finalize_fpwutils {
}

1;
