//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevops_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devops/armdevops"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/CreateAzurePipeline-Sample-AspNet-WindowsWebApp.json
func ExamplePipelinesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPipelinesClient().BeginCreateOrUpdate(ctx, "myAspNetWebAppPipeline-rg", "myAspNetWebAppPipeline", armdevops.Pipeline{
		Location: to.Ptr("South India"),
		Tags:     map[string]*string{},
		Properties: &armdevops.PipelineProperties{
			BootstrapConfiguration: &armdevops.BootstrapConfiguration{
				Template: &armdevops.PipelineTemplate{
					ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
					Parameters: map[string]*string{
						"appInsightLocation": to.Ptr("South India"),
						"appServicePlan":     to.Ptr("S1 Standard"),
						"azureAuth":          to.Ptr("{\"scheme\":\"ServicePrincipal\",\"parameters\":{\"tenantid\":\"{subscriptionTenantId}\",\"objectid\":\"{appObjectId}\",\"serviceprincipalid\":\"{appId}\",\"serviceprincipalkey\":\"{appSecret}\"}}"),
						"location":           to.Ptr("South India"),
						"resourceGroup":      to.Ptr("myAspNetWebAppPipeline-rg"),
						"subscriptionId":     to.Ptr("{subscriptionId}"),
						"webAppName":         to.Ptr("myAspNetWebApp"),
					},
				},
			},
			Organization: &armdevops.OrganizationReference{
				Name: to.Ptr("myAspNetWebAppPipeline-org"),
			},
			Project: &armdevops.ProjectReference{
				Name: to.Ptr("myAspNetWebAppPipeline-project"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Pipeline = armdevops.Pipeline{
	// 	Name: to.Ptr("myAspNetWebAppPipeline"),
	// 	Type: to.Ptr("Microsoft.DevOps/pipelines"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline"),
	// 	Location: to.Ptr("South India"),
	// 	Properties: &armdevops.PipelineProperties{
	// 		BootstrapConfiguration: &armdevops.BootstrapConfiguration{
	// 			Template: &armdevops.PipelineTemplate{
	// 				ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
	// 				Parameters: map[string]*string{
	// 					"appInsightLocation": to.Ptr("South India"),
	// 					"appServicePlan": to.Ptr("S1 Standard"),
	// 					"azureAuth": nil,
	// 					"location": to.Ptr("South India"),
	// 					"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
	// 					"subscriptionId": to.Ptr("{subscriptionId}"),
	// 					"webAppName": to.Ptr("myAspNetWebApp"),
	// 				},
	// 			},
	// 		},
	// 		Organization: &armdevops.OrganizationReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-org"),
	// 		},
	// 		Project: &armdevops.ProjectReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-project"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/GetAzurePipeline.json
func ExamplePipelinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPipelinesClient().Get(ctx, "myAspNetWebAppPipeline-rg", "myAspNetWebAppPipeline", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Pipeline = armdevops.Pipeline{
	// 	Name: to.Ptr("myAspNetWebAppPipeline"),
	// 	Type: to.Ptr("Microsoft.DevOps/pipelines"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline"),
	// 	Location: to.Ptr("South India"),
	// 	Properties: &armdevops.PipelineProperties{
	// 		BootstrapConfiguration: &armdevops.BootstrapConfiguration{
	// 			Template: &armdevops.PipelineTemplate{
	// 				ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
	// 				Parameters: map[string]*string{
	// 					"appInsightLocation": to.Ptr("South India"),
	// 					"appServicePlan": to.Ptr("S1 Standard"),
	// 					"azureAuth": nil,
	// 					"location": to.Ptr("South India"),
	// 					"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
	// 					"subscriptionId": to.Ptr("{subscriptionId}"),
	// 					"webAppName": to.Ptr("myAspNetWebApp"),
	// 				},
	// 			},
	// 		},
	// 		Organization: &armdevops.OrganizationReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-org"),
	// 		},
	// 		Project: &armdevops.ProjectReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-project"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/UpdateAzurePipeline.json
func ExamplePipelinesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPipelinesClient().Update(ctx, "myAspNetWebAppPipeline-rg", "myAspNetWebAppPipeline", armdevops.PipelineUpdateParameters{
		Tags: map[string]*string{
			"tagKey": to.Ptr("tagvalue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Pipeline = armdevops.Pipeline{
	// 	Name: to.Ptr("myAspNetWebAppPipeline"),
	// 	Type: to.Ptr("Microsoft.DevOps/pipelines"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline"),
	// 	Location: to.Ptr("South India"),
	// 	Tags: map[string]*string{
	// 		"tagKey": to.Ptr("tagvalue"),
	// 	},
	// 	Properties: &armdevops.PipelineProperties{
	// 		BootstrapConfiguration: &armdevops.BootstrapConfiguration{
	// 			Template: &armdevops.PipelineTemplate{
	// 				ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
	// 				Parameters: map[string]*string{
	// 					"appInsightLocation": to.Ptr("South India"),
	// 					"appServicePlan": to.Ptr("S1 Standard"),
	// 					"azureAuth": nil,
	// 					"location": to.Ptr("South India"),
	// 					"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
	// 					"subscriptionId": to.Ptr("{subscriptionId}"),
	// 					"webAppName": to.Ptr("myAspNetWebApp"),
	// 				},
	// 			},
	// 		},
	// 		Organization: &armdevops.OrganizationReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-org"),
	// 		},
	// 		Project: &armdevops.ProjectReference{
	// 			Name: to.Ptr("myAspNetWebAppPipeline-project"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/DeleteAzurePipeline.json
func ExamplePipelinesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPipelinesClient().Delete(ctx, "myAspNetWebAppPipeline-rg", "myAspNetWebAppPipeline", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/ListAzurePipelinesByResourceGroup.json
func ExamplePipelinesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPipelinesClient().NewListByResourceGroupPager("myAspNetWebAppPipeline-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PipelineListResult = armdevops.PipelineListResult{
		// 	Value: []*armdevops.Pipeline{
		// 		{
		// 			Name: to.Ptr("myAspNetWebAppPipeline"),
		// 			Type: to.Ptr("Microsoft.DevOps/pipelines"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline"),
		// 			Location: to.Ptr("South India"),
		// 			Properties: &armdevops.PipelineProperties{
		// 				BootstrapConfiguration: &armdevops.BootstrapConfiguration{
		// 					Template: &armdevops.PipelineTemplate{
		// 						ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
		// 						Parameters: map[string]*string{
		// 							"appInsightLocation": to.Ptr("South India"),
		// 							"appServicePlan": to.Ptr("S1 Standard"),
		// 							"azureAuth": nil,
		// 							"location": to.Ptr("South India"),
		// 							"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
		// 							"subscriptionId": to.Ptr("{subscriptionId}"),
		// 							"webAppName": to.Ptr("myAspNetWebApp"),
		// 						},
		// 					},
		// 				},
		// 				Organization: &armdevops.OrganizationReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-org"),
		// 				},
		// 				Project: &armdevops.ProjectReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-project"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devops/resource-manager/Microsoft.DevOps/preview/2019-07-01-preview/examples/ListAzurePipelinesBySubscription.json
func ExamplePipelinesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevops.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPipelinesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PipelineListResult = armdevops.PipelineListResult{
		// 	Value: []*armdevops.Pipeline{
		// 		{
		// 			Name: to.Ptr("myAspNetWebAppPipeline"),
		// 			Type: to.Ptr("Microsoft.DevOps/pipelines"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline"),
		// 			Location: to.Ptr("South India"),
		// 			Properties: &armdevops.PipelineProperties{
		// 				BootstrapConfiguration: &armdevops.BootstrapConfiguration{
		// 					Template: &armdevops.PipelineTemplate{
		// 						ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
		// 						Parameters: map[string]*string{
		// 							"appInsightLocation": to.Ptr("South India"),
		// 							"appServicePlan": to.Ptr("S1 Standard"),
		// 							"azureAuth": nil,
		// 							"location": to.Ptr("South India"),
		// 							"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
		// 							"subscriptionId": to.Ptr("{subscriptionId}"),
		// 							"webAppName": to.Ptr("myAspNetWebApp"),
		// 						},
		// 					},
		// 				},
		// 				Organization: &armdevops.OrganizationReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-org"),
		// 				},
		// 				Project: &armdevops.ProjectReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-project"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myAspNetWebAppPipeline1"),
		// 			Type: to.Ptr("Microsoft.DevOps/pipelines"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/myAspNetWebAppPipeline-rg1/providers/Microsoft.DevOps/pipelines/myAspNetWebAppPipeline1"),
		// 			Location: to.Ptr("South India"),
		// 			Properties: &armdevops.PipelineProperties{
		// 				BootstrapConfiguration: &armdevops.BootstrapConfiguration{
		// 					Template: &armdevops.PipelineTemplate{
		// 						ID: to.Ptr("ms.vss-continuous-delivery-pipeline-templates.aspnet-windowswebapp"),
		// 						Parameters: map[string]*string{
		// 							"appInsightLocation": to.Ptr("South India"),
		// 							"appServicePlan": to.Ptr("S1 Standard"),
		// 							"azureAuth": nil,
		// 							"location": to.Ptr("South India"),
		// 							"resourceGroup": to.Ptr("myAspNetWebAppPipeline-rg"),
		// 							"subscriptionId": to.Ptr("{subscriptionId}"),
		// 							"webAppName": to.Ptr("myAspNetWebApp"),
		// 						},
		// 					},
		// 				},
		// 				Organization: &armdevops.OrganizationReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-org1"),
		// 				},
		// 				Project: &armdevops.ProjectReference{
		// 					Name: to.Ptr("myAspNetWebAppPipeline-project1"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
