//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	"net/http"
	"net/url"
	"regexp"
)

// JobsServer is a fake server for instances of the armhybriddatamanager.JobsClient type.
type JobsServer struct {
	// BeginCancel is the fake for method JobsClient.BeginCancel
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginCancel func(ctx context.Context, dataServiceName string, jobDefinitionName string, jobID string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientBeginCancelOptions) (resp azfake.PollerResponder[armhybriddatamanager.JobsClientCancelResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JobsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, dataServiceName string, jobDefinitionName string, jobID string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientGetOptions) (resp azfake.Responder[armhybriddatamanager.JobsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataManagerPager is the fake for method JobsClient.NewListByDataManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataManagerPager func(resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientListByDataManagerOptions) (resp azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataManagerResponse])

	// NewListByDataServicePager is the fake for method JobsClient.NewListByDataServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataServicePager func(dataServiceName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientListByDataServiceOptions) (resp azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataServiceResponse])

	// NewListByJobDefinitionPager is the fake for method JobsClient.NewListByJobDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByJobDefinitionPager func(dataServiceName string, jobDefinitionName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientListByJobDefinitionOptions) (resp azfake.PagerResponder[armhybriddatamanager.JobsClientListByJobDefinitionResponse])

	// BeginResume is the fake for method JobsClient.BeginResume
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginResume func(ctx context.Context, dataServiceName string, jobDefinitionName string, jobID string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobsClientBeginResumeOptions) (resp azfake.PollerResponder[armhybriddatamanager.JobsClientResumeResponse], errResp azfake.ErrorResponder)
}

// NewJobsServerTransport creates a new instance of JobsServerTransport with the provided implementation.
// The returned JobsServerTransport instance is connected to an instance of armhybriddatamanager.JobsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJobsServerTransport(srv *JobsServer) *JobsServerTransport {
	return &JobsServerTransport{
		srv:                         srv,
		beginCancel:                 newTracker[azfake.PollerResponder[armhybriddatamanager.JobsClientCancelResponse]](),
		newListByDataManagerPager:   newTracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataManagerResponse]](),
		newListByDataServicePager:   newTracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataServiceResponse]](),
		newListByJobDefinitionPager: newTracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByJobDefinitionResponse]](),
		beginResume:                 newTracker[azfake.PollerResponder[armhybriddatamanager.JobsClientResumeResponse]](),
	}
}

// JobsServerTransport connects instances of armhybriddatamanager.JobsClient to instances of JobsServer.
// Don't use this type directly, use NewJobsServerTransport instead.
type JobsServerTransport struct {
	srv                         *JobsServer
	beginCancel                 *tracker[azfake.PollerResponder[armhybriddatamanager.JobsClientCancelResponse]]
	newListByDataManagerPager   *tracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataManagerResponse]]
	newListByDataServicePager   *tracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByDataServiceResponse]]
	newListByJobDefinitionPager *tracker[azfake.PagerResponder[armhybriddatamanager.JobsClientListByJobDefinitionResponse]]
	beginResume                 *tracker[azfake.PollerResponder[armhybriddatamanager.JobsClientResumeResponse]]
}

// Do implements the policy.Transporter interface for JobsServerTransport.
func (j *JobsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JobsClient.BeginCancel":
		resp, err = j.dispatchBeginCancel(req)
	case "JobsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JobsClient.NewListByDataManagerPager":
		resp, err = j.dispatchNewListByDataManagerPager(req)
	case "JobsClient.NewListByDataServicePager":
		resp, err = j.dispatchNewListByDataServicePager(req)
	case "JobsClient.NewListByJobDefinitionPager":
		resp, err = j.dispatchNewListByJobDefinitionPager(req)
	case "JobsClient.BeginResume":
		resp, err = j.dispatchBeginResume(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JobsServerTransport) dispatchBeginCancel(req *http.Request) (*http.Response, error) {
	if j.srv.BeginCancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCancel not implemented")}
	}
	beginCancel := j.beginCancel.get(req)
	if beginCancel == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		jobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginCancel(req.Context(), dataServiceNameParam, jobDefinitionNameParam, jobIDParam, resourceGroupNameParam, dataManagerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCancel = &respr
		j.beginCancel.add(req, beginCancel)
	}

	resp, err := server.PollerResponderNext(beginCancel, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		j.beginCancel.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCancel) {
		j.beginCancel.remove(req)
	}

	return resp, nil
}

func (j *JobsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
	if err != nil {
		return nil, err
	}
	jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
	if err != nil {
		return nil, err
	}
	jobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armhybriddatamanager.JobsClientGetOptions
	if expandParam != nil {
		options = &armhybriddatamanager.JobsClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := j.srv.Get(req.Context(), dataServiceNameParam, jobDefinitionNameParam, jobIDParam, resourceGroupNameParam, dataManagerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Job, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobsServerTransport) dispatchNewListByDataManagerPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByDataManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataManagerPager not implemented")}
	}
	newListByDataManagerPager := j.newListByDataManagerPager.get(req)
	if newListByDataManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.JobsClientListByDataManagerOptions
		if filterParam != nil {
			options = &armhybriddatamanager.JobsClientListByDataManagerOptions{
				Filter: filterParam,
			}
		}
		resp := j.srv.NewListByDataManagerPager(resourceGroupNameParam, dataManagerNameParam, options)
		newListByDataManagerPager = &resp
		j.newListByDataManagerPager.add(req, newListByDataManagerPager)
		server.PagerResponderInjectNextLinks(newListByDataManagerPager, req, func(page *armhybriddatamanager.JobsClientListByDataManagerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByDataManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataManagerPager) {
		j.newListByDataManagerPager.remove(req)
	}
	return resp, nil
}

func (j *JobsServerTransport) dispatchNewListByDataServicePager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByDataServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataServicePager not implemented")}
	}
	newListByDataServicePager := j.newListByDataServicePager.get(req)
	if newListByDataServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.JobsClientListByDataServiceOptions
		if filterParam != nil {
			options = &armhybriddatamanager.JobsClientListByDataServiceOptions{
				Filter: filterParam,
			}
		}
		resp := j.srv.NewListByDataServicePager(dataServiceNameParam, resourceGroupNameParam, dataManagerNameParam, options)
		newListByDataServicePager = &resp
		j.newListByDataServicePager.add(req, newListByDataServicePager)
		server.PagerResponderInjectNextLinks(newListByDataServicePager, req, func(page *armhybriddatamanager.JobsClientListByDataServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByDataServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataServicePager) {
		j.newListByDataServicePager.remove(req)
	}
	return resp, nil
}

func (j *JobsServerTransport) dispatchNewListByJobDefinitionPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByJobDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByJobDefinitionPager not implemented")}
	}
	newListByJobDefinitionPager := j.newListByJobDefinitionPager.get(req)
	if newListByJobDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.JobsClientListByJobDefinitionOptions
		if filterParam != nil {
			options = &armhybriddatamanager.JobsClientListByJobDefinitionOptions{
				Filter: filterParam,
			}
		}
		resp := j.srv.NewListByJobDefinitionPager(dataServiceNameParam, jobDefinitionNameParam, resourceGroupNameParam, dataManagerNameParam, options)
		newListByJobDefinitionPager = &resp
		j.newListByJobDefinitionPager.add(req, newListByJobDefinitionPager)
		server.PagerResponderInjectNextLinks(newListByJobDefinitionPager, req, func(page *armhybriddatamanager.JobsClientListByJobDefinitionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByJobDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByJobDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByJobDefinitionPager) {
		j.newListByJobDefinitionPager.remove(req)
	}
	return resp, nil
}

func (j *JobsServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if j.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := j.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		jobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginResume(req.Context(), dataServiceNameParam, jobDefinitionNameParam, jobIDParam, resourceGroupNameParam, dataManagerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		j.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		j.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		j.beginResume.remove(req)
	}

	return resp, nil
}
