//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedInstanceVulnerabilityAssessmentsServer is a fake server for instances of the armsql.ManagedInstanceVulnerabilityAssessmentsClient type.
type ManagedInstanceVulnerabilityAssessmentsServer struct {
	// CreateOrUpdate is the fake for method ManagedInstanceVulnerabilityAssessmentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, parameters armsql.ManagedInstanceVulnerabilityAssessment, options *armsql.ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ManagedInstanceVulnerabilityAssessmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions) (resp azfake.Responder[armsql.ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedInstanceVulnerabilityAssessmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.ManagedInstanceVulnerabilityAssessmentsClientGetOptions) (resp azfake.Responder[armsql.ManagedInstanceVulnerabilityAssessmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByInstancePager is the fake for method ManagedInstanceVulnerabilityAssessmentsClient.NewListByInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse])
}

// NewManagedInstanceVulnerabilityAssessmentsServerTransport creates a new instance of ManagedInstanceVulnerabilityAssessmentsServerTransport with the provided implementation.
// The returned ManagedInstanceVulnerabilityAssessmentsServerTransport instance is connected to an instance of armsql.ManagedInstanceVulnerabilityAssessmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedInstanceVulnerabilityAssessmentsServerTransport(srv *ManagedInstanceVulnerabilityAssessmentsServer) *ManagedInstanceVulnerabilityAssessmentsServerTransport {
	return &ManagedInstanceVulnerabilityAssessmentsServerTransport{
		srv:                    srv,
		newListByInstancePager: newTracker[azfake.PagerResponder[armsql.ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse]](),
	}
}

// ManagedInstanceVulnerabilityAssessmentsServerTransport connects instances of armsql.ManagedInstanceVulnerabilityAssessmentsClient to instances of ManagedInstanceVulnerabilityAssessmentsServer.
// Don't use this type directly, use NewManagedInstanceVulnerabilityAssessmentsServerTransport instead.
type ManagedInstanceVulnerabilityAssessmentsServerTransport struct {
	srv                    *ManagedInstanceVulnerabilityAssessmentsServer
	newListByInstancePager *tracker[azfake.PagerResponder[armsql.ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse]]
}

// Do implements the policy.Transporter interface for ManagedInstanceVulnerabilityAssessmentsServerTransport.
func (m *ManagedInstanceVulnerabilityAssessmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedInstanceVulnerabilityAssessmentsClient.CreateOrUpdate":
		resp, err = m.dispatchCreateOrUpdate(req)
	case "ManagedInstanceVulnerabilityAssessmentsClient.Delete":
		resp, err = m.dispatchDelete(req)
	case "ManagedInstanceVulnerabilityAssessmentsClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedInstanceVulnerabilityAssessmentsClient.NewListByInstancePager":
		resp, err = m.dispatchNewListByInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedInstanceVulnerabilityAssessmentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.ManagedInstanceVulnerabilityAssessment](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, vulnerabilityAssessmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstanceVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedInstanceVulnerabilityAssessmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if m.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Delete(req.Context(), resourceGroupNameParam, managedInstanceNameParam, vulnerabilityAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedInstanceVulnerabilityAssessmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, vulnerabilityAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstanceVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedInstanceVulnerabilityAssessmentsServerTransport) dispatchNewListByInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInstancePager not implemented")}
	}
	newListByInstancePager := m.newListByInstancePager.get(req)
	if newListByInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByInstancePager = &resp
		m.newListByInstancePager.add(req, newListByInstancePager)
		server.PagerResponderInjectNextLinks(newListByInstancePager, req, func(page *armsql.ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInstancePager) {
		m.newListByInstancePager.remove(req)
	}
	return resp, nil
}
