//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceList.json
func ExampleManagedInstancesClient_NewListPager_listManagedInstances() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListPager(&armsql.ManagedInstancesClientListOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen4"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/subnet2"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("BC_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("BusinessCritical"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceListWithExpandEqualsAdministrators.json
func ExampleManagedInstancesClient_NewListPager_listManagedInstancesWithExpandAdministratorsActivedirectory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListPager(&armsql.ManagedInstancesClientListOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen4"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_2"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/subnet2"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("BC_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("BusinessCritical"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceListByInstancePool.json
func ExampleManagedInstancesClient_NewListByInstancePoolPager_listManagedInstancesByInstancePool() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByInstancePoolPager("Test1", "pool1", &armsql.ManagedInstancesClientListByInstancePoolOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("canadacentral"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				InstancePoolID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/instancePools/pool1"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_CanadaCentral_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen5"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen5"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("canadacentral"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				InstancePoolID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/instancePools/pool1"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_CanadaCentral_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen5"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceListByInstancePoolWithExpandEqualsAdministrators.json
func ExampleManagedInstancesClient_NewListByInstancePoolPager_listManagedInstancesByInstancePoolWithExpandAdministratorsActivedirectory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByInstancePoolPager("Test1", "pool1", &armsql.ManagedInstancesClientListByInstancePoolOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("canadacentral"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				InstancePoolID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/instancePools/pool1"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_CanadaCentral_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen5"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen5"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("canadacentral"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				InstancePoolID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Sql/instancePools/pool1"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_CanadaCentral_MI_2"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/Test1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen5"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceListByResourceGroup.json
func ExampleManagedInstancesClient_NewListByResourceGroupPager_listManagedInstancesByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByResourceGroupPager("Test1", &armsql.ManagedInstancesClientListByResourceGroupOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen4"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/subnet2"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("BC_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("BusinessCritical"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceListByResourceGroupWithExpandEqualsAdministrators.json
func ExampleManagedInstancesClient_NewListByResourceGroupPager_listManagedInstancesByResourceGroupWithExpandAdministratorsActivedirectory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByResourceGroupPager("Test1", &armsql.ManagedInstancesClientListByResourceGroupOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedInstanceListResult = armsql.ManagedInstanceListResult{
		// 	Value: []*armsql.ManagedInstance{
		// 		{
		// 			Name: to.Ptr("testinstance1"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance1"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("1b4e2caff2530"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance1.1b4e2caff2530.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
		// 				VCores: to.Ptr[int32](8),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("GP_Gen4"),
		// 				Capacity: to.Ptr[int32](8),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("GeneralPurpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testinstance2"),
		// 			Type: to.Ptr("Microsoft.Sql/managedInstances"),
		// 			ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/Test1/providers/Microsoft.Sql/managedInstances/testinstance2"),
		// 			Location: to.Ptr("japaneast"),
		// 			Properties: &armsql.ManagedInstanceProperties{
		// 				AdministratorLogin: to.Ptr("dummylogin"),
		// 				Administrators: &armsql.ManagedInstanceExternalAdministrator{
		// 					AzureADOnlyAuthentication: to.Ptr(true),
		// 					Login: to.Ptr("bob@contoso.com"),
		// 					PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
		// 					Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 					TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
		// 				},
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				DNSZone: to.Ptr("2c3d1bdae3412"),
		// 				FullyQualifiedDomainName: to.Ptr("testinstance2.2c3d1bdae3412.database.windows.net"),
		// 				LicenseType: to.Ptr(armsql.ManagedInstanceLicenseType("Full")),
		// 				MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_2"),
		// 				MinimalTLSVersion: to.Ptr("1.2"),
		// 				ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
		// 				ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
		// 				PublicDataEndpointEnabled: to.Ptr(false),
		// 				RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
		// 				State: to.Ptr("Ready"),
		// 				StorageSizeInGB: to.Ptr[int32](1024),
		// 				SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/subnet2"),
		// 				VCores: to.Ptr[int32](16),
		// 			},
		// 			SKU: &armsql.SKU{
		// 				Name: to.Ptr("BC_Gen5"),
		// 				Capacity: to.Ptr[int32](16),
		// 				Family: to.Ptr("Gen4"),
		// 				Tier: to.Ptr("BusinessCritical"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceGet.json
func ExampleManagedInstancesClient_Get_getManagedInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedInstancesClient().Get(ctx, "testrg", "testinstance", &armsql.ManagedInstancesClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/instancePool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
	// 		MinimalTLSVersion: to.Ptr("1.2"),
	// 		ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		ServicePrincipal: &armsql.ServicePrincipal{
	// 			Type: to.Ptr(armsql.ServicePrincipalTypeSystemAssigned),
	// 			ClientID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			PrincipalID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 		},
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceGetWithExpandEqualsAdministrators.json
func ExampleManagedInstancesClient_Get_getManagedInstanceWithExpandAdministratorsActivedirectory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedInstancesClient().Get(ctx, "testrg", "testinstance", &armsql.ManagedInstancesClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Administrators: &armsql.ManagedInstanceExternalAdministrator{
	// 			AzureADOnlyAuthentication: to.Ptr(true),
	// 			Login: to.Ptr("bob@contoso.com"),
	// 			PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
	// 			Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 		},
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/instancePool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
	// 		MinimalTLSVersion: to.Ptr("1.2"),
	// 		ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceCreateMax.json
func ExampleManagedInstancesClient_BeginCreateOrUpdate_createManagedInstanceWithAllProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginCreateOrUpdate(ctx, "testrg", "testinstance", armsql.ManagedInstance{
		Location: to.Ptr("Japan East"),
		Tags: map[string]*string{
			"tagKey1": to.Ptr("TagValue1"),
		},
		Properties: &armsql.ManagedInstanceProperties{
			AdministratorLogin:         to.Ptr("dummylogin"),
			AdministratorLoginPassword: to.Ptr("PLACEHOLDER"),
			Administrators: &armsql.ManagedInstanceExternalAdministrator{
				AzureADOnlyAuthentication: to.Ptr(true),
				Login:                     to.Ptr("bob@contoso.com"),
				PrincipalType:             to.Ptr(armsql.PrincipalTypeUser),
				Sid:                       to.Ptr("00000011-1111-2222-2222-123456789111"),
				TenantID:                  to.Ptr("00000011-1111-2222-2222-123456789111"),
			},
			Collation:                        to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
			DNSZonePartner:                   to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
			InstancePoolID:                   to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1"),
			LicenseType:                      to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
			MaintenanceConfigurationID:       to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
			MinimalTLSVersion:                to.Ptr("1.2"),
			ProxyOverride:                    to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
			PublicDataEndpointEnabled:        to.Ptr(false),
			RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
			ServicePrincipal: &armsql.ServicePrincipal{
				Type: to.Ptr(armsql.ServicePrincipalTypeSystemAssigned),
			},
			StorageSizeInGB: to.Ptr[int32](1024),
			SubnetID:        to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
			TimezoneID:      to.Ptr("UTC"),
			VCores:          to.Ptr[int32](8),
		},
		SKU: &armsql.SKU{
			Name: to.Ptr("GP_Gen5"),
			Tier: to.Ptr("GeneralPurpose"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Administrators: &armsql.ManagedInstanceExternalAdministrator{
	// 			AzureADOnlyAuthentication: to.Ptr(true),
	// 			Login: to.Ptr("bob@contoso.com"),
	// 			PrincipalType: to.Ptr(armsql.PrincipalTypeUser),
	// 			Sid: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 		},
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
	// 		MinimalTLSVersion: to.Ptr("1.2"),
	// 		ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		ServicePrincipal: &armsql.ServicePrincipal{
	// 			Type: to.Ptr(armsql.ServicePrincipalTypeSystemAssigned),
	// 			ClientID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			PrincipalID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 			TenantID: to.Ptr("00000011-1111-2222-2222-123456789111"),
	// 		},
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		TimezoneID: to.Ptr("UTC"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen5"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen5"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceCreateMin.json
func ExampleManagedInstancesClient_BeginCreateOrUpdate_createManagedInstanceWithMinimalProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginCreateOrUpdate(ctx, "testrg", "testinstance", armsql.ManagedInstance{
		Location: to.Ptr("Japan East"),
		Properties: &armsql.ManagedInstanceProperties{
			AdministratorLogin:         to.Ptr("dummylogin"),
			AdministratorLoginPassword: to.Ptr("PLACEHOLDER"),
			LicenseType:                to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
			StorageSizeInGB:            to.Ptr[int32](1024),
			SubnetID:                   to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
			VCores:                     to.Ptr[int32](8),
		},
		SKU: &armsql.SKU{
			Name: to.Ptr("GP_Gen4"),
			Tier: to.Ptr("GeneralPurpose"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		ProvisioningState: to.Ptr(armsql.ManagedInstancePropertiesProvisioningStateSucceeded),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceDelete.json
func ExampleManagedInstancesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginDelete(ctx, "testrg", "testinstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceRemoveMaintenanceConfiguration.json
func ExampleManagedInstancesClient_BeginUpdate_removeMaintenancePolicyFromManagedInstanceSelectDefaultMaintenancePolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginUpdate(ctx, "testrg", "testinstance", armsql.ManagedInstanceUpdate{
		Properties: &armsql.ManagedInstanceProperties{
			MaintenanceConfigurationID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_Default"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/instancePool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_Default"),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceUpdateMax.json
func ExampleManagedInstancesClient_BeginUpdate_updateManagedInstanceWithAllProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginUpdate(ctx, "testrg", "testinstance", armsql.ManagedInstanceUpdate{
		Properties: &armsql.ManagedInstanceProperties{
			AdministratorLogin:               to.Ptr("dummylogin"),
			AdministratorLoginPassword:       to.Ptr("PLACEHOLDER"),
			Collation:                        to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
			LicenseType:                      to.Ptr(armsql.ManagedInstanceLicenseTypeBasePrice),
			MaintenanceConfigurationID:       to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
			MinimalTLSVersion:                to.Ptr("1.2"),
			ProxyOverride:                    to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
			PublicDataEndpointEnabled:        to.Ptr(false),
			RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
			StorageSizeInGB:                  to.Ptr[int32](448),
			VCores:                           to.Ptr[int32](8),
		},
		SKU: &armsql.SKU{
			Name:     to.Ptr("GP_Gen4"),
			Capacity: to.Ptr[int32](8),
			Tier:     to.Ptr("GeneralPurpose"),
		},
		Tags: map[string]*string{
			"tagKey1": to.Ptr("TagValue1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("dummylogin"),
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/instancePool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeBasePrice),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
	// 		MinimalTLSVersion: to.Ptr("1.2"),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideRedirect),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](448),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceUpdateMin.json
func ExampleManagedInstancesClient_BeginUpdate_updateManagedInstanceWithMinimalProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginUpdate(ctx, "testrg", "testinstance", armsql.ManagedInstanceUpdate{
		Tags: map[string]*string{
			"tagKey1": to.Ptr("TagValue1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedInstance = armsql.ManagedInstance{
	// 	Name: to.Ptr("testinstance"),
	// 	Type: to.Ptr("Microsoft.Sql/managedInstances"),
	// 	ID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
	// 	Location: to.Ptr("japaneast"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsql.ManagedInstanceProperties{
	// 		AdministratorLogin: to.Ptr("PLACEHOLDER"),
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CurrentBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		DNSZone: to.Ptr("1b4e2caff2530"),
	// 		FullyQualifiedDomainName: to.Ptr("testinstance.1b4e2caff2530.database.windows.net"),
	// 		InstancePoolID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/instancePool1"),
	// 		LicenseType: to.Ptr(armsql.ManagedInstanceLicenseTypeLicenseIncluded),
	// 		MaintenanceConfigurationID: to.Ptr("/subscriptions/20d7082a-0fc7-4468-82bd-542694d5042b/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_Default"),
	// 		ProxyOverride: to.Ptr(armsql.ManagedInstanceProxyOverrideDefault),
	// 		PublicDataEndpointEnabled: to.Ptr(false),
	// 		RequestedBackupStorageRedundancy: to.Ptr(armsql.BackupStorageRedundancyGeo),
	// 		State: to.Ptr("Ready"),
	// 		StorageSizeInGB: to.Ptr[int32](1024),
	// 		SubnetID: to.Ptr("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 		VCores: to.Ptr[int32](8),
	// 	},
	// 	SKU: &armsql.SKU{
	// 		Name: to.Ptr("GP_Gen4"),
	// 		Capacity: to.Ptr[int32](8),
	// 		Family: to.Ptr("Gen4"),
	// 		Tier: to.Ptr("GeneralPurpose"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/FailoverManagedInstance.json
func ExampleManagedInstancesClient_BeginFailover() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginFailover(ctx, "group1", "instanceName", &armsql.ManagedInstancesClientBeginFailoverOptions{ReplicaType: to.Ptr(armsql.ReplicaTypePrimary)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ListOutboundNetworkDependenciesByManagedInstance.json
func ExampleManagedInstancesClient_NewListOutboundNetworkDependenciesByManagedInstancePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListOutboundNetworkDependenciesByManagedInstancePager("sqlcrudtest-7398", "testinstance", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutboundEnvironmentEndpointCollection = armsql.OutboundEnvironmentEndpointCollection{
		// 	Value: []*armsql.OutboundEnvironmentEndpoint{
		// 		{
		// 			Category: to.Ptr("Azure SQL Database"),
		// 			Endpoints: []*armsql.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("control.database.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("worker.database.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure Storage"),
		// 			Endpoints: []*armsql.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Service Bus"),
		// 			Endpoints: []*armsql.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("servicebus.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Certificate Verification"),
		// 			Endpoints: []*armsql.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("dsms.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("dsts.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("login.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Telemetry"),
		// 			Endpoints: []*armsql.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("azurewatsonanalysis-prod.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("global.metrics.nsatc.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("production.diagnostics.monitoring.core.windows.net"),
		// 					EndpointDetails: []*armsql.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/StartManagedInstance.json
func ExampleManagedInstancesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginStart(ctx, "startrg", "mitostart", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/StopManagedInstance.json
func ExampleManagedInstancesClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedInstancesClient().BeginStop(ctx, "stoprg", "mitostop", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceTopQueriesList.json
func ExampleManagedInstancesClient_NewListByManagedInstancePager_obtainListOfInstancesTopResourceConsumingQueries() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByManagedInstancePager("sqlcrudtest-7398", "sqlcrudtest-4645", &armsql.ManagedInstancesClientListByManagedInstanceOptions{NumberOfQueries: nil,
		Databases:           nil,
		StartTime:           nil,
		EndTime:             nil,
		Interval:            to.Ptr(armsql.QueryTimeGrainTypePT1H),
		AggregationFunction: nil,
		ObservationMetric:   to.Ptr(armsql.MetricTypeDuration),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TopQueriesListResult = armsql.TopQueriesListResult{
		// 	Value: []*armsql.TopQueries{
		// 		{
		// 			AggregationFunction: to.Ptr("sum"),
		// 			EndTime: to.Ptr("03/05/2020 13:00:00"),
		// 			IntervalType: to.Ptr(armsql.QueryTimeGrainTypeP1D),
		// 			NumberOfQueries: to.Ptr[int32](5),
		// 			ObservationMetric: to.Ptr("cpu"),
		// 			Queries: []*armsql.QueryStatisticsProperties{
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/03/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0015841714409722222),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.000004340277777777778),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](8336),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](11306905),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("25"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/03/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0009521432291666667),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](2.3148148148148148e-7),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](1024),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](6620020),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("21"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db3"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](104),
		// 							IntervalStartTime: to.Ptr("03/04/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0008006611689814815),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](5543088),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("3"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db2"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](89),
		// 							IntervalStartTime: to.Ptr("03/03/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0006882543402777778),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](4761877),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("3"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db3"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/04/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0006220661168981482),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](1024),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](4454161),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("22"),
		// 			}},
		// 			StartTime: to.Ptr("03/01/2020 00:00:00"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceTopQueriesListMax.json
func ExampleManagedInstancesClient_NewListByManagedInstancePager_obtainListOfInstancesTopResourceConsumingQueriesFullBlownRequestAndResponse() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByManagedInstancePager("sqlcrudtest-7398", "sqlcrudtest-4645", &armsql.ManagedInstancesClientListByManagedInstanceOptions{NumberOfQueries: nil,
		Databases:           to.Ptr("db1,db2"),
		StartTime:           to.Ptr("2020-03-10T12:00:00Z"),
		EndTime:             to.Ptr("2020-03-12T12:00:00Z"),
		Interval:            to.Ptr(armsql.QueryTimeGrainTypeP1D),
		AggregationFunction: nil,
		ObservationMetric:   to.Ptr(armsql.MetricTypeCPU),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TopQueriesListResult = armsql.TopQueriesListResult{
		// 	Value: []*armsql.TopQueries{
		// 		{
		// 			AggregationFunction: to.Ptr("sum"),
		// 			EndTime: to.Ptr("03/12/2020 13:00:00"),
		// 			IntervalType: to.Ptr(armsql.QueryTimeGrainTypeP1D),
		// 			NumberOfQueries: to.Ptr[int32](5),
		// 			ObservationMetric: to.Ptr("cpu"),
		// 			Queries: []*armsql.QueryStatisticsProperties{
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/11/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0015934667245370371),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.000004224537037037037),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](8336),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](11091296),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("28"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/11/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0009522783564814815),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](1.7361111111111112e-7),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](1024),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](6625562),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("24"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](82),
		// 							IntervalStartTime: to.Ptr("03/11/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0007183139467592593),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](4970199),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("3"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db1"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/11/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0006494454571759259),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.000005034722222222222),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](1024),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](4530668),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("29"),
		// 				},
		// 				{
		// 					DatabaseName: to.Ptr("db2"),
		// 					Intervals: []*armsql.QueryMetricInterval{
		// 						{
		// 							ExecutionCount: to.Ptr[int64](1),
		// 							IntervalStartTime: to.Ptr("03/11/2020 00:00:00"),
		// 							Metrics: []*armsql.QueryMetricProperties{
		// 								{
		// 									Name: to.Ptr("cpu"),
		// 									DisplayName: to.Ptr("Cpu"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0.0006275368923611112),
		// 								},
		// 								{
		// 									Name: to.Ptr("io"),
		// 									DisplayName: to.Ptr("Physical Io Reads"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("logIo"),
		// 									DisplayName: to.Ptr("Log Writes"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypePercentage),
		// 									Value: to.Ptr[float64](0),
		// 								},
		// 								{
		// 									Name: to.Ptr("memory"),
		// 									DisplayName: to.Ptr("Memory consumption"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeKB),
		// 									Value: to.Ptr[float64](1024),
		// 								},
		// 								{
		// 									Name: to.Ptr("duration"),
		// 									DisplayName: to.Ptr("Query duration"),
		// 									Unit: to.Ptr(armsql.QueryMetricUnitTypeMicroseconds),
		// 									Value: to.Ptr[float64](4349943),
		// 							}},
		// 					}},
		// 					QueryID: to.Ptr("25"),
		// 			}},
		// 			StartTime: to.Ptr("03/10/2020 00:00:00"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ManagedInstanceTopQueriesListMin.json
func ExampleManagedInstancesClient_NewListByManagedInstancePager_obtainListOfInstancesTopResourceConsumingQueriesMinimalRequestAndResponse() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedInstancesClient().NewListByManagedInstancePager("sqlcrudtest-7398", "sqlcrudtest-4645", &armsql.ManagedInstancesClientListByManagedInstanceOptions{NumberOfQueries: nil,
		Databases:           nil,
		StartTime:           nil,
		EndTime:             nil,
		Interval:            nil,
		AggregationFunction: nil,
		ObservationMetric:   nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TopQueriesListResult = armsql.TopQueriesListResult{
		// 	Value: []*armsql.TopQueries{
		// 		{
		// 			AggregationFunction: to.Ptr("sum"),
		// 			EndTime: to.Ptr("03/11/2020 12:24:07"),
		// 			IntervalType: to.Ptr(armsql.QueryTimeGrainTypePT1H),
		// 			NumberOfQueries: to.Ptr[int32](5),
		// 			ObservationMetric: to.Ptr("cpu"),
		// 			Queries: []*armsql.QueryStatisticsProperties{
		// 			},
		// 			StartTime: to.Ptr("03/10/2020 12:00:00"),
		// 	}},
		// }
	}
}
