// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/tool.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Function calling mode.
type FunctionCallingConfig_Mode int32

const (
	// Unspecified function calling mode. This value should not be used.
	FunctionCallingConfig_MODE_UNSPECIFIED FunctionCallingConfig_Mode = 0
	// Default model behavior, model decides to predict either a function call
	// or a natural language repspose.
	FunctionCallingConfig_AUTO FunctionCallingConfig_Mode = 1
	// Model is constrained to always predicting a function call only.
	// If "allowed_function_names" are set, the predicted function call will be
	// limited to any one of "allowed_function_names", else the predicted
	// function call will be any one of the provided "function_declarations".
	FunctionCallingConfig_ANY FunctionCallingConfig_Mode = 2
	// Model will not predict any function call. Model behavior is same as when
	// not passing any function declarations.
	FunctionCallingConfig_NONE FunctionCallingConfig_Mode = 3
)

// Enum value maps for FunctionCallingConfig_Mode.
var (
	FunctionCallingConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "AUTO",
		2: "ANY",
		3: "NONE",
	}
	FunctionCallingConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"AUTO":             1,
		"ANY":              2,
		"NONE":             3,
	}
)

func (x FunctionCallingConfig_Mode) Enum() *FunctionCallingConfig_Mode {
	p := new(FunctionCallingConfig_Mode)
	*p = x
	return p
}

func (x FunctionCallingConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FunctionCallingConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[0].Descriptor()
}

func (FunctionCallingConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[0]
}

func (x FunctionCallingConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FunctionCallingConfig_Mode.Descriptor instead.
func (FunctionCallingConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{10, 0}
}

// Tool details that the model may use to generate response.
//
// A `Tool` is a piece of code that enables the system to interact with
// external systems to perform an action, or set of actions, outside of
// knowledge and scope of the model. A Tool object should contain exactly
// one type of Tool (e.g FunctionDeclaration, Retrieval or
// GoogleSearchRetrieval).
type Tool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function tool type.
	// One or more function declarations to be passed to the model along with the
	// current user query. Model may decide to call a subset of these functions
	// by populating [FunctionCall][content.part.function_call] in the response.
	// User should provide a [FunctionResponse][content.part.function_response]
	// for each function call in the next turn. Based on the function responses,
	// Model will generate the final response back to the user.
	// Maximum 64 function declarations can be provided.
	FunctionDeclarations []*FunctionDeclaration `protobuf:"bytes,1,rep,name=function_declarations,json=functionDeclarations,proto3" json:"function_declarations,omitempty"`
	// Optional. Retrieval tool type.
	// System will always execute the provided retrieval tool(s) to get external
	// knowledge to answer the prompt. Retrieval results are presented to the
	// model for generation.
	Retrieval *Retrieval `protobuf:"bytes,2,opt,name=retrieval,proto3" json:"retrieval,omitempty"`
	// Optional. GoogleSearchRetrieval tool type.
	// Specialized retrieval tool that is powered by Google search.
	GoogleSearchRetrieval *GoogleSearchRetrieval `protobuf:"bytes,3,opt,name=google_search_retrieval,json=googleSearchRetrieval,proto3" json:"google_search_retrieval,omitempty"`
}

func (x *Tool) Reset() {
	*x = Tool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool) ProtoMessage() {}

func (x *Tool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool.ProtoReflect.Descriptor instead.
func (*Tool) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0}
}

func (x *Tool) GetFunctionDeclarations() []*FunctionDeclaration {
	if x != nil {
		return x.FunctionDeclarations
	}
	return nil
}

func (x *Tool) GetRetrieval() *Retrieval {
	if x != nil {
		return x.Retrieval
	}
	return nil
}

func (x *Tool) GetGoogleSearchRetrieval() *GoogleSearchRetrieval {
	if x != nil {
		return x.GoogleSearchRetrieval
	}
	return nil
}

// A single example of the tool usage.
type ToolUseExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target tool to use.
	//
	// Types that are assignable to Target:
	//
	//	*ToolUseExample_ExtensionOperation_
	//	*ToolUseExample_FunctionName
	Target isToolUseExample_Target `protobuf_oneof:"Target"`
	// Required. The display name for example.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Query that should be routed to this tool.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Request parameters used for executing this tool.
	RequestParams *structpb.Struct `protobuf:"bytes,3,opt,name=request_params,json=requestParams,proto3" json:"request_params,omitempty"`
	// Response parameters generated by this tool.
	ResponseParams *structpb.Struct `protobuf:"bytes,4,opt,name=response_params,json=responseParams,proto3" json:"response_params,omitempty"`
	// Summary of the tool response to the user query.
	ResponseSummary string `protobuf:"bytes,5,opt,name=response_summary,json=responseSummary,proto3" json:"response_summary,omitempty"`
}

func (x *ToolUseExample) Reset() {
	*x = ToolUseExample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolUseExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUseExample) ProtoMessage() {}

func (x *ToolUseExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUseExample.ProtoReflect.Descriptor instead.
func (*ToolUseExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{1}
}

func (m *ToolUseExample) GetTarget() isToolUseExample_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *ToolUseExample) GetExtensionOperation() *ToolUseExample_ExtensionOperation {
	if x, ok := x.GetTarget().(*ToolUseExample_ExtensionOperation_); ok {
		return x.ExtensionOperation
	}
	return nil
}

func (x *ToolUseExample) GetFunctionName() string {
	if x, ok := x.GetTarget().(*ToolUseExample_FunctionName); ok {
		return x.FunctionName
	}
	return ""
}

func (x *ToolUseExample) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ToolUseExample) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ToolUseExample) GetRequestParams() *structpb.Struct {
	if x != nil {
		return x.RequestParams
	}
	return nil
}

func (x *ToolUseExample) GetResponseParams() *structpb.Struct {
	if x != nil {
		return x.ResponseParams
	}
	return nil
}

func (x *ToolUseExample) GetResponseSummary() string {
	if x != nil {
		return x.ResponseSummary
	}
	return ""
}

type isToolUseExample_Target interface {
	isToolUseExample_Target()
}

type ToolUseExample_ExtensionOperation_ struct {
	// Extension operation to call.
	ExtensionOperation *ToolUseExample_ExtensionOperation `protobuf:"bytes,10,opt,name=extension_operation,json=extensionOperation,proto3,oneof"`
}

type ToolUseExample_FunctionName struct {
	// Function name to call.
	FunctionName string `protobuf:"bytes,11,opt,name=function_name,json=functionName,proto3,oneof"`
}

func (*ToolUseExample_ExtensionOperation_) isToolUseExample_Target() {}

func (*ToolUseExample_FunctionName) isToolUseExample_Target() {}

// Structured representation of a function declaration as defined by the
// [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3). Included
// in this declaration are the function name and parameters. This
// FunctionDeclaration is a representation of a block of code that can be used
// as a `Tool` by the model and executed by the client.
type FunctionDeclaration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to call.
	// Must start with a letter or an underscore.
	// Must be a-z, A-Z, 0-9, or contain underscores, dots and dashes, with a
	// maximum length of 64.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description and purpose of the function.
	// Model uses it to decide how and whether to call the function.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Describes the parameters to this function in JSON Schema Object
	// format. Reflects the Open API 3.03 Parameter Object. string Key: the name
	// of the parameter. Parameter names are case sensitive. Schema Value: the
	// Schema defining the type used for the parameter. For function with no
	// parameters, this can be left unset. Parameter names must start with a
	// letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
	// underscores with a maximum length of 64. Example with 1 required and 1
	// optional parameter: type: OBJECT properties:
	//
	//	param1:
	//	  type: STRING
	//	param2:
	//	  type: INTEGER
	//
	// required:
	//   - param1
	Parameters *Schema `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. Describes the output from this function in JSON Schema format.
	// Reflects the Open API 3.03 Response Object. The Schema defines the type
	// used for the response value of the function.
	Response *Schema `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *FunctionDeclaration) Reset() {
	*x = FunctionDeclaration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionDeclaration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionDeclaration) ProtoMessage() {}

func (x *FunctionDeclaration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionDeclaration.ProtoReflect.Descriptor instead.
func (*FunctionDeclaration) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{2}
}

func (x *FunctionDeclaration) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionDeclaration) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FunctionDeclaration) GetParameters() *Schema {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *FunctionDeclaration) GetResponse() *Schema {
	if x != nil {
		return x.Response
	}
	return nil
}

// A predicted [FunctionCall] returned from the model that contains a string
// representing the [FunctionDeclaration.name] and a structured JSON object
// containing the parameters and their values.
type FunctionCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to call.
	// Matches [FunctionDeclaration.name].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Required. The function parameters and values in JSON object
	// format. See [FunctionDeclaration.parameters] for parameter details.
	Args *structpb.Struct `protobuf:"bytes,2,opt,name=args,proto3" json:"args,omitempty"`
}

func (x *FunctionCall) Reset() {
	*x = FunctionCall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionCall) ProtoMessage() {}

func (x *FunctionCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionCall.ProtoReflect.Descriptor instead.
func (*FunctionCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{3}
}

func (x *FunctionCall) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionCall) GetArgs() *structpb.Struct {
	if x != nil {
		return x.Args
	}
	return nil
}

// The result output from a [FunctionCall] that contains a string representing
// the [FunctionDeclaration.name] and a structured JSON object containing any
// output from the function is used as context to the model. This should contain
// the result of a [FunctionCall] made based on model prediction.
type FunctionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to call.
	// Matches [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The function response in JSON object format.
	Response *structpb.Struct `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *FunctionResponse) Reset() {
	*x = FunctionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionResponse) ProtoMessage() {}

func (x *FunctionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionResponse.ProtoReflect.Descriptor instead.
func (*FunctionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{4}
}

func (x *FunctionResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionResponse) GetResponse() *structpb.Struct {
	if x != nil {
		return x.Response
	}
	return nil
}

// Defines a retrieval tool that model can call to access external knowledge.
type Retrieval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*Retrieval_VertexAiSearch
	//	*Retrieval_VertexRagStore
	Source isRetrieval_Source `protobuf_oneof:"source"`
	// Optional. Disable using the result from this tool in detecting grounding
	// attribution. This does not affect how the result is given to the model for
	// generation.
	DisableAttribution bool `protobuf:"varint,3,opt,name=disable_attribution,json=disableAttribution,proto3" json:"disable_attribution,omitempty"`
}

func (x *Retrieval) Reset() {
	*x = Retrieval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Retrieval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Retrieval) ProtoMessage() {}

func (x *Retrieval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Retrieval.ProtoReflect.Descriptor instead.
func (*Retrieval) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{5}
}

func (m *Retrieval) GetSource() isRetrieval_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Retrieval) GetVertexAiSearch() *VertexAISearch {
	if x, ok := x.GetSource().(*Retrieval_VertexAiSearch); ok {
		return x.VertexAiSearch
	}
	return nil
}

func (x *Retrieval) GetVertexRagStore() *VertexRagStore {
	if x, ok := x.GetSource().(*Retrieval_VertexRagStore); ok {
		return x.VertexRagStore
	}
	return nil
}

func (x *Retrieval) GetDisableAttribution() bool {
	if x != nil {
		return x.DisableAttribution
	}
	return false
}

type isRetrieval_Source interface {
	isRetrieval_Source()
}

type Retrieval_VertexAiSearch struct {
	// Set to use data source powered by Vertex AI Search.
	VertexAiSearch *VertexAISearch `protobuf:"bytes,2,opt,name=vertex_ai_search,json=vertexAiSearch,proto3,oneof"`
}

type Retrieval_VertexRagStore struct {
	// Set to use data source powered by Vertex RAG store.
	// User data is uploaded via the VertexRagDataService.
	VertexRagStore *VertexRagStore `protobuf:"bytes,4,opt,name=vertex_rag_store,json=vertexRagStore,proto3,oneof"`
}

func (*Retrieval_VertexAiSearch) isRetrieval_Source() {}

func (*Retrieval_VertexRagStore) isRetrieval_Source() {}

// Retrieve from Vertex RAG Store for grounding.
type VertexRagStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Deprecated. Please use rag_resources instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
	RagCorpora []string `protobuf:"bytes,1,rep,name=rag_corpora,json=ragCorpora,proto3" json:"rag_corpora,omitempty"`
	// Optional. The representation of the rag source. It can be used to specify
	// corpus only or ragfiles. Currently only support one corpus or multiple
	// files from one corpus. In the future we may open up multiple corpora
	// support.
	RagResources []*VertexRagStore_RagResource `protobuf:"bytes,4,rep,name=rag_resources,json=ragResources,proto3" json:"rag_resources,omitempty"`
	// Optional. Number of top k results to return from the selected corpora.
	SimilarityTopK *int32 `protobuf:"varint,2,opt,name=similarity_top_k,json=similarityTopK,proto3,oneof" json:"similarity_top_k,omitempty"`
	// Optional. Only return results with vector distance smaller than the
	// threshold.
	VectorDistanceThreshold *float64 `protobuf:"fixed64,3,opt,name=vector_distance_threshold,json=vectorDistanceThreshold,proto3,oneof" json:"vector_distance_threshold,omitempty"`
}

func (x *VertexRagStore) Reset() {
	*x = VertexRagStore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexRagStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexRagStore) ProtoMessage() {}

func (x *VertexRagStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexRagStore.ProtoReflect.Descriptor instead.
func (*VertexRagStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{6}
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
func (x *VertexRagStore) GetRagCorpora() []string {
	if x != nil {
		return x.RagCorpora
	}
	return nil
}

func (x *VertexRagStore) GetRagResources() []*VertexRagStore_RagResource {
	if x != nil {
		return x.RagResources
	}
	return nil
}

func (x *VertexRagStore) GetSimilarityTopK() int32 {
	if x != nil && x.SimilarityTopK != nil {
		return *x.SimilarityTopK
	}
	return 0
}

func (x *VertexRagStore) GetVectorDistanceThreshold() float64 {
	if x != nil && x.VectorDistanceThreshold != nil {
		return *x.VectorDistanceThreshold
	}
	return 0
}

// Retrieve from Vertex AI Search datastore for grounding.
// See https://cloud.google.com/vertex-ai-search-and-conversation
type VertexAISearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully-qualified Vertex AI Search's datastore resource ID.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
	Datastore string `protobuf:"bytes,1,opt,name=datastore,proto3" json:"datastore,omitempty"`
}

func (x *VertexAISearch) Reset() {
	*x = VertexAISearch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexAISearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAISearch) ProtoMessage() {}

func (x *VertexAISearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAISearch.ProtoReflect.Descriptor instead.
func (*VertexAISearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{7}
}

func (x *VertexAISearch) GetDatastore() string {
	if x != nil {
		return x.Datastore
	}
	return ""
}

// Tool to retrieve public web data for grounding, powered by Google.
type GoogleSearchRetrieval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Disable using the result from this tool in detecting grounding
	// attribution. This does not affect how the result is given to the model for
	// generation.
	DisableAttribution bool `protobuf:"varint,1,opt,name=disable_attribution,json=disableAttribution,proto3" json:"disable_attribution,omitempty"`
}

func (x *GoogleSearchRetrieval) Reset() {
	*x = GoogleSearchRetrieval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleSearchRetrieval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleSearchRetrieval) ProtoMessage() {}

func (x *GoogleSearchRetrieval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleSearchRetrieval.ProtoReflect.Descriptor instead.
func (*GoogleSearchRetrieval) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{8}
}

func (x *GoogleSearchRetrieval) GetDisableAttribution() bool {
	if x != nil {
		return x.DisableAttribution
	}
	return false
}

// Tool config. This config is shared for all tools provided in the request.
type ToolConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function calling config.
	FunctionCallingConfig *FunctionCallingConfig `protobuf:"bytes,1,opt,name=function_calling_config,json=functionCallingConfig,proto3" json:"function_calling_config,omitempty"`
}

func (x *ToolConfig) Reset() {
	*x = ToolConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolConfig) ProtoMessage() {}

func (x *ToolConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolConfig.ProtoReflect.Descriptor instead.
func (*ToolConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{9}
}

func (x *ToolConfig) GetFunctionCallingConfig() *FunctionCallingConfig {
	if x != nil {
		return x.FunctionCallingConfig
	}
	return nil
}

// Function calling config.
type FunctionCallingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function calling mode.
	Mode FunctionCallingConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.aiplatform.v1beta1.FunctionCallingConfig_Mode" json:"mode,omitempty"`
	// Optional. Function names to call. Only set when the Mode is ANY. Function
	// names should match [FunctionDeclaration.name]. With mode set to ANY, model
	// will predict a function call from the set of function names provided.
	AllowedFunctionNames []string `protobuf:"bytes,2,rep,name=allowed_function_names,json=allowedFunctionNames,proto3" json:"allowed_function_names,omitempty"`
}

func (x *FunctionCallingConfig) Reset() {
	*x = FunctionCallingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionCallingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionCallingConfig) ProtoMessage() {}

func (x *FunctionCallingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionCallingConfig.ProtoReflect.Descriptor instead.
func (*FunctionCallingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{10}
}

func (x *FunctionCallingConfig) GetMode() FunctionCallingConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return FunctionCallingConfig_MODE_UNSPECIFIED
}

func (x *FunctionCallingConfig) GetAllowedFunctionNames() []string {
	if x != nil {
		return x.AllowedFunctionNames
	}
	return nil
}

// Identifies one operation of the extension.
type ToolUseExample_ExtensionOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the extension.
	Extension string `protobuf:"bytes,1,opt,name=extension,proto3" json:"extension,omitempty"`
	// Required. Operation ID of the extension.
	OperationId string `protobuf:"bytes,2,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
}

func (x *ToolUseExample_ExtensionOperation) Reset() {
	*x = ToolUseExample_ExtensionOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolUseExample_ExtensionOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUseExample_ExtensionOperation) ProtoMessage() {}

func (x *ToolUseExample_ExtensionOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUseExample_ExtensionOperation.ProtoReflect.Descriptor instead.
func (*ToolUseExample_ExtensionOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ToolUseExample_ExtensionOperation) GetExtension() string {
	if x != nil {
		return x.Extension
	}
	return ""
}

func (x *ToolUseExample_ExtensionOperation) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

// The definition of the Rag resource.
type VertexRagStore_RagResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RagCorpora resource name.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	RagCorpus string `protobuf:"bytes,1,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
	// Optional. rag_file_id. The files should be in the same rag_corpus set in
	// rag_corpus field.
	RagFileIds []string `protobuf:"bytes,2,rep,name=rag_file_ids,json=ragFileIds,proto3" json:"rag_file_ids,omitempty"`
}

func (x *VertexRagStore_RagResource) Reset() {
	*x = VertexRagStore_RagResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexRagStore_RagResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexRagStore_RagResource) ProtoMessage() {}

func (x *VertexRagStore_RagResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexRagStore_RagResource.ProtoReflect.Descriptor instead.
func (*VertexRagStore_RagResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{6, 0}
}

func (x *VertexRagStore_RagResource) GetRagCorpus() string {
	if x != nil {
		return x.RagCorpus
	}
	return ""
}

func (x *VertexRagStore_RagResource) GetRagFileIds() []string {
	if x != nil {
		return x.RagFileIds
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_tool_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xba, 0x02, 0x0a, 0x04, 0x54, 0x6f, 0x6f, 0x6c, 0x12,
	0x6e, 0x0a, 0x15, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x63, 0x6c,
	0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x4d, 0x0a, 0x09, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x73,
	0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x61, 0x6c, 0x22, 0xaf, 0x04, 0x0a, 0x0e, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x75, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x1a, 0x84, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x09, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xed, 0x01, 0x0a, 0x13, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30,
	0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73,
	0x22, 0x65, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x09, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x5b, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f,
	0x61, 0x69, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x69, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x5b, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52,
	0x0e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x34, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0xf7, 0x03, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x52, 0x0a, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x12, 0x65, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x61, 0x67,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x10, 0x73, 0x69, 0x6d,
	0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x69, 0x6d, 0x69,
	0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a,
	0x19, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x17, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x88, 0x01, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12,
	0x25, 0x0a, 0x0c, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x69, 0x6d, 0x69, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x42, 0x1c, 0x0a, 0x1a, 0x5f,
	0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0x33, 0x0a, 0x0e, 0x56, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x21, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x4d,
	0x0a, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x34, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01,
	0x0a, 0x0a, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x17,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xe3, 0x01, 0x0a, 0x15, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x12, 0x39, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x39, 0x0a, 0x04,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55,
	0x54, 0x4f, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x42, 0xe0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42,
	0x09, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70,
	0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes = []interface{}{
	(FunctionCallingConfig_Mode)(0),           // 0: google.cloud.aiplatform.v1beta1.FunctionCallingConfig.Mode
	(*Tool)(nil),                              // 1: google.cloud.aiplatform.v1beta1.Tool
	(*ToolUseExample)(nil),                    // 2: google.cloud.aiplatform.v1beta1.ToolUseExample
	(*FunctionDeclaration)(nil),               // 3: google.cloud.aiplatform.v1beta1.FunctionDeclaration
	(*FunctionCall)(nil),                      // 4: google.cloud.aiplatform.v1beta1.FunctionCall
	(*FunctionResponse)(nil),                  // 5: google.cloud.aiplatform.v1beta1.FunctionResponse
	(*Retrieval)(nil),                         // 6: google.cloud.aiplatform.v1beta1.Retrieval
	(*VertexRagStore)(nil),                    // 7: google.cloud.aiplatform.v1beta1.VertexRagStore
	(*VertexAISearch)(nil),                    // 8: google.cloud.aiplatform.v1beta1.VertexAISearch
	(*GoogleSearchRetrieval)(nil),             // 9: google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval
	(*ToolConfig)(nil),                        // 10: google.cloud.aiplatform.v1beta1.ToolConfig
	(*FunctionCallingConfig)(nil),             // 11: google.cloud.aiplatform.v1beta1.FunctionCallingConfig
	(*ToolUseExample_ExtensionOperation)(nil), // 12: google.cloud.aiplatform.v1beta1.ToolUseExample.ExtensionOperation
	(*VertexRagStore_RagResource)(nil),        // 13: google.cloud.aiplatform.v1beta1.VertexRagStore.RagResource
	(*structpb.Struct)(nil),                   // 14: google.protobuf.Struct
	(*Schema)(nil),                            // 15: google.cloud.aiplatform.v1beta1.Schema
}
var file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs = []int32{
	3,  // 0: google.cloud.aiplatform.v1beta1.Tool.function_declarations:type_name -> google.cloud.aiplatform.v1beta1.FunctionDeclaration
	6,  // 1: google.cloud.aiplatform.v1beta1.Tool.retrieval:type_name -> google.cloud.aiplatform.v1beta1.Retrieval
	9,  // 2: google.cloud.aiplatform.v1beta1.Tool.google_search_retrieval:type_name -> google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval
	12, // 3: google.cloud.aiplatform.v1beta1.ToolUseExample.extension_operation:type_name -> google.cloud.aiplatform.v1beta1.ToolUseExample.ExtensionOperation
	14, // 4: google.cloud.aiplatform.v1beta1.ToolUseExample.request_params:type_name -> google.protobuf.Struct
	14, // 5: google.cloud.aiplatform.v1beta1.ToolUseExample.response_params:type_name -> google.protobuf.Struct
	15, // 6: google.cloud.aiplatform.v1beta1.FunctionDeclaration.parameters:type_name -> google.cloud.aiplatform.v1beta1.Schema
	15, // 7: google.cloud.aiplatform.v1beta1.FunctionDeclaration.response:type_name -> google.cloud.aiplatform.v1beta1.Schema
	14, // 8: google.cloud.aiplatform.v1beta1.FunctionCall.args:type_name -> google.protobuf.Struct
	14, // 9: google.cloud.aiplatform.v1beta1.FunctionResponse.response:type_name -> google.protobuf.Struct
	8,  // 10: google.cloud.aiplatform.v1beta1.Retrieval.vertex_ai_search:type_name -> google.cloud.aiplatform.v1beta1.VertexAISearch
	7,  // 11: google.cloud.aiplatform.v1beta1.Retrieval.vertex_rag_store:type_name -> google.cloud.aiplatform.v1beta1.VertexRagStore
	13, // 12: google.cloud.aiplatform.v1beta1.VertexRagStore.rag_resources:type_name -> google.cloud.aiplatform.v1beta1.VertexRagStore.RagResource
	11, // 13: google.cloud.aiplatform.v1beta1.ToolConfig.function_calling_config:type_name -> google.cloud.aiplatform.v1beta1.FunctionCallingConfig
	0,  // 14: google.cloud.aiplatform.v1beta1.FunctionCallingConfig.mode:type_name -> google.cloud.aiplatform.v1beta1.FunctionCallingConfig.Mode
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_tool_proto_init() }
func file_google_cloud_aiplatform_v1beta1_tool_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_tool_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_openapi_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolUseExample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionDeclaration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionCall); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Retrieval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexRagStore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexAISearch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleSearchRetrieval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionCallingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolUseExample_ExtensionOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexRagStore_RagResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ToolUseExample_ExtensionOperation_)(nil),
		(*ToolUseExample_FunctionName)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Retrieval_VertexAiSearch)(nil),
		(*Retrieval_VertexRagStore)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_tool_proto = out.File
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs = nil
}
